/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.generators;

import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.generators.AbstractJAXWSGenerator;

public class AntGenerator
extends AbstractJAXWSGenerator {
    private static final String ANT_TEMPLATE = "org/apache/cxf/tools/wsdlto/frontend/jaxws/template/build.vm";

    public AntGenerator() {
        this.name = "ant.generator";
    }

    public boolean passthrough() {
        return !this.env.optionSet("ant") && !this.env.optionSet("all") && !this.env.optionSet("genAnt");
    }

    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        JavaModel javaModel = this.env.get(JavaModel.class);
        if (this.passthrough()) {
            return;
        }
        if (javaModel.getServiceClasses().size() == 0) {
            ServiceInfo serviceInfo = this.env.get(ServiceInfo.class);
            String wsdl = serviceInfo.getDescription().getBaseURI();
            Message msg = new Message("CAN_NOT_GEN_ANT", LOG, wsdl);
            if (penv.isVerbose()) {
                System.out.println(msg.toString());
            }
            return;
        }
        this.clearAttributes();
        this.setAttributes("intfs", javaModel.getInterfaces().values());
        this.setAttributes("wsdlLocation", javaModel.getLocation());
        this.setCommonAttributes();
        this.doWrite(ANT_TEMPLATE, this.parseOutputName(null, "build", ".xml"));
    }
}

