/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.local;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.local.LocalDestination;
import org.apache.cxf.transport.local.LocalTransportFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalConduit
extends AbstractConduit {
    public static final String IN_CONDUIT = LocalConduit.class.getName() + ".inConduit";
    public static final String RESPONSE_CONDUIT = LocalConduit.class.getName() + ".inConduit";
    public static final String IN_EXCHANGE = LocalConduit.class.getName() + ".inExchange";
    public static final String DIRECT_DISPATCH = LocalConduit.class.getName() + ".directDispatch";
    public static final String MESSAGE_FILTER_PROPERTIES = LocalConduit.class.getName() + ".filterProperties";
    private static final Logger LOG = LogUtils.getL7dLogger(LocalConduit.class);
    private LocalDestination destination;
    private LocalTransportFactory transportFactory;

    public LocalConduit(LocalTransportFactory transportFactory, LocalDestination destination) {
        super(destination.getAddress());
        this.destination = destination;
        this.transportFactory = transportFactory;
    }

    @Override
    public void prepare(Message message) throws IOException {
        if (!Boolean.TRUE.equals(message.get(DIRECT_DISPATCH))) {
            this.dispatchViaPipe(message);
        }
    }

    @Override
    public void close(Message message) throws IOException {
        if (Boolean.TRUE.equals(message.get(DIRECT_DISPATCH)) && !Boolean.TRUE.equals(message.get("org.apache.cxf.message.inbound"))) {
            this.dispatchDirect(message);
        }
        super.close(message);
    }

    private void dispatchDirect(Message message) {
        if (this.destination.getMessageObserver() == null) {
            throw new IllegalStateException("Local destination does not have a MessageObserver on address " + this.destination.getAddress().getAddress().getValue());
        }
        MessageImpl copy = new MessageImpl();
        copy.put(IN_CONDUIT, this);
        copy.setDestination(this.destination);
        LocalConduit.copy(message, copy, this.transportFactory.getMessageFilterProperties());
        ExchangeImpl ex = new ExchangeImpl();
        ex.setInMessage(copy);
        ex.put(IN_EXCHANGE, message.getExchange());
        ex.setDestination(this.destination);
        this.destination.getMessageObserver().onMessage(copy);
    }

    public static void copy(Message message, MessageImpl copy, Set<String> defaultFilter) {
        Set<Object> filter = CastUtils.cast((Set)message.get(MESSAGE_FILTER_PROPERTIES));
        if (filter == null) {
            filter = defaultFilter;
        }
        for (Map.Entry e : message.entrySet()) {
            if (filter.contains(e.getKey())) continue;
            copy.put(e.getKey(), e.getValue());
        }
        MessageImpl.copyContent(message, copy);
    }

    private void dispatchViaPipe(Message message) throws IOException {
        final PipedInputStream stream = new PipedInputStream();
        final LocalConduit conduit = this;
        final Exchange exchange = message.getExchange();
        if (this.destination.getMessageObserver() == null) {
            throw new IllegalStateException("Local destination does not have a MessageObserver on address " + this.destination.getAddress().getAddress().getValue());
        }
        Runnable receiver = new Runnable(){

            public void run() {
                MessageImpl inMsg = new MessageImpl();
                inMsg.setContent(InputStream.class, stream);
                inMsg.setDestination(LocalConduit.this.destination);
                inMsg.put(IN_CONDUIT, conduit);
                ExchangeImpl ex = new ExchangeImpl();
                ex.setInMessage(inMsg);
                ex.put(IN_EXCHANGE, exchange);
                LocalConduit.this.destination.getMessageObserver().onMessage(inMsg);
            }
        };
        message.setContent(OutputStream.class, new PipedOutputStream(stream));
        new Thread(receiver).start();
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

