/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy.builder.primitive;

import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertion;
import org.apache.neethi.All;
import org.apache.neethi.Assertion;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NestedPrimitiveAssertion
extends PrimitiveAssertion {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(NestedPrimitiveAssertion.class);
    private Policy nested;

    protected NestedPrimitiveAssertion(QName name, boolean optional) {
        super(name, optional);
    }

    public NestedPrimitiveAssertion(Element elem, PolicyBuilder builder) {
        super(elem);
        Element policyElem = null;
        for (Node nd = elem.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            if (1 != nd.getNodeType()) continue;
            QName qn = new QName(nd.getNamespaceURI(), nd.getLocalName());
            if (PolicyConstants.getPolicyElemQName().equals(qn) && null == policyElem) {
                policyElem = (Element)nd;
                continue;
            }
            throw new PolicyException(new Message("UNEXPECTED_CHILD_ELEMENT_EXC", BUNDLE, PolicyConstants.getPolicyElemQName()));
        }
        if (null == policyElem) {
            throw new PolicyException(new Message("UNEXPECTED_CHILD_ELEMENT_EXC", BUNDLE, PolicyConstants.getPolicyElemQName()));
        }
        this.nested = builder.getPolicy(policyElem);
    }

    public PolicyComponent normalize() {
        Policy normalisedNested = (Policy)this.nested.normalize(true);
        Policy p = new Policy();
        ExactlyOne ea = new ExactlyOne();
        p.addPolicyComponent((PolicyComponent)ea);
        if (this.isOptional()) {
            ea.addPolicyComponent((PolicyComponent)new All());
        }
        Iterator alternatives = normalisedNested.getAlternatives();
        while (alternatives.hasNext()) {
            All all = new All();
            List<Assertion> alternative = CastUtils.cast((List)alternatives.next(), Assertion.class);
            NestedPrimitiveAssertion a = new NestedPrimitiveAssertion(this.getName(), false);
            a.nested = new Policy();
            ExactlyOne nea = new ExactlyOne();
            a.nested.addPolicyComponent((PolicyComponent)nea);
            All na = new All();
            nea.addPolicyComponent((PolicyComponent)na);
            na.addPolicyComponents(alternative);
            all.addPolicyComponent((PolicyComponent)a);
            ea.addPolicyComponent((PolicyComponent)all);
        }
        return p;
    }

    public Policy getNested() {
        return this.nested;
    }

    public boolean equal(PolicyComponent policyComponent) {
        if (!super.equal(policyComponent)) {
            return false;
        }
        NestedPrimitiveAssertion other = (NestedPrimitiveAssertion)policyComponent;
        return this.getNested().equal((PolicyComponent)other.getNested());
    }

    protected void setNested(Policy n) {
        this.nested = n;
    }
}

