/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend;

import java.util.Map;
import org.apache.cxf.BusException;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.AbstractEndpointFactory;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;

public class ClientFactoryBean
extends AbstractEndpointFactory {
    private Client client;

    public ClientFactoryBean() {
        this.setServiceFactory(new ReflectionServiceFactoryBean());
    }

    public Client create() {
        if (this.client != null) {
            return this.client;
        }
        this.applyExtraClass();
        try {
            Endpoint ep = this.createEndpoint();
            this.createClient(ep);
        }
        catch (EndpointException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        catch (BusException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        this.applyFeatures();
        return this.client;
    }

    protected void createClient(Endpoint ep) {
        this.client = new ClientImpl(this.getBus(), ep, this.getConduitSelector());
    }

    protected void applyFeatures() {
        if (this.getFeatures() != null) {
            for (AbstractFeature feature : this.getFeatures()) {
                feature.initialize(this.client, this.getBus());
            }
        }
    }

    protected void applyExtraClass() {
        Map<String, Object> props;
        DataBinding dataBinding = this.getServiceFactory().getDataBinding();
        if (dataBinding instanceof JAXBDataBinding && (props = this.getProperties()) != null && props.get("jaxb.additionalContextClasses") != null) {
            Class[] extraClass = (Class[])this.getProperties().get("jaxb.additionalContextClasses");
            ((JAXBDataBinding)dataBinding).setExtraClass(extraClass);
        }
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }
}

