/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler.soap;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Binding;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.interceptor.MustUnderstandInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapActionInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.jaxws.handler.AbstractProtocolHandlerInterceptor;
import org.apache.cxf.jaxws.handler.HandlerChainInvoker;
import org.apache.cxf.jaxws.handler.soap.SOAPMessageContextImpl;
import org.apache.cxf.jaxws.support.ContextPropertiesMapping;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.transport.MessageObserver;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPHandlerInterceptor
extends AbstractProtocolHandlerInterceptor<SoapMessage>
implements SoapInterceptor {
    private static final SAAJOutInterceptor SAAJ_OUT = new SAAJOutInterceptor();
    AbstractSoapInterceptor ending = new AbstractSoapInterceptor(SOAPHandlerInterceptor.class.getName() + ".ENDING", "user-protocol"){

        public void handleMessage(SoapMessage message) throws Fault {
            SOAPHandlerInterceptor.this.handleMessageInternal(message);
        }
    };

    public SOAPHandlerInterceptor(Binding binding) {
        super(binding, "pre-protocol");
        this.addAfter(MustUnderstandInterceptor.class.getName());
        this.addAfter(SAAJOutInterceptor.class.getName());
    }

    public Set<URI> getRoles() {
        HashSet<URI> roles = new HashSet<URI>();
        return roles;
    }

    public Set<QName> getUnderstoodHeaders() {
        HashSet<QName> understood = new HashSet<QName>();
        for (Handler h : this.getBinding().getHandlerChain()) {
            Set headers;
            if (!(h instanceof SOAPHandler) || (headers = CastUtils.cast((Set)((SOAPHandler)h).getHeaders())) == null) continue;
            understood.addAll(headers);
        }
        return understood;
    }

    @Override
    public void handleMessage(SoapMessage message) {
        if (this.getInvoker(message).getProtocolHandlers().isEmpty()) {
            return;
        }
        if (this.getInvoker(message).isOutbound()) {
            SAAJ_OUT.handleMessage(message);
            message.getInterceptorChain().add((Interceptor)this.ending);
        } else {
            this.handleMessageInternal(message);
            SOAPMessage msg = (SOAPMessage)message.getContent(SOAPMessage.class);
            if (msg != null) {
                XMLStreamReader xmlReader = this.createXMLStreamReaderFromSOAPMessage(msg);
                message.setContent(XMLStreamReader.class, (Object)xmlReader);
                try {
                    SAAJInInterceptor.replaceHeaders((SOAPMessage)msg, (SoapMessage)message);
                }
                catch (SOAPException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void handleMessageInternal(SoapMessage message) {
        MessageContext context = this.createProtocolMessageContext(message);
        HandlerChainInvoker invoker = this.getInvoker(message);
        invoker.setProtocolMessageContext(context);
        if (!invoker.invokeProtocolHandlers(this.isRequestor(message), context)) {
            this.handleAbort(message, context);
        }
        if (this.isRequestor(message) && invoker.getLogicalHandlers().isEmpty() && !this.isOutbound(message) && this.isMEPComlete(message)) {
            this.onCompletion(message);
        } else if (this.isOutbound(message) && this.isMEPComlete(message)) {
            this.onCompletion(message);
        }
    }

    private void handleAbort(SoapMessage message, MessageContext context) {
        if (this.isRequestor(message)) {
            if (this.getInvoker(message).isOutbound()) {
                message.getInterceptorChain().abort();
                Endpoint e = (Endpoint)message.getExchange().get(Endpoint.class);
                Message responseMsg = e.getBinding().createMessage();
                MessageObserver observer = (MessageObserver)message.getExchange().get(MessageObserver.class);
                if (observer != null) {
                    message.getExchange().setInMessage(responseMsg);
                    SOAPMessage soapMessage = ((SOAPMessageContext)context).getMessage();
                    if (soapMessage != null) {
                        responseMsg.setContent(SOAPMessage.class, (Object)soapMessage);
                        XMLStreamReader xmlReader = this.createXMLStreamReaderFromSOAPMessage(soapMessage);
                        responseMsg.setContent(XMLStreamReader.class, (Object)xmlReader);
                    }
                    responseMsg.put((Object)"starting_at_interceptor_id", (Object)SOAPHandlerInterceptor.class.getName());
                    observer.onMessage(responseMsg);
                }
            } else {
                this.onCompletion(message);
            }
        } else if (!this.getInvoker(message).isOutbound()) {
            message.getInterceptorChain().abort();
            Endpoint e = (Endpoint)message.getExchange().get(Endpoint.class);
            Message responseMsg = e.getBinding().createMessage();
            if (!message.getExchange().isOneWay()) {
                message.getExchange().setOutMessage(responseMsg);
                SOAPMessage soapMessage = ((SOAPMessageContext)context).getMessage();
                responseMsg.setContent(SOAPMessage.class, (Object)soapMessage);
                InterceptorChain chain = OutgoingChainInterceptor.getOutInterceptorChain((Exchange)message.getExchange());
                responseMsg.setInterceptorChain(chain);
                chain.doInterceptStartingAfter(responseMsg, SoapActionInterceptor.class.getName());
            }
        }
    }

    @Override
    protected MessageContext createProtocolMessageContext(SoapMessage message) {
        SOAPMessageContextImpl sm = new SOAPMessageContextImpl((Message)message);
        boolean requestor = this.isRequestor(message);
        ContextPropertiesMapping.mapCxf2Jaxws(message.getExchange(), sm, requestor);
        return sm;
    }

    private XMLStreamReader createXMLStreamReaderFromSOAPMessage(SOAPMessage soapMessage) {
        XMLStreamReader xmlReader = null;
        try {
            DOMSource bodySource = new DOMSource((Node)soapMessage.getSOAPPart().getEnvelope().getBody());
            xmlReader = StaxUtils.createXMLStreamReader((Source)bodySource);
            xmlReader.nextTag();
            xmlReader.nextTag();
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return xmlReader;
    }

    public void handleFault(SoapMessage message) {
    }
}

