/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.core.logging;

import java.io.Writer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.cxf.jca.core.logging.WriterHandler;

public final class LoggerHelper {
    public static final Level DEFAULT_LOG_LEVEL = Level.WARNING;
    public static final String CONSOLE_HANDLER = "ConsoleHandler";
    public static final String WRITER_HANDLER = "WriterHandler";
    private static String rootLoggerName = "org.apache.cxf";
    private static boolean initComplete;
    private static Level currentLogLevel;

    private LoggerHelper() {
    }

    public static void initializeLoggingOnWriter(Writer writer) {
        if (writer != null) {
            if (writer.getClass().getName().startsWith("org.jboss")) {
                return;
            }
            Logger cxfLogger = LoggerHelper.getRootCXFLogger();
            if (LoggerHelper.getHandler(cxfLogger, WRITER_HANDLER) == null) {
                WriterHandler handler = new WriterHandler(writer);
                cxfLogger.addHandler(handler);
            }
            LoggerHelper.disableConsoleLogging();
        }
    }

    public static void deleteLoggingOnWriter() {
        Logger cxfLogger = LoggerHelper.getRootCXFLogger();
        Handler handler = LoggerHelper.getHandler(cxfLogger, WRITER_HANDLER);
        if (handler != null) {
            cxfLogger.removeHandler(handler);
        }
        LoggerHelper.enableConsoleLogging();
    }

    public static boolean loggerInitialisedOutsideConnector() {
        Handler[] handlers = Logger.getLogger("").getHandlers();
        return handlers.length > 0;
    }

    static Handler getHandler(Logger log, String handlerName) {
        Handler[] handlers = log.getHandlers();
        Handler result = null;
        for (int i = 0; i < handlers.length; ++i) {
            if (!handlers[i].getClass().getName().endsWith(handlerName)) continue;
            result = handlers[i];
        }
        return result;
    }

    public static void disableConsoleLogging() {
        Handler handler = LoggerHelper.getHandler(Logger.getLogger(""), CONSOLE_HANDLER);
        Logger.getLogger("").removeHandler(handler);
    }

    public static void enableConsoleLogging() {
        if (LoggerHelper.getHandler(Logger.getLogger(""), CONSOLE_HANDLER) == null) {
            ConsoleHandler console = new ConsoleHandler();
            Logger.getLogger("").addHandler(console);
        }
    }

    public static void setLogLevel(String logLevel) {
        LoggerHelper.init();
        try {
            currentLogLevel = Level.parse(logLevel);
        }
        catch (IllegalArgumentException ex) {
            currentLogLevel = DEFAULT_LOG_LEVEL;
        }
        LoggerHelper.getRootCXFLogger().setLevel(currentLogLevel);
    }

    public static String getLogLevel() {
        return currentLogLevel.toString();
    }

    public static Logger getRootCXFLogger() {
        Logger rootCXFLogger = null;
        rootCXFLogger = LogManager.getLogManager().getLogger(LoggerHelper.getRootLoggerName());
        if (rootCXFLogger == null) {
            rootCXFLogger = Logger.getLogger(LoggerHelper.getRootLoggerName());
        }
        return rootCXFLogger;
    }

    public static void init() {
        if (!initComplete) {
            initComplete = true;
            if (!LoggerHelper.loggerInitialisedOutsideConnector()) {
                LoggerHelper.enableConsoleLogging();
            }
        }
    }

    public static String getRootLoggerName() {
        return rootLoggerName;
    }

    public static void setRootLoggerName(String loggerName) {
        rootLoggerName = loggerName;
    }

    static {
        currentLogLevel = Level.WARNING;
    }
}

