/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.cxf;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.logging.Logger;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.Bus;
import org.apache.cxf.connector.Connection;
import org.apache.cxf.jca.core.resourceadapter.AbstractManagedConnectionImpl;
import org.apache.cxf.jca.core.resourceadapter.ResourceAdapterInternalException;
import org.apache.cxf.jca.cxf.CXFConnectionRequestInfo;
import org.apache.cxf.jca.cxf.CXFInvocationHandler;
import org.apache.cxf.jca.cxf.CXFManagedConnection;
import org.apache.cxf.jca.cxf.CXFManagedConnectionFactory;
import org.apache.cxf.jca.cxf.CXFTransaction;
import org.apache.cxf.jca.cxf.ManagedConnectionFactoryImpl;
import org.apache.cxf.jca.cxf.handlers.InvocationHandlerFactory;

public class ManagedConnectionImpl
extends AbstractManagedConnectionImpl
implements CXFManagedConnection,
Connection {
    private static final Logger LOG = Logger.getLogger(ManagedConnectionImpl.class.getName());
    private InvocationHandlerFactory handlerFactory;
    private Object cxfService;
    private boolean connectionHandleActive;

    public ManagedConnectionImpl(ManagedConnectionFactoryImpl managedFactory, ConnectionRequestInfo crInfo, Subject subject) throws ResourceException {
        super(managedFactory, crInfo, subject);
        LOG.fine("ManagedConnection created with hash: " + this.hashCode() + "." + this.toString());
    }

    public void associateConnection(Object arg0) throws ResourceException {
        try {
            CXFInvocationHandler handler = (CXFInvocationHandler)Proxy.getInvocationHandler((Proxy)arg0);
            CXFManagedConnection managedConnection = handler.getData().getManagedConnection();
            LOG.fine("previously associated managed connection: " + managedConnection.hashCode());
            if (managedConnection != this) {
                LOG.fine("associate handle " + arg0 + " with  managed connection " + this + " with hashcode: " + this.hashCode());
                handler.getData().setManagedConnection(this);
                ((ManagedConnectionImpl)managedConnection).disassociateConnectionHandle(arg0);
                if (this.getCXFService() == null) {
                    this.cxfService = arg0;
                    this.connectionHandleActive = true;
                }
            }
        }
        catch (Exception ex) {
            throw new ResourceAdapterInternalException("Error associating handle " + arg0 + " with managed connection " + this, ex);
        }
    }

    public CXFManagedConnectionFactory getManagedConnectionFactory() {
        return (ManagedConnectionFactoryImpl)this.theManagedConnectionFactory();
    }

    final Object getCXFService() {
        return this.cxfService;
    }

    final void initialiseCXFService(ConnectionRequestInfo crInfo, Subject subject) throws ResourceException {
        LOG.fine("initialiseCXFService, this=" + this + ", info=" + crInfo + ", subject=" + subject);
        this.crinfo = crInfo;
        this.subject = subject;
        this.cxfService = this.getCXFServiceFromBus(subject, crInfo);
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo crInfo) throws ResourceException {
        LOG.fine("getConnection: this=" + this + ", info=" + crInfo + ", subject=" + subject);
        Object connection = null;
        if (this.getCXFService() == null) {
            this.initialiseCXFService(crInfo, subject);
            connection = this.getCXFService();
        } else {
            connection = !this.connectionHandleActive && this.crinfo.equals(crInfo) ? this.getCXFService() : this.getCXFServiceFromBus(subject, crInfo);
        }
        this.connectionHandleActive = true;
        return connection;
    }

    public synchronized Object getCXFServiceFromBus(Subject subject, ConnectionRequestInfo crInfo) throws ResourceException {
        CXFConnectionRequestInfo arReqInfo = (CXFConnectionRequestInfo)crInfo;
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        QName serviceName = arReqInfo.getServiceQName();
        URL wsdlLocationUrl = arReqInfo.getWsdlLocationUrl();
        if (wsdlLocationUrl == null) {
            try {
                Object obj = null;
                Service service = Service.create((QName)serviceName);
                QName port = arReqInfo.getPortQName();
                obj = port == null ? service.getPort(arReqInfo.getInterface()) : service.getPort(arReqInfo.getPortQName(), arReqInfo.getInterface());
                this.setSubject(subject);
                Object object = this.createConnectionProxy(obj, arReqInfo, subject);
                return object;
            }
            catch (WebServiceException wse) {
                throw new ResourceAdapterInternalException("Failed to create proxy client for service " + crInfo, wse);
            }
        }
        try {
            Object obj = null;
            Service service = Service.create((URL)wsdlLocationUrl, (QName)serviceName);
            obj = arReqInfo.getPortQName() != null ? service.getPort(arReqInfo.getPortQName(), arReqInfo.getInterface()) : service.getPort(arReqInfo.getInterface());
            this.setSubject(subject);
            Object object = this.createConnectionProxy(obj, arReqInfo, subject);
            return object;
        }
        catch (WebServiceException wse) {
            throw new ResourceAdapterInternalException("Failed to getPort for " + crInfo, wse);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        throw new NotSupportedException("Not Supported");
    }

    public boolean isBound() {
        return this.getCXFService() != null;
    }

    public void close() throws ResourceException {
    }

    void disassociateConnectionHandle(Object handle) {
        if (this.cxfService == handle) {
            this.connectionHandleActive = false;
            this.cxfService = null;
        }
    }

    private Object createConnectionProxy(Object obj, CXFConnectionRequestInfo cri, Subject subject) throws ResourceException {
        Class[] classes = new Class[]{Connection.class, cri.getInterface()};
        return Proxy.newProxyInstance(cri.getInterface().getClassLoader(), classes, this.createInvocationHandler(obj, subject));
    }

    private InvocationHandler createInvocationHandler(Object obj, Subject subject) throws ResourceException {
        return this.getHandlerFactory().createHandlers(obj, subject);
    }

    private InvocationHandlerFactory getHandlerFactory() throws ResourceException {
        if (this.handlerFactory == null) {
            this.handlerFactory = new InvocationHandlerFactory(this.getBus(), this);
        }
        return this.handlerFactory;
    }

    private Bus getBus() {
        return ((ManagedConnectionFactoryImpl)this.getManagedConnectionFactory()).getBus();
    }

    public void close(Object closingHandle) throws ResourceException {
        if (closingHandle == this.cxfService) {
            this.connectionHandleActive = false;
        }
        super.close(closingHandle);
    }

    public void destroy() throws ResourceException {
        this.connectionHandleActive = false;
        this.cxfService = null;
        super.destroy();
    }

    public CXFTransaction getCXFTransaction() {
        return null;
    }

    public XAResource getXAResource() throws ResourceException {
        throw new NotSupportedException();
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException();
    }
}

