/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.cxf.handlers;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.apache.cxf.Bus;
import org.apache.cxf.jca.core.resourceadapter.ResourceAdapterInternalException;
import org.apache.cxf.jca.cxf.CXFInvocationHandler;
import org.apache.cxf.jca.cxf.CXFInvocationHandlerData;
import org.apache.cxf.jca.cxf.CXFManagedConnection;
import org.apache.cxf.jca.cxf.handlers.CXFInvocationHandlerDataImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationHandlerFactory {
    private static final Logger LOG = Logger.getLogger(InvocationHandlerFactory.class.getName());
    final Class<?>[] handlerChainTypes;
    private final Bus bus;
    private final CXFManagedConnection managedConnection;

    public InvocationHandlerFactory(Bus b, CXFManagedConnection connection) throws ResourceAdapterInternalException {
        this.bus = b;
        this.managedConnection = connection;
        try {
            this.handlerChainTypes = this.getHandlerChainDefinition();
        }
        catch (Exception ex) {
            ResourceAdapterInternalException raie = new ResourceAdapterInternalException("unable to load handler chain definition", ex);
            LOG.warning(ex.getMessage());
            throw raie;
        }
    }

    public CXFInvocationHandler createHandlers(Object target, Subject subject) throws ResourceAdapterInternalException {
        CXFInvocationHandler first = null;
        CXFInvocationHandler last = null;
        CXFInvocationHandlerDataImpl data = new CXFInvocationHandlerDataImpl();
        data.setBus(this.bus);
        data.setManagedConnection(this.managedConnection);
        data.setSubject(subject);
        data.setTarget(target);
        for (int i = 0; i < this.handlerChainTypes.length; ++i) {
            CXFInvocationHandler newHandler;
            try {
                Constructor<?> newHandlerConstructor = this.handlerChainTypes[i].getDeclaredConstructor(CXFInvocationHandlerData.class);
                newHandler = (CXFInvocationHandler)newHandlerConstructor.newInstance(data);
            }
            catch (Exception ex) {
                ResourceAdapterInternalException raie = new ResourceAdapterInternalException("error creating InvocationHandler: " + this.handlerChainTypes[i], ex);
                LOG.warning(raie.getMessage());
                throw raie;
            }
            if (last != null) {
                last.setNext(newHandler);
                last = newHandler;
                continue;
            }
            first = newHandler;
            last = newHandler;
        }
        return first;
    }

    private Class<?>[] getHandlerChainDefinition() throws IOException, ClassNotFoundException {
        String[] classNames = new String[]{"org.apache.cxf.jca.cxf.handlers.ProxyInvocationHandler", "org.apache.cxf.jca.cxf.handlers.ObjectMethodInvocationHandler", "org.apache.cxf.jca.cxf.handlers.InvokingInvocationHandler"};
        Class[] classes = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            LOG.fine("reading handler class: " + classNames[i]);
            classes[i] = this.getClass().getClassLoader().loadClass(classNames[i]);
        }
        return classes;
    }
}

