/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus;

import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.BusState;
import org.apache.cxf.bus.CXFBusFactory;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.interceptor.AbstractBasicInterceptorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CXFBusImpl
extends AbstractBasicInterceptorProvider
implements Bus {
    protected static final String DEFAULT_BUS_ID = "CXF";
    private Map<Class, Object> extensions;
    private BusLifeCycleManager lifeCycleManager;
    private String id;
    private BusState state;

    public CXFBusImpl() {
        this(null);
    }

    public CXFBusImpl(Map<Class, Object> extensions) {
        if (extensions == null) {
            extensions = new HashMap<Class, Object>();
        }
        this.extensions = extensions;
        this.state = BusState.INITIAL;
        this.lifeCycleManager = this.getExtension(BusLifeCycleManager.class);
        if (null != this.lifeCycleManager) {
            this.lifeCycleManager.initComplete();
        }
        CXFBusFactory.possiblySetDefaultBus((Bus)this);
    }

    protected void setState(BusState state) {
        this.state = state;
    }

    public void setExtensions(Map<Class, Object> e) {
        this.extensions = e;
    }

    public void setId(String i) {
        this.id = i;
    }

    public final <T> T getExtension(Class<T> extensionType) {
        Object obj = this.extensions.get(extensionType);
        if (null != obj) {
            return extensionType.cast(obj);
        }
        return null;
    }

    public <T> void setExtension(T extension, Class<T> extensionType) {
        this.extensions.put(extensionType, extension);
    }

    public String getId() {
        return null == this.id ? DEFAULT_BUS_ID + Integer.toString(((Object)((Object)this)).hashCode()) : this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        CXFBusImpl cXFBusImpl = this;
        synchronized (cXFBusImpl) {
            if (this.state == BusState.RUNNING) {
                return;
            }
            this.state = BusState.RUNNING;
            while (this.state == BusState.RUNNING) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean wait) {
        this.lifeCycleManager = this.getExtension(BusLifeCycleManager.class);
        if (null != this.lifeCycleManager) {
            this.lifeCycleManager.preShutdown();
        }
        CXFBusImpl cXFBusImpl = this;
        synchronized (cXFBusImpl) {
            this.state = BusState.SHUTDOWN;
            ((Object)((Object)this)).notifyAll();
        }
        if (null != this.lifeCycleManager) {
            this.lifeCycleManager.postShutdown();
        }
        if (BusFactory.getDefaultBus((boolean)false) == this) {
            BusFactory.setDefaultBus(null);
        }
    }

    protected BusState getState() {
        return this.state;
    }
}

