/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.bus.spring.BusEntityResolver;
import org.apache.cxf.common.logging.LogUtils;
import org.springframework.beans.factory.xml.BeansDtdResolver;
import org.springframework.beans.factory.xml.DefaultNamespaceHandlerResolver;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.beans.factory.xml.PluggableSchemaResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.xml.sax.EntityResolver;

public class BusApplicationContext
extends ClassPathXmlApplicationContext {
    private static final String DEFAULT_CXF_CFG_FILE = "META-INF/cxf/cxf.xml";
    private static final String DEFAULT_CXF_EXT_CFG_FILE = "classpath*:META-INF/cxf/cxf.extension";
    private static final Logger LOG = LogUtils.getL7dLogger(BusApplicationContext.class);
    private DefaultNamespaceHandlerResolver nsHandlerResolver;
    private boolean includeDefaults;
    private String cfgFile;
    private URL cfgFileURL;

    public BusApplicationContext(String cf, boolean include) {
        this(cf, include, null);
    }

    public BusApplicationContext(URL url, boolean include) {
        this(url, include, null);
    }

    public BusApplicationContext(String cf, boolean include, ApplicationContext parent) {
        super((String[])null, false, parent);
        this.cfgFile = cf;
        this.includeDefaults = include;
        this.refresh();
    }

    public BusApplicationContext(URL url, boolean include, ApplicationContext parent) {
        super((String[])null, false, parent);
        this.cfgFileURL = url;
        this.includeDefaults = include;
        this.refresh();
    }

    protected Resource[] getConfigResources() {
        String sysCfgFileUrl;
        ClassPathResource cpr;
        ArrayList<Object> resources = new ArrayList<Object>();
        if (this.includeDefaults) {
            try {
                Resource[] exts;
                PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(Thread.currentThread().getContextClassLoader());
                Collections.addAll(resources, resolver.getResources(DEFAULT_CXF_CFG_FILE));
                for (Resource r : exts = resolver.getResources(DEFAULT_CXF_EXT_CFG_FILE)) {
                    InputStream is = r.getInputStream();
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String line = rd.readLine();
                    while (line != null) {
                        if (!"".equals(line)) {
                            resources.add(resolver.getResource(line));
                        }
                        line = rd.readLine();
                    }
                    is.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (null == this.cfgFile) {
            this.cfgFile = System.getProperty("cxf.config.file");
        }
        if (null == this.cfgFile) {
            this.cfgFile = "cxf.xml";
        }
        if ((cpr = new ClassPathResource(this.cfgFile)).exists()) {
            resources.add(cpr);
        } else {
            LogUtils.log((Logger)LOG, (Level)Level.INFO, (String)"USER_CFG_FILE_NOT_FOUND_MSG", (Object)this.cfgFile);
        }
        if (null != this.cfgFileURL) {
            UrlResource ur = new UrlResource(this.cfgFileURL);
            if (ur.exists()) {
                resources.add(ur);
            } else {
                LogUtils.log((Logger)LOG, (Level)Level.INFO, (String)"USER_CFG_FILE_URL_NOT_FOUND_MSG", (Object)this.cfgFileURL);
            }
        }
        if (null != (sysCfgFileUrl = System.getProperty("cxf.config.file.url"))) {
            try {
                UrlResource ur = new UrlResource(sysCfgFileUrl);
                if (ur.exists()) {
                    resources.add(ur);
                } else {
                    LogUtils.log((Logger)LOG, (Level)Level.INFO, (String)"USER_CFG_FILE_URL_NOT_FOUND_MSG", (Object)sysCfgFileUrl);
                }
            }
            catch (MalformedURLException e) {
                LogUtils.log((Logger)LOG, (Level)Level.INFO, (String)"USER_CFG_FILE_URL_ERROR_MSG", (Object)sysCfgFileUrl);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating application context with resources: " + resources);
        }
        if (0 == resources.size()) {
            return null;
        }
        Resource[] res = new Resource[resources.size()];
        res = resources.toArray(res);
        return res;
    }

    protected void initBeanDefinitionReader(XmlBeanDefinitionReader reader) {
        if (this.nsHandlerResolver == null) {
            this.nsHandlerResolver = new DefaultNamespaceHandlerResolver();
        }
        reader.setNamespaceHandlerResolver((NamespaceHandlerResolver)this.nsHandlerResolver);
        String mode = System.getProperty("spring.validation.mode");
        if (null != mode) {
            reader.setValidationModeName(mode);
        }
        reader.setNamespaceAware(true);
        this.setEntityResolvers(reader);
    }

    void setEntityResolvers(XmlBeanDefinitionReader reader) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        reader.setEntityResolver((EntityResolver)((Object)new BusEntityResolver((EntityResolver)new BeansDtdResolver(), (EntityResolver)new PluggableSchemaResolver(cl))));
    }
}

