/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.catalog;

import java.io.IOException;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.resource.ExtendedURIResolver;
import org.apache.ws.commons.schema.XmlSchemaException;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.apache.xml.resolver.Catalog;
import org.xml.sax.InputSource;

public class CatalogXmlSchemaURIResolver
implements URIResolver {
    private ExtendedURIResolver resolver = new ExtendedURIResolver();
    private Catalog catalogResolver;

    public CatalogXmlSchemaURIResolver(OASISCatalogManager catalogManager) {
        this.catalogResolver = catalogManager.getCatalog();
    }

    public InputSource resolveEntity(String targetNamespace, String schemaLocation, String baseUri) {
        String resolvedSchemaLocation = null;
        try {
            resolvedSchemaLocation = this.catalogResolver.resolveSystem(schemaLocation);
        }
        catch (IOException e) {
            throw new RuntimeException("Catalog resolution failed", e);
        }
        InputSource in = null;
        in = resolvedSchemaLocation == null ? this.resolver.resolve(schemaLocation, baseUri) : this.resolver.resolve(resolvedSchemaLocation, baseUri);
        if (in == null) {
            throw new XmlSchemaException("Unable to locate imported document at '" + schemaLocation + "'" + (baseUri == null ? "." : ", relative to '" + baseUri + "'."));
        }
        return in;
    }
}

