/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.transport.MessageObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFaultChainInitiatorObserver
implements MessageObserver {
    private static final Logger LOG = Logger.getLogger(AbstractFaultChainInitiatorObserver.class.getName());
    private Bus bus;

    public AbstractFaultChainInitiatorObserver(Bus bus) {
        this.bus = bus;
    }

    public void onMessage(Message message) {
        assert (null != message);
        Exchange exchange = message.getExchange();
        Message faultMessage = null;
        if (this.isOutboundObserver()) {
            Exception ex = (Exception)message.getContent(Exception.class);
            if (!(ex instanceof Fault)) {
                ex = new Fault((Throwable)ex);
            }
            FaultMode mode = (FaultMode)message.get(FaultMode.class);
            faultMessage = exchange.getOutMessage();
            if (null == faultMessage) {
                faultMessage = ((Endpoint)exchange.get(Endpoint.class)).getBinding().createMessage();
            }
            faultMessage.setContent(Exception.class, (Object)ex);
            if (null != mode) {
                faultMessage.put(FaultMode.class, (Object)mode);
            }
            exchange.setOutMessage(null);
            exchange.setOutFaultMessage(faultMessage);
        } else {
            faultMessage = message;
            exchange.setInMessage(null);
            exchange.setInFaultMessage(faultMessage);
        }
        PhaseInterceptorChain chain = new PhaseInterceptorChain(this.getPhases());
        this.initializeInterceptors(faultMessage.getExchange(), chain);
        faultMessage.setInterceptorChain((InterceptorChain)chain);
        try {
            chain.doIntercept(faultMessage);
        }
        catch (Exception exc) {
            LogUtils.log((Logger)LOG, (Level)Level.INFO, (String)"Error occured during error handling, give up!", (Throwable)exc);
        }
    }

    protected abstract boolean isOutboundObserver();

    protected abstract SortedSet<Phase> getPhases();

    protected void initializeInterceptors(Exchange ex, PhaseInterceptorChain chain) {
    }

    public Bus getBus() {
        return this.bus;
    }
}

