/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.https;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.security.FiltersType;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.transport.TLSSessionInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SSLUtils {
    static final String PKCS12_TYPE = "PKCS12";
    private static final String DEFAULT_KEYSTORE_TYPE = "PKCS12";
    private static final String DEFAULT_TRUST_STORE_TYPE = "JKS";
    private static final String DEFAULT_SECURE_SOCKET_PROTOCOL = "TLSv1";
    private static final String CERTIFICATE_FACTORY_TYPE = "X.509";
    private static final String SSL_CIPHER_SUITE_ATTRIBUTE = "javax.servlet.request.cipher_suite";
    private static final String SSL_PEER_CERT_CHAIN_ATTRIBUTE = "javax.servlet.request.X509Certificate";
    private static final boolean DEFAULT_REQUIRE_CLIENT_AUTHENTICATION = false;
    private static final boolean DEFAULT_WANT_CLIENT_AUTHENTICATION = true;
    private static final List<String> DEFAULT_CIPHERSUITE_FILTERS_INCLUDE = Arrays.asList(".*_EXPORT_.*", ".*_EXPORT1024_.*", ".*_WITH_DES_.*", ".*_WITH_NULL_.*");

    private SSLUtils() {
    }

    public static KeyManager[] getKeyStoreManagers(String keyStoreLocation, String keyStoreType, String keyStorePassword, String keyPassword, String keyStoreMgrFactoryAlgorithm, String secureSocketProtocol, Logger log) throws Exception {
        if (keyStorePassword != null && keyPassword != null && !keyStorePassword.equals(keyPassword)) {
            LogUtils.log((Logger)log, (Level)Level.WARNING, (String)"KEY_PASSWORD_NOT_SAME_KEYSTORE_PASSWORD");
        }
        KeyManager[] keystoreManagers = null;
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyStoreMgrFactoryAlgorithm);
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        if (keyStoreType.equalsIgnoreCase("PKCS12")) {
            FileInputStream fis = new FileInputStream(keyStoreLocation);
            DataInputStream dis = new DataInputStream(fis);
            byte[] bytes = new byte[dis.available()];
            dis.readFully(bytes);
            ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
            if (keyStorePassword != null) {
                keystoreManagers = SSLUtils.loadKeyStore(kmf, ks, bin, keyStoreLocation, keyStorePassword, log);
            }
        } else {
            byte[] sslCert = SSLUtils.loadClientCredential(keyStoreLocation);
            if (sslCert != null && sslCert.length > 0 && keyStorePassword != null) {
                ByteArrayInputStream bin = new ByteArrayInputStream(sslCert);
                keystoreManagers = SSLUtils.loadKeyStore(kmf, ks, bin, keyStoreLocation, keyStorePassword, log);
            }
        }
        if (keyStorePassword == null && keyStoreLocation != null) {
            LogUtils.log((Logger)log, (Level)Level.WARNING, (String)"FAILED_TO_LOAD_KEYSTORE_NULL_PASSWORD", (Object)keyStoreLocation);
        }
        return keystoreManagers;
    }

    public static KeyManager[] loadKeyStore(KeyManagerFactory kmf, KeyStore ks, ByteArrayInputStream bin, String keyStoreLocation, String keyStorePassword, Logger log) {
        KeyManager[] keystoreManagers = null;
        try {
            ks.load(bin, keyStorePassword.toCharArray());
            kmf.init(ks, keyStorePassword.toCharArray());
            keystoreManagers = kmf.getKeyManagers();
            LogUtils.log((Logger)log, (Level)Level.INFO, (String)"LOADED_KEYSTORE", (Object)keyStoreLocation);
        }
        catch (Exception e) {
            LogUtils.log((Logger)log, (Level)Level.WARNING, (String)"FAILED_TO_LOAD_KEYSTORE", (Object[])new Object[]{keyStoreLocation, e.getMessage()});
        }
        return keystoreManagers;
    }

    public static TrustManager[] getTrustStoreManagers(boolean pkcs12, String trustStoreType, String trustStoreLocation, String trustStoreMgrFactoryAlgorithm, Logger log) throws Exception {
        TrustManager[] trustStoreManagers = null;
        KeyStore trustedCertStore = KeyStore.getInstance(trustStoreType);
        if (pkcs12) {
            trustStoreManagers = new TrustManager[1];
            trustedCertStore.load(null, "".toCharArray());
            CertificateFactory cf = CertificateFactory.getInstance(CERTIFICATE_FACTORY_TYPE);
            byte[] caCert = SSLUtils.loadCACert(trustStoreLocation);
            try {
                if (caCert != null) {
                    ByteArrayInputStream cabin = new ByteArrayInputStream(caCert);
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(cabin);
                    trustedCertStore.setCertificateEntry(((Object)cert.getIssuerDN()).toString(), cert);
                    cabin.close();
                }
            }
            catch (Exception e) {
                LogUtils.log((Logger)log, (Level)Level.WARNING, (String)"FAILED_TO_LOAD_TRUST_STORE", (Object[])new Object[]{trustStoreLocation, e.getMessage()});
            }
        } else {
            trustedCertStore.load(new FileInputStream(trustStoreLocation), null);
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(trustStoreMgrFactoryAlgorithm);
        tmf.init(trustedCertStore);
        LogUtils.log((Logger)log, (Level)Level.INFO, (String)"LOADED_TRUST_STORE", (Object)trustStoreLocation);
        trustStoreManagers = tmf.getTrustManagers();
        return trustStoreManagers;
    }

    protected static byte[] loadClientCredential(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        FileInputStream in = new FileInputStream(fileName);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[512];
        int i = in.read(buf);
        while (i > 0) {
            out.write(buf, 0, i);
            i = in.read(buf);
        }
        in.close();
        return out.toByteArray();
    }

    protected static byte[] loadCACert(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        FileInputStream in = new FileInputStream(fileName);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[512];
        int i = in.read(buf);
        while (i > 0) {
            out.write(buf, 0, i);
            i = in.read(buf);
        }
        in.close();
        return out.toByteArray();
    }

    public static String getKeystore(String keyStoreLocation, Logger log) {
        String logMsg = null;
        if (keyStoreLocation != null) {
            logMsg = "KEY_STORE_SET";
        } else {
            keyStoreLocation = System.getProperty("javax.net.ssl.keyStore");
            if (keyStoreLocation != null) {
                logMsg = "KEY_STORE_SYSTEM_PROPERTY_SET";
            } else {
                keyStoreLocation = System.getProperty("user.home") + "/.keystore";
                logMsg = "KEY_STORE_NOT_SET";
            }
        }
        LogUtils.log((Logger)log, (Level)Level.INFO, (String)logMsg, (Object)keyStoreLocation);
        return keyStoreLocation;
    }

    public static String getKeystoreType(String keyStoreType, Logger log) {
        String logMsg = null;
        if (keyStoreType != null) {
            logMsg = "KEY_STORE_TYPE_SET";
        } else {
            keyStoreType = "PKCS12";
            logMsg = "KEY_STORE_TYPE_NOT_SET";
        }
        LogUtils.log((Logger)log, (Level)Level.INFO, (String)logMsg, (Object)keyStoreType);
        return keyStoreType;
    }

    public static String getKeystorePassword(String keyStorePassword, Logger log) {
        String logMsg = null;
        logMsg = keyStorePassword != null ? "KEY_STORE_PASSWORD_SET" : ((keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword")) != null ? "KEY_STORE_PASSWORD_SYSTEM_PROPERTY_SET" : "KEY_STORE_PASSWORD_NOT_SET");
        LogUtils.log((Logger)log, (Level)Level.INFO, (String)logMsg);
        return keyStorePassword;
    }

    public static String getKeyPassword(String keyPassword, Logger log) {
        String logMsg = null;
        logMsg = keyPassword != null ? "KEY_PASSWORD_SET" : ((keyPassword = System.getProperty("javax.net.ssl.keyStorePassword")) != null ? "KEY_PASSWORD_SYSTEM_PROPERTY_SET" : "KEY_PASSWORD_NOT_SET");
        LogUtils.log((Logger)log, (Level)Level.INFO, (String)logMsg);
        return keyPassword;
    }

    public static String getKeystoreAlgorithm(String keyStoreMgrFactoryAlgorithm, Logger log) {
        String logMsg = null;
        if (keyStoreMgrFactoryAlgorithm != null) {
            logMsg = "KEY_STORE_ALGORITHM_SET";
        } else {
            keyStoreMgrFactoryAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            logMsg = "KEY_STORE_ALGORITHM_NOT_SET";
        }
        LogUtils.log((Logger)log, (Level)Level.INFO, (String)logMsg, (Object)keyStoreMgrFactoryAlgorithm);
        return keyStoreMgrFactoryAlgorithm;
    }

    public static String getTrustStoreAlgorithm(String trustStoreMgrFactoryAlgorithm, Logger log) {
        String logMsg = null;
        if (trustStoreMgrFactoryAlgorithm != null) {
            logMsg = "TRUST_STORE_ALGORITHM_SET";
        } else {
            trustStoreMgrFactoryAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            logMsg = "TRUST_STORE_ALGORITHM_NOT_SET";
        }
        LogUtils.log((Logger)log, (Level)Level.INFO, (String)logMsg, (Object)trustStoreMgrFactoryAlgorithm);
        return trustStoreMgrFactoryAlgorithm;
    }

    public static SSLContext getSSLContext(String protocol, KeyManager[] keyStoreManagers, TrustManager[] trustStoreManagers) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext ctx = SSLContext.getInstance(protocol);
        ctx.init(keyStoreManagers, trustStoreManagers, null);
        return ctx;
    }

    public static String[] getSupportedCipherSuites(SSLContext context) {
        return context.getSocketFactory().getSupportedCipherSuites();
    }

    public static String[] getServerSupportedCipherSuites(SSLContext context) {
        return context.getServerSocketFactory().getSupportedCipherSuites();
    }

    public static String[] getCiphersuites(List<String> cipherSuitesList, String[] supportedCipherSuites, FiltersType filters, Logger log, boolean exclude) {
        String[] cipherSuites = null;
        if (cipherSuitesList != null && !cipherSuitesList.isEmpty()) {
            cipherSuites = SSLUtils.getCiphersFromList(cipherSuitesList, log);
        } else {
            LogUtils.log((Logger)log, (Level)Level.INFO, (String)"CIPHERSUITES_NOT_SET");
            if (filters == null) {
                LogUtils.log((Logger)log, (Level)Level.INFO, (String)"CIPHERSUITE_FILTERS_NOT_SET");
            }
            ArrayList<String> filteredCipherSuites = new ArrayList<String>();
            ArrayList<String> excludedCipherSuites = new ArrayList<String>();
            List<Pattern> includes = filters != null ? SSLUtils.compileRegexPatterns(filters.getInclude(), true, log) : SSLUtils.compileRegexPatterns(DEFAULT_CIPHERSUITE_FILTERS_INCLUDE, true, log);
            List<Pattern> excludes = filters != null ? SSLUtils.compileRegexPatterns(filters.getExclude(), false, log) : null;
            for (int i = 0; i < supportedCipherSuites.length; ++i) {
                if (SSLUtils.matchesOneOf(supportedCipherSuites[i], includes) && !SSLUtils.matchesOneOf(supportedCipherSuites[i], excludes)) {
                    LogUtils.log((Logger)log, (Level)Level.INFO, (String)"CIPHERSUITE_INCLUDED", (Object)supportedCipherSuites[i]);
                    filteredCipherSuites.add(supportedCipherSuites[i]);
                    continue;
                }
                LogUtils.log((Logger)log, (Level)Level.INFO, (String)"CIPHERSUITE_EXCLUDED", (Object)supportedCipherSuites[i]);
                excludedCipherSuites.add(supportedCipherSuites[i]);
            }
            LogUtils.log((Logger)log, (Level)Level.INFO, (String)"CIPHERSUITES_FILTERED", filteredCipherSuites);
            LogUtils.log((Logger)log, (Level)Level.INFO, (String)"CIPHERSUITES_EXCLUDED", excludedCipherSuites);
            cipherSuites = exclude ? SSLUtils.getCiphersFromList(excludedCipherSuites, log) : SSLUtils.getCiphersFromList(filteredCipherSuites, log);
        }
        return cipherSuites;
    }

    private static List<Pattern> compileRegexPatterns(List<String> regexes, boolean include, Logger log) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        if (regexes != null) {
            String msg = include ? "CIPHERSUITE_INCLUDE_FILTER" : "CIPHERSUITE_EXCLUDE_FILTER";
            for (String s : regexes) {
                LogUtils.log((Logger)log, (Level)Level.INFO, (String)msg, (Object)s);
                patterns.add(Pattern.compile(s));
            }
        }
        return patterns;
    }

    private static boolean matchesOneOf(String s, List<Pattern> patterns) {
        boolean matches = false;
        if (patterns != null) {
            for (Pattern pattern : patterns) {
                Matcher matcher = pattern.matcher(s);
                if (!matcher.matches()) continue;
                matches = true;
                break;
            }
        }
        return matches;
    }

    private static String[] getCiphersFromList(List<String> cipherSuitesList, Logger log) {
        int numCipherSuites = cipherSuitesList.size();
        String[] cipherSuites = new String[numCipherSuites];
        String ciphsStr = null;
        for (int i = 0; i < numCipherSuites; ++i) {
            cipherSuites[i] = cipherSuitesList.get(i);
            ciphsStr = ciphsStr == null ? cipherSuites[i] : ciphsStr + ", " + cipherSuites[i];
        }
        LogUtils.log((Logger)log, (Level)Level.INFO, (String)"CIPHERSUITES_SET", ciphsStr);
        return cipherSuites;
    }

    public static String getTrustStore(String trustStoreLocation, Logger log) {
        String logMsg = null;
        if (trustStoreLocation != null) {
            logMsg = "TRUST_STORE_SET";
        } else {
            trustStoreLocation = System.getProperty("javax.net.ssl.trustStore");
            if (trustStoreLocation != null) {
                logMsg = "TRUST_STORE_SYSTEM_PROPERTY_SET";
            } else {
                trustStoreLocation = System.getProperty("java.home") + "/lib/security/cacerts";
                logMsg = "TRUST_STORE_NOT_SET";
            }
        }
        LogUtils.log((Logger)log, (Level)Level.INFO, (String)logMsg, (Object)trustStoreLocation);
        return trustStoreLocation;
    }

    public static String getTrustStoreType(String trustStoreType, Logger log) {
        String logMsg = null;
        if (trustStoreType != null) {
            logMsg = "TRUST_STORE_TYPE_SET";
        } else {
            trustStoreType = DEFAULT_TRUST_STORE_TYPE;
            logMsg = "TRUST_STORE_TYPE_NOT_SET";
        }
        LogUtils.log((Logger)log, (Level)Level.INFO, (String)logMsg, (Object)trustStoreType);
        return trustStoreType;
    }

    public static String getSecureSocketProtocol(String secureSocketProtocol, Logger log) {
        if (secureSocketProtocol != null) {
            LogUtils.log((Logger)log, (Level)Level.INFO, (String)"SECURE_SOCKET_PROTOCOL_SET", (Object)secureSocketProtocol);
        } else {
            LogUtils.log((Logger)log, (Level)Level.INFO, (String)"SECURE_SOCKET_PROTOCOL_NOT_SET");
            secureSocketProtocol = DEFAULT_SECURE_SOCKET_PROTOCOL;
        }
        return secureSocketProtocol;
    }

    public static boolean getRequireClientAuthentication(boolean isSetRequireClientAuthentication, Boolean isRequireClientAuthentication, Logger log) {
        boolean requireClientAuthentication = false;
        if (isSetRequireClientAuthentication) {
            requireClientAuthentication = isRequireClientAuthentication;
            LogUtils.log((Logger)log, (Level)Level.INFO, (String)"REQUIRE_CLIENT_AUTHENTICATION_SET", (Object)requireClientAuthentication);
        } else {
            LogUtils.log((Logger)log, (Level)Level.WARNING, (String)"REQUIRE_CLIENT_AUTHENTICATION_NOT_SET");
        }
        return requireClientAuthentication;
    }

    public static boolean getWantClientAuthentication(boolean isSetWantClientAuthentication, Boolean isWantClientAuthentication, Logger log) {
        boolean wantClientAuthentication = true;
        if (isSetWantClientAuthentication) {
            wantClientAuthentication = isWantClientAuthentication;
            LogUtils.log((Logger)log, (Level)Level.INFO, (String)"WANT_CLIENT_AUTHENTICATION_SET", (Object)wantClientAuthentication);
        } else {
            LogUtils.log((Logger)log, (Level)Level.WARNING, (String)"WANT_CLIENT_AUTHENTICATION_NOT_SET");
        }
        return wantClientAuthentication;
    }

    public static void propogateSecureSession(HttpServletRequest request, Message message) {
        String cipherSuite = (String)request.getAttribute(SSL_CIPHER_SUITE_ATTRIBUTE);
        if (cipherSuite != null) {
            Certificate[] certs = (Certificate[])request.getAttribute(SSL_PEER_CERT_CHAIN_ATTRIBUTE);
            message.put(TLSSessionInfo.class, (Object)new TLSSessionInfo(cipherSuite, null, certs));
        }
    }

    public static void logUnSupportedPolicies(Object policy, boolean client, String[] unsupported, Logger log) {
        for (int i = 0; i < unsupported.length; ++i) {
            try {
                Method method = policy.getClass().getMethod("isSet" + unsupported[i], new Class[0]);
                boolean isSet = (Boolean)method.invoke(policy, (Object[])null);
                SSLUtils.logUnSupportedPolicy(isSet, client, unsupported[i], log);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private static void logUnSupportedPolicy(boolean isSet, boolean client, String policy, Logger log) {
        if (isSet) {
            LogUtils.log((Logger)log, (Level)Level.WARNING, (String)(client ? "UNSUPPORTED_SSL_CLIENT_POLICY_DATA" : "UNSUPPORTED_SSL_SERVER_POLICY_DATA"), (Object)policy);
        }
    }

    public static boolean testAllDataHasSetupMethod(Object policy, String[] unsupported, String[] derivative) {
        Method[] sslPolicyMethods = policy.getClass().getDeclaredMethods();
        Method[] methods = SSLUtils.class.getMethods();
        boolean ok = true;
        for (int i = 0; i < sslPolicyMethods.length && ok; ++i) {
            String sslPolicyMethodName = sslPolicyMethods[i].getName();
            if (!sslPolicyMethodName.startsWith("isSet")) continue;
            String dataName = sslPolicyMethodName.substring("isSet".length(), sslPolicyMethodName.length());
            String thisMethodName = "get" + dataName;
            ok = SSLUtils.hasMethod(methods, thisMethodName) || SSLUtils.isExcluded(unsupported, dataName) || SSLUtils.isExcluded(derivative, dataName);
        }
        return ok;
    }

    private static boolean hasMethod(Method[] methods, String methodName) {
        boolean found = false;
        for (int i = 0; i < methods.length && !found; ++i) {
            found = methods[i].getName().equals(methodName);
        }
        return found;
    }

    private static boolean isExcluded(String[] excluded, String dataName) {
        boolean found = false;
        for (int i = 0; i < excluded.length && !found; ++i) {
            found = excluded[i].equals(dataName);
        }
        return found;
    }
}

