/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jbi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.jbi.JBIDestinationOutputStream;
import org.apache.cxf.transport.jbi.JBIMessageHelper;
import org.apache.cxf.transport.jbi.JBITransportFactory;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;

public class JBIDestination
extends AbstractDestination {
    private static final Logger LOG = LogUtils.getL7dLogger(JBIDestination.class);
    private final DeliveryChannel channel;
    private JBIDispatcher dispatcher;
    private volatile boolean running;

    public JBIDestination(EndpointInfo info, DeliveryChannel dc) {
        super(JBIDestination.getTargetReference((EndpointInfo)info, null), info);
        this.channel = dc;
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected Conduit getInbuiltBackChannel(Message inMessage) {
        return new BackChannelConduit(EndpointReferenceUtils.getAnonymousEndpointReference(), inMessage);
    }

    public void shutdown() {
        this.running = false;
    }

    public void deactivate() {
        this.running = false;
    }

    public void activate() {
        this.getLogger().info(new org.apache.cxf.common.i18n.Message("ACTIVE.JBI.SERVER.TRANSPORT", this.getLogger(), new Object[0]).toString());
        this.dispatcher = new JBIDispatcher();
        new Thread(this.dispatcher).start();
    }

    public void dispatch(MessageExchange exchange) throws IOException {
        QName opName = exchange.getOperation();
        this.getLogger().info("dispatch method: " + opName);
        NormalizedMessage nm = exchange.getMessage("in");
        try {
            MessageImpl inMessage = new MessageImpl();
            inMessage.put(MessageExchange.class, (Object)exchange);
            InputStream in = JBIMessageHelper.convertMessageToInputStream(nm.getContent());
            inMessage.setContent(InputStream.class, (Object)in);
            inMessage.setDestination((Destination)this);
            this.getMessageObserver().onMessage((Message)inMessage);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, new org.apache.cxf.common.i18n.Message("ERROR.PREPARE.MESSAGE", this.getLogger(), new Object[0]).toString(), ex);
            throw new IOException(ex.getMessage());
        }
    }

    private class JBIDispatcher
    implements Runnable {
        private JBIDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                JBIDestination.this.running = true;
                JBIDestination.this.getLogger().info(new org.apache.cxf.common.i18n.Message("RECEIVE.THREAD.START", JBIDestination.this.getLogger(), new Object[0]).toString());
                do {
                    MessageExchange exchange = null;
                    DeliveryChannel deliveryChannel = JBIDestination.this.channel;
                    synchronized (deliveryChannel) {
                        exchange = JBIDestination.this.channel.accept();
                    }
                    if (exchange == null) continue;
                    JBIDestination.this.getLogger().info(new org.apache.cxf.common.i18n.Message("DISPATCH.TO.SU", JBIDestination.this.getLogger(), new Object[0]).toString());
                    JBIDestination.this.dispatch(exchange);
                } while (JBIDestination.this.running);
            }
            catch (Exception ex) {
                JBIDestination.this.getLogger().log(Level.SEVERE, new org.apache.cxf.common.i18n.Message("ERROR.DISPATCH.THREAD", JBIDestination.this.getLogger(), new Object[0]).toString(), ex);
            }
            JBIDestination.this.getLogger().fine(new org.apache.cxf.common.i18n.Message("JBI.SERVER.TRANSPORT.MESSAGE.PROCESS.THREAD.EXIT", JBIDestination.this.getLogger(), new Object[0]).toString());
        }
    }

    protected class BackChannelConduit
    extends AbstractConduit {
        protected Message inMessage;
        protected JBIDestination jbiDestination;

        BackChannelConduit(EndpointReferenceType ref, Message message) {
            super(ref);
            this.inMessage = message;
        }

        public void setMessageObserver(MessageObserver observer) {
        }

        public void prepare(Message message) throws IOException {
            DeliveryChannel dc = JBIDestination.this.channel;
            if (dc == null) {
                dc = JBITransportFactory.getDeliveryChannel();
            }
            message.put(MessageExchange.class, this.inMessage.get(MessageExchange.class));
            message.setContent(OutputStream.class, (Object)new JBIDestinationOutputStream(this.inMessage, dc));
        }

        protected Logger getLogger() {
            return LOG;
        }
    }
}

