/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jbi;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.jbi.JBIException;
import javax.jbi.messaging.DeliveryChannel;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.jbi.JBIConduit;
import org.apache.cxf.transport.jbi.JBIDestination;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBITransportFactory
extends AbstractTransportFactory
implements ConduitInitiator,
DestinationFactory {
    public static final String TRANSPORT_ID = "http://cxf.apache.org/transports/jbi";
    private static final Logger LOG = LogUtils.getL7dLogger(JBITransportFactory.class);
    private static DeliveryChannel deliveryChannel;
    private Bus bus;
    private final Map<String, JBIDestination> destinationMap = new HashMap<String, JBIDestination>();
    private Collection<String> activationNamespaces;

    @Resource
    public void setBus(Bus b) {
        this.bus = b;
    }

    public Bus getBus() {
        return this.bus;
    }

    public Set<String> getUriPrefixes() {
        return Collections.singleton("jbi");
    }

    @Resource
    public void setActivationNamespaces(Collection<String> ans) {
        this.activationNamespaces = ans;
    }

    @PostConstruct
    void registerWithBindingManager() {
        DestinationFactoryManager dfm;
        if (null == this.bus) {
            return;
        }
        ConduitInitiatorManager cim = (ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class);
        if (null != cim && null != this.activationNamespaces) {
            for (String ns : this.activationNamespaces) {
                cim.registerConduitInitiator(ns, (ConduitInitiator)this);
            }
        }
        if (null != (dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class)) && null != this.activationNamespaces) {
            for (String ns : this.activationNamespaces) {
                dfm.registerDestinationFactory(ns, (DestinationFactory)this);
            }
        }
    }

    public static DeliveryChannel getDeliveryChannel() {
        return deliveryChannel;
    }

    public static void setDeliveryChannel(DeliveryChannel newDeliverychannel) {
        LOG.info(new Message("CONFIG.DELIVERY.CHANNEL", LOG, new Object[0]).toString() + newDeliverychannel);
        deliveryChannel = newDeliverychannel;
    }

    public Conduit getConduit(EndpointInfo targetInfo) throws IOException {
        return this.getConduit(targetInfo, null);
    }

    public Conduit getConduit(EndpointInfo endpointInfo, EndpointReferenceType target) throws IOException {
        JBIConduit conduit = new JBIConduit(target, JBITransportFactory.getDeliveryChannel());
        Configurer configurer = (Configurer)this.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean((Object)conduit);
        }
        return conduit;
    }

    public Destination getDestination(EndpointInfo ei) throws IOException {
        JBIDestination destination = new JBIDestination(ei, JBITransportFactory.getDeliveryChannel());
        Configurer configurer = (Configurer)this.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean((Object)destination);
        }
        try {
            this.putDestination(ei.getAddress(), destination);
        }
        catch (JBIException e) {
            throw new IOException(e.getMessage());
        }
        return destination;
    }

    public void putDestination(String epName, JBIDestination destination) throws JBIException {
        if (this.destinationMap.containsKey(epName)) {
            throw new JBIException("JBIDestination for Endpoint " + epName + " already be created");
        }
        this.destinationMap.put(epName, destination);
    }

    public JBIDestination getDestination(String epName) {
        return this.destinationMap.get(epName);
    }
}

