/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http_jetty.JettyHTTPHandler;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.http_jetty.JettyHTTPTransportFactory;
import org.apache.cxf.transport.http_jetty.ServerEngine;
import org.apache.cxf.transport.https.SSLUtils;
import org.apache.cxf.transports.http.QueryHandler;
import org.apache.cxf.transports.http.QueryHandlerRegistry;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;

public class JettyHTTPDestination
extends AbstractHTTPDestination {
    private static final Logger LOG = LogUtils.getL7dLogger(JettyHTTPDestination.class);
    protected JettyHTTPServerEngine engine;
    protected JettyHTTPTransportFactory transportFactory;
    protected JettyHTTPServerEngineFactory serverEngineFactory;
    protected URL nurl;
    private boolean configFinalized;

    public JettyHTTPDestination(Bus b, JettyHTTPTransportFactory ci, EndpointInfo endpointInfo) throws IOException {
        super(b, (ConduitInitiator)ci, endpointInfo, true);
        this.transportFactory = ci;
        this.serverEngineFactory = ci.getJettyHTTPServerEngineFactory();
        this.nurl = new URL(endpointInfo.getAddress());
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected void retrieveEngine() throws GeneralSecurityException, IOException {
        this.engine = this.serverEngineFactory.retrieveJettyHTTPServerEngine(this.nurl.getPort());
        if (this.engine == null) {
            JettyHTTPServerEngine jettyHTTPServerEngine = this.engine = "https".equals(this.nurl.getProtocol()) ? this.serverEngineFactory.createJettyHTTPSServerEngine(this.nurl.getPort()) : this.serverEngineFactory.createJettyHTTPServerEngine(this.nurl.getPort());
        }
        assert (this.engine != null);
        if (!this.nurl.getProtocol().equals(this.engine.getProtocol())) {
            throw new IllegalStateException("Port " + this.engine.getPort() + " is configured with wrong protocol \"" + this.engine.getProtocol() + "\" for \"" + this.nurl + "\"");
        }
    }

    public void finalizeConfig() throws GeneralSecurityException, IOException {
        assert (!this.configFinalized);
        this.retrieveEngine();
        this.configFinalized = true;
    }

    protected void activate() {
        LOG.log(Level.FINE, "Activating receipt of incoming messages");
        try {
            URL url = new URL(this.endpointInfo.getAddress());
            this.engine.addServant(url, new JettyHTTPHandler(this, this.contextMatchOnExact()));
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "URL creation failed: ", e);
        }
    }

    protected void deactivate() {
        LOG.log(Level.FINE, "Deactivating receipt of incoming messages");
        this.engine.removeServant(this.nurl);
    }

    protected ConduitInitiator getConduitInitiator() {
        return this.conduitInitiator;
    }

    private String getBasePath(String addr) {
        try {
            return new URL(addr).getPath();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private synchronized void updateEndpointAddress(String addr) {
        String address = this.endpointInfo.getAddress();
        if (this.getBasePath(address).equals(this.getBasePath(addr))) {
            this.endpointInfo.setAddress(addr);
        }
    }

    protected void doService(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Request baseRequest;
        Request request = baseRequest = req instanceof Request ? (Request)req : HttpConnection.getCurrentConnection().getRequest();
        if (this.getServer().isSetRedirectURL()) {
            resp.sendRedirect(this.getServer().getRedirectURL());
            resp.flushBuffer();
            baseRequest.setHandled(true);
            return;
        }
        QueryHandlerRegistry queryHandlerRegistry = (QueryHandlerRegistry)this.bus.getExtension(QueryHandlerRegistry.class);
        if (null != req.getQueryString() && queryHandlerRegistry != null) {
            String requestURL = req.getRequestURL() + "?" + req.getQueryString();
            String pathInfo = req.getPathInfo();
            for (QueryHandler qh : queryHandlerRegistry.getHandlers()) {
                if (!qh.isRecognizedQuery(requestURL, pathInfo, this.endpointInfo)) continue;
                this.updateEndpointAddress(req.getRequestURL().toString());
                resp.setContentType(qh.getResponseContentType(requestURL, pathInfo));
                qh.writeResponse(requestURL, pathInfo, this.endpointInfo, (OutputStream)resp.getOutputStream());
                resp.getOutputStream().flush();
                baseRequest.setHandled(true);
                return;
            }
        }
        this.serviceRequest(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceRequest(final HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Request baseRequest = req instanceof Request ? (Request)req : HttpConnection.getCurrentConnection().getRequest();
        try {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Service http request on thread: " + Thread.currentThread());
            }
            MessageImpl inMessage = new MessageImpl();
            inMessage.setContent(InputStream.class, (Object)req.getInputStream());
            inMessage.put((Object)"HTTP.REQUEST", (Object)req);
            inMessage.put((Object)"HTTP.RESPONSE", (Object)resp);
            inMessage.put((Object)Message.HTTP_REQUEST_METHOD, (Object)req.getMethod());
            inMessage.put((Object)Message.PATH_INFO, (Object)(req.getContextPath() + req.getPathInfo()));
            inMessage.put((Object)Message.QUERY_STRING, (Object)req.getQueryString());
            inMessage.put((Object)"Content-Type", (Object)req.getContentType());
            if (!StringUtils.isEmpty((String)this.endpointInfo.getAddress())) {
                inMessage.put((Object)Message.BASE_PATH, (Object)new URL(this.endpointInfo.getAddress()).getPath());
            }
            inMessage.put((Object)Message.FIXED_PARAMETER_ORDER, (Object)this.isFixedParameterOrder());
            inMessage.put((Object)"org.apache.cxf.async.post.response.dispatch", (Object)Boolean.TRUE);
            inMessage.put(SecurityContext.class, (Object)new SecurityContext(){

                public Principal getUserPrincipal() {
                    return req.getUserPrincipal();
                }

                public boolean isUserInRole(String role) {
                    return req.isUserInRole(role);
                }
            });
            this.setHeaders((Message)inMessage);
            inMessage.setDestination((Destination)this);
            SSLUtils.propogateSecureSession((HttpServletRequest)req, (Message)inMessage);
            this.incomingObserver.onMessage((Message)inMessage);
            resp.flushBuffer();
            baseRequest.setHandled(true);
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Finished servicing http request on thread: " + Thread.currentThread());
            }
        }
    }

    public void shutdown() {
        this.transportFactory.removeDestination(this.endpointInfo);
        super.shutdown();
    }

    public ServerEngine getEngine() {
        return this.engine;
    }
}

