/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty.spring;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.jsse.spring.TLSServerParametersConfig;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.http_jetty.ThreadingParameters;
import org.apache.cxf.transports.http_jetty.configuration.JettyHTTPServerEngineConfigType;
import org.apache.cxf.transports.http_jetty.configuration.JettyHTTPServerEngineFactoryConfigType;
import org.apache.cxf.transports.http_jetty.configuration.TLSServerParametersIdentifiedType;
import org.apache.cxf.transports.http_jetty.configuration.ThreadingParametersIdentifiedType;
import org.apache.cxf.transports.http_jetty.configuration.ThreadingParametersType;

public class JettyHTTPServerEngineFactoryConfig {
    Map<Integer, TLSServerParameters> tlsParametersMap = new TreeMap<Integer, TLSServerParameters>();
    Map<Integer, ThreadingParameters> threadingParametersMap = new TreeMap<Integer, ThreadingParameters>();

    JettyHTTPServerEngineFactoryConfig(JettyHTTPServerEngineFactoryConfigType config) {
        HashMap<String, TLSServerParametersConfig> tlsMap = new HashMap<String, TLSServerParametersConfig>();
        HashMap<String, ThreadingParameters> threadingMap = new HashMap<String, ThreadingParameters>();
        for (ThreadingParametersIdentifiedType threadingParametersIdentifiedType : config.getIdentifiedThreadingParameters()) {
            if (threadingMap.get(threadingParametersIdentifiedType.getId()) != null) {
                throw new RuntimeException("Threading Parameters " + threadingParametersIdentifiedType.getId() + " is configured more than once.");
            }
            threadingMap.put(threadingParametersIdentifiedType.getId(), this.toThreadingParameters(threadingParametersIdentifiedType.getThreadingParameters()));
        }
        for (TLSServerParametersIdentifiedType tLSServerParametersIdentifiedType : config.getIdentifiedTLSServerParameters()) {
            if (tlsMap.get(tLSServerParametersIdentifiedType.getId()) != null) {
                throw new RuntimeException("TLS Server Parameters " + tLSServerParametersIdentifiedType.getId() + " is configured more than once.");
            }
            try {
                TLSServerParametersConfig con = new TLSServerParametersConfig(tLSServerParametersIdentifiedType.getTlsServerParameters());
                tlsMap.put(tLSServerParametersIdentifiedType.getId(), con);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not configure TLS in " + tLSServerParametersIdentifiedType.getId(), e);
            }
        }
        for (JettyHTTPServerEngineConfigType jettyHTTPServerEngineConfigType : config.getEngine()) {
            ThreadingParameters tparams = null;
            if (jettyHTTPServerEngineConfigType.getThreadingParametersRef() != null) {
                String id = jettyHTTPServerEngineConfigType.getThreadingParametersRef().getId();
                tparams = (ThreadingParameters)threadingMap.get(id);
                if (tparams == null) {
                    throw new RuntimeException("Could not find \"" + id + "\" as threading parameters");
                }
            } else if (jettyHTTPServerEngineConfigType.getThreadingParameters() != null) {
                tparams = this.toThreadingParameters(jettyHTTPServerEngineConfigType.getThreadingParameters());
            }
            TLSServerParameters tlsParams = null;
            if (jettyHTTPServerEngineConfigType.getTlsServerParametersRef() != null) {
                String id = jettyHTTPServerEngineConfigType.getTlsServerParametersRef().getId();
                tlsParams = (TLSServerParameters)tlsMap.get(id);
                if (tlsParams == null) {
                    throw new RuntimeException("Could not find \"" + id + "\" as TLS Server Parameters");
                }
            } else if (jettyHTTPServerEngineConfigType.getTlsServerParameters() != null) {
                try {
                    tlsParams = new TLSServerParametersConfig(jettyHTTPServerEngineConfigType.getTlsServerParameters());
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not configure TLS for port " + jettyHTTPServerEngineConfigType.getPort(), e);
                }
            }
            if (this.threadingParametersMap.get(jettyHTTPServerEngineConfigType.getPort()) != null || this.tlsParametersMap.get(jettyHTTPServerEngineConfigType.getPort()) != null) {
                throw new RuntimeException("Port " + jettyHTTPServerEngineConfigType.getPort() + " is configured more than once");
            }
            if (tparams != null) {
                this.threadingParametersMap.put(jettyHTTPServerEngineConfigType.getPort(), tparams);
            }
            if (tlsParams == null) continue;
            this.tlsParametersMap.put(jettyHTTPServerEngineConfigType.getPort(), tlsParams);
        }
    }

    private ThreadingParameters toThreadingParameters(ThreadingParametersType paramtype) {
        ThreadingParameters params = new ThreadingParameters();
        params.setMaxThreads(paramtype.getMaxThreads());
        params.setMinThreads(paramtype.getMinThreads());
        return params;
    }

    public void configureServerEngineFactory(JettyHTTPServerEngineFactory fac) {
        for (int port : this.tlsParametersMap.keySet()) {
            fac.setTLSServerParametersForPort(port, this.tlsParametersMap.get(port));
        }
        for (int port : this.threadingParametersMap.keySet()) {
            fac.setThreadingParametersForPort(port, this.threadingParametersMap.get(port));
        }
    }
}

