/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint.dynamic;

import com.sun.codemodel.JType;
import com.sun.tools.xjc.api.Mapping;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.TypeAndAnnotation;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.util.PrimitiveUtils;
import org.apache.cxf.service.ServiceModelVisitor;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;

public class TypeClassInitializer
extends ServiceModelVisitor {
    private static final Logger LOG = Logger.getLogger(TypeClassInitializer.class.getName());
    S2JJAXBModel model;

    public TypeClassInitializer(ServiceInfo serviceInfo, S2JJAXBModel model) {
        super(serviceInfo);
        this.model = model;
    }

    public void begin(MessagePartInfo part) {
        Class cls;
        TypeAndAnnotation typeAndAnnotation;
        OperationInfo op = part.getMessageInfo().getOperation();
        if (op.isUnwrappedCapable() && !op.isUnwrapped()) {
            return;
        }
        QName name = part.isElement() ? part.getElementQName() : part.getTypeQName();
        Mapping mapping = this.model.get(name);
        JType jType = null;
        if (mapping != null) {
            jType = mapping.getType().getTypeClass();
        }
        if (jType == null && (typeAndAnnotation = this.model.getJavaType(part.getTypeQName())) != null) {
            jType = typeAndAnnotation.getTypeClass();
        }
        if (jType == null) {
            throw new ServiceConstructionException(new Message("NO_JAXB_CLASS", LOG, new Object[]{name}));
        }
        try {
            cls = !jType.isPrimitive() ? ClassLoaderUtils.loadClass((String)jType.fullName(), ((Object)((Object)this)).getClass()) : PrimitiveUtils.getClass((String)jType.fullName());
        }
        catch (ClassNotFoundException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        part.setTypeClass(cls);
        super.begin(part);
    }
}

