/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend;

import java.io.IOException;
import java.util.Map;
import org.apache.cxf.BusException;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.AbstractEndpointFactory;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.invoker.BeanInvoker;
import org.apache.cxf.service.invoker.Invoker;

public class ServerFactoryBean
extends AbstractEndpointFactory {
    private Server server;
    private boolean start = true;
    private Object serviceBean;

    public ServerFactoryBean() {
        this.setServiceFactory(new ReflectionServiceFactoryBean());
    }

    public String getBeanName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Server create() {
        try {
            this.applyExtraClass();
            if (this.serviceBean != null && this.getServiceClass() == null) {
                this.setServiceClass(this.serviceBean.getClass());
            }
            Endpoint ep = this.createEndpoint();
            this.server = new ServerImpl(this.getBus(), ep, this.getDestinationFactory(), this.getBindingFactory());
            if (this.serviceBean != null) {
                ep.getService().setInvoker(this.createInvoker());
            }
            if (this.start) {
                this.server.start();
            }
        }
        catch (EndpointException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        catch (BusException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        catch (IOException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        this.applyFeatures();
        return this.server;
    }

    protected void applyFeatures() {
        if (this.getFeatures() != null) {
            for (AbstractFeature feature : this.getFeatures()) {
                feature.initialize(this.server, this.getBus());
            }
        }
    }

    protected void applyExtraClass() {
        Map<String, Object> props;
        DataBinding dataBinding = this.getServiceFactory().getDataBinding();
        if (dataBinding instanceof JAXBDataBinding && (props = this.getProperties()) != null && props.get("jaxb.additionalContextClasses") != null) {
            Class[] extraClass = (Class[])this.getProperties().get("jaxb.additionalContextClasses");
            ((JAXBDataBinding)dataBinding).setExtraClass(extraClass);
        }
    }

    protected Invoker createInvoker() {
        return new BeanInvoker(this.serviceBean);
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public Object getServiceBean() {
        if (this.serviceBean == null) {
            return this.getServiceFactory().getServiceClass();
        }
        return this.serviceBean;
    }

    public void setServiceBean(Object serviceBean) {
        this.serviceBean = serviceBean;
    }
}

