/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WSSecEncryptedKey
extends WSSecBase {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$message$WSSecEncryptedKey == null ? (class$org$apache$ws$security$message$WSSecEncryptedKey = WSSecEncryptedKey.class$("org.apache.ws.security.message.WSSecEncryptedKey")) : class$org$apache$ws$security$message$WSSecEncryptedKey).getName());
    protected Document document;
    protected Element envelope = null;
    protected byte[] ephemeralKey;
    protected String encrUser = null;
    protected String keyEncAlgo = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    protected Element encryptedKeyElement = null;
    protected String encKeyId = null;
    protected BinarySecurity bstToken = null;
    protected X509Certificate useThisCert = null;
    protected int keySize = 128;
    static /* synthetic */ Class class$org$apache$ws$security$message$WSSecEncryptedKey;

    public void setUserInfo(String user) {
        this.user = user;
    }

    public String getId() {
        return this.encKeyId;
    }

    public void prepare(Document doc, Crypto crypto) throws WSSecurityException {
        this.document = doc;
        if (this.ephemeralKey == null) {
            this.ephemeralKey = this.generateEphemeralKey();
        }
        X509Certificate remoteCert = null;
        if (this.useThisCert != null) {
            remoteCert = this.useThisCert;
        } else {
            X509Certificate[] certs = crypto.getCertificates(this.user);
            if (certs == null || certs.length <= 0) {
                throw new WSSecurityException(0, "invalidX509Data", new Object[]{"for Encryption"});
            }
            remoteCert = certs[0];
        }
        this.prepareInternal(this.ephemeralKey, remoteCert, crypto);
    }

    protected void prepareInternal(byte[] keyBytes, X509Certificate remoteCert, Crypto crypto) throws WSSecurityException {
        String certUri = "EncCertId-" + remoteCert.hashCode();
        Cipher cipher = WSSecurityUtil.getCipherInstance(this.keyEncAlgo);
        try {
            cipher.init(1, remoteCert);
        }
        catch (InvalidKeyException e) {
            throw new WSSecurityException(8, null, null, e);
        }
        if (this.doDebug) {
            log.debug((Object)("cipher blksize: " + cipher.getBlockSize() + ", symm key length: " + keyBytes.length));
        }
        if (cipher.getBlockSize() < keyBytes.length) {
            throw new WSSecurityException(0, "unsupportedKeyTransp", new Object[]{"public key algorithm too weak to encrypt symmetric key"});
        }
        byte[] encryptedKey = null;
        try {
            encryptedKey = cipher.doFinal(keyBytes);
        }
        catch (IllegalStateException e1) {
            throw new WSSecurityException(8, null, null, e1);
        }
        catch (IllegalBlockSizeException e1) {
            throw new WSSecurityException(8, null, null, e1);
        }
        catch (BadPaddingException e1) {
            throw new WSSecurityException(8, null, null, e1);
        }
        Text keyText = WSSecurityUtil.createBase64EncodedTextNode(this.document, encryptedKey);
        this.encryptedKeyElement = this.createEnrcyptedKey(this.document, this.keyEncAlgo);
        if (this.encKeyId == null || "".equals(this.encKeyId)) {
            this.encKeyId = "EncKeyId-" + this.encryptedKeyElement.hashCode();
        }
        this.encryptedKeyElement.setAttributeNS(null, "Id", this.encKeyId);
        KeyInfo keyInfo = new KeyInfo(this.document);
        SecurityTokenReference secToken = new SecurityTokenReference(this.document);
        switch (this.keyIdentifierType) {
            case 3: {
                secToken.setKeyIdentifier(remoteCert);
                break;
            }
            case 4: {
                secToken.setKeyIdentifierSKI(remoteCert, crypto);
                break;
            }
            case 8: {
                secToken.setKeyIdentifierThumb(remoteCert);
                break;
            }
            case 2: {
                XMLX509IssuerSerial data = new XMLX509IssuerSerial(this.document, remoteCert);
                X509Data x509Data = new X509Data(this.document);
                x509Data.add(data);
                secToken.setX509IssuerSerial(x509Data);
                break;
            }
            case 1: {
                Reference ref = new Reference(this.document);
                ref.setURI("#" + certUri);
                this.bstToken = new X509Security(this.document);
                ((X509Security)this.bstToken).setX509Certificate(remoteCert);
                this.bstToken.setID(certUri);
                ref.setValueType(this.bstToken.getValueType());
                secToken.setReference(ref);
                break;
            }
            default: {
                throw new WSSecurityException(0, "unsupportedKeyId");
            }
        }
        keyInfo.addUnknownElement(secToken.getElement());
        WSSecurityUtil.appendChildElement(this.document, this.encryptedKeyElement, keyInfo.getElement());
        Element xencCipherValue = this.createCipherValue(this.document, this.encryptedKeyElement);
        xencCipherValue.appendChild(keyText);
        this.envelope = this.document.getDocumentElement();
        this.envelope.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xenc", "http://www.w3.org/2001/04/xmlenc#");
    }

    protected byte[] generateEphemeralKey() throws WSSecurityException {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] temp = new byte[this.keySize / 8];
            random.nextBytes(temp);
            return temp;
        }
        catch (Exception e) {
            throw new WSSecurityException("Error in creating the ephemeral key", e);
        }
    }

    protected Element createEnrcyptedKey(Document doc, String keyTransportAlgo) {
        Element encryptedKey = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptedKey");
        WSSecurityUtil.setNamespace(encryptedKey, "http://www.w3.org/2001/04/xmlenc#", "xenc");
        Element encryptionMethod = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptionMethod");
        encryptionMethod.setAttributeNS(null, "Algorithm", keyTransportAlgo);
        WSSecurityUtil.appendChildElement(doc, encryptedKey, encryptionMethod);
        return encryptedKey;
    }

    protected Element createCipherValue(Document doc, Element encryptedKey) {
        Element cipherData = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:CipherData");
        Element cipherValue = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:CipherValue");
        cipherData.appendChild(cipherValue);
        WSSecurityUtil.appendChildElement(doc, encryptedKey, cipherData);
        return cipherValue;
    }

    public void prependToHeader(WSSecHeader secHeader) {
        WSSecurityUtil.prependChildElement(this.document, secHeader.getSecurityHeader(), this.encryptedKeyElement, false);
    }

    public void appendToHeader(WSSecHeader secHeader) {
        WSSecurityUtil.appendChildElement(this.document, secHeader.getSecurityHeader(), this.encryptedKeyElement);
    }

    public void prependBSTElementToHeader(WSSecHeader secHeader) {
        if (this.bstToken != null) {
            WSSecurityUtil.prependChildElement(this.document, secHeader.getSecurityHeader(), this.bstToken.getElement(), false);
        }
        this.bstToken = null;
    }

    public void appendBSTElementToHeader(WSSecHeader secHeader) {
        if (this.bstToken != null) {
            WSSecurityUtil.appendChildElement(this.document, secHeader.getSecurityHeader(), this.bstToken.getElement());
        }
        this.bstToken = null;
    }

    public byte[] getEphemeralKey() {
        return this.ephemeralKey;
    }

    public void setUseThisCert(X509Certificate cert) {
        this.useThisCert = cert;
    }

    public Element getEncryptedKeyElement() {
        return this.encryptedKeyElement;
    }

    public Element getBinarySecurityTokenElement() {
        if (this.bstToken != null) {
            return this.bstToken.getElement();
        }
        return null;
    }

    public void setKeySize(int keySize) throws WSSecurityException {
        if (keySize < 64) {
            throw new WSSecurityException("invalidKeySize");
        }
        this.keySize = keySize;
    }

    public void setKeyEncAlgo(String keyEncAlgo) {
        this.keyEncAlgo = keyEncAlgo;
    }

    public void setEphemeralKey(byte[] ephemeralKey) {
        this.ephemeralKey = ephemeralKey;
    }

    public String getBSTTokenId() {
        if (this.bstToken == null) {
            return null;
        }
        return this.bstToken.getID();
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void setEncKeyId(String encKeyId) {
        this.encKeyId = encKeyId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

