/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlElement;
import org.apache.cxf.jaxb.JAXBUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WrapperHelper {
    private WrapperHelper() {
    }

    public static void setWrappedPart(String partName, Object wrapperType, Object part) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (part instanceof List) {
            WrapperHelper.setWrappedListProperty(partName, wrapperType, part);
        } else {
            Field elField;
            String modifier;
            String fieldName = partName;
            if (JAXBUtils.isJavaKeyword(partName)) {
                fieldName = JAXBUtils.nameToIdentifier(partName, JAXBUtils.IdentifierType.VARIABLE);
            }
            if (part == null) {
                XmlElement el = null;
                Field elField2 = null;
                for (Field field : wrapperType.getClass().getDeclaredFields()) {
                    if (!field.getName().equals(fieldName)) continue;
                    elField2 = field;
                    el = elField2.getAnnotation(XmlElement.class);
                    break;
                }
                if (el != null && !el.nillable() && elField2.getType().isPrimitive()) {
                    throw new IllegalArgumentException("null value for field not permitted.");
                }
                return;
            }
            String modifier2 = modifier = JAXBUtils.nameToIdentifier(partName, JAXBUtils.IdentifierType.SETTER);
            if ("return".equals(partName)) {
                modifier2 = "set_return";
            }
            boolean setInvoked = false;
            for (Method method : wrapperType.getClass().getMethods()) {
                if (method.getParameterTypes() == null || method.getParameterTypes().length != 1 || !modifier.equals(method.getName()) && !modifier2.equals(method.getName())) continue;
                if ("javax.xml.bind.JAXBElement".equals(method.getParameterTypes()[0].getName())) {
                    if (!WrapperHelper.setJAXBElementValueIntoWrapType(method, wrapperType, part)) {
                        throw new RuntimeException("Failed to set the part value (" + part + ") to wrapper type (" + wrapperType.getClass() + ")");
                    }
                } else {
                    method.invoke(wrapperType, part);
                }
                setInvoked = true;
                break;
            }
            if (!setInvoked && (elField = WrapperHelper.getField(wrapperType, partName, fieldName)) != null) {
                elField.setAccessible(true);
                elField.set(wrapperType, part);
                setInvoked = true;
            }
            if (!setInvoked) {
                throw new IllegalArgumentException("Could not find a modifier method on Wrapper Type for " + partName);
            }
        }
    }

    private static Field getField(Object wrapperType, String partName, String fieldName) {
        XmlElement el;
        for (Field field : wrapperType.getClass().getDeclaredFields()) {
            if (!field.getName().equals(fieldName) || (el = field.getAnnotation(XmlElement.class)) == null || !el.name().equals(partName)) continue;
            return field;
        }
        for (Field field : wrapperType.getClass().getDeclaredFields()) {
            el = field.getAnnotation(XmlElement.class);
            if (el == null || !el.name().equals(partName)) continue;
            return field;
        }
        return null;
    }

    private static boolean setJAXBElementValueIntoWrapType(Method method, Object wrapType, Object value) {
        String typeClassName = wrapType.getClass().getCanonicalName();
        String objectFactoryClassName = typeClassName.substring(0, typeClassName.lastIndexOf(46)) + ".ObjectFactory";
        try {
            Object objectFactory = wrapType.getClass().getClassLoader().loadClass(objectFactoryClassName).newInstance();
            String methodName = "create" + wrapType.getClass().getSimpleName() + method.getName().substring(3);
            Method objectFactoryMethod = objectFactory.getClass().getMethod(methodName, value.getClass());
            if (objectFactoryMethod == null) {
                return false;
            }
            JAXBElement je = (JAXBElement)objectFactoryMethod.invoke(objectFactory, value);
            method.invoke(wrapType, je);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void setWrappedListProperty(String partName, Object wrapperType, Object part) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String accessorName = JAXBUtils.nameToIdentifier(partName, JAXBUtils.IdentifierType.GETTER);
        for (Method method : wrapperType.getClass().getMethods()) {
            if (!accessorName.equals(method.getName()) || !List.class.isAssignableFrom(method.getReturnType())) continue;
            Object ret = method.invoke(wrapperType, new Object[0]);
            Method addAll = ret.getClass().getMethod("addAll", Collection.class);
            addAll.invoke(ret, part);
            break;
        }
    }

    public static Object getWrappedPart(String partName, Object wrapperType, Class<?> partClazz) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String accessor = JAXBUtils.nameToIdentifier(partName, JAXBUtils.IdentifierType.GETTER);
        if (partClazz.equals(Boolean.TYPE) || partClazz.equals(Boolean.class)) {
            accessor = accessor.replaceFirst("get", "is");
        }
        for (Method method : wrapperType.getClass().getMethods()) {
            if (method.getParameterTypes().length != 0 || !accessor.equals(method.getName())) continue;
            return WrapperHelper.getValue(method, wrapperType);
        }
        return null;
    }

    public static Object getWrappedPart(String partName, Object wrapperType, String elementType) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String accessor = JAXBUtils.nameToIdentifier(partName, JAXBUtils.IdentifierType.GETTER);
        Method method = null;
        NoSuchMethodException nsex = null;
        try {
            method = wrapperType.getClass().getMethod(accessor, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            nsex = (NoSuchMethodException)ex.fillInStackTrace();
        }
        Field elField = null;
        if (method == null && elementType != null && "boolean".equals(elementType.toLowerCase()) && ((elField = WrapperHelper.getElField(partName, wrapperType)) == null || !Collection.class.isAssignableFrom(elField.getType()) && !elField.getType().isArray())) {
            try {
                method = wrapperType.getClass().getMethod(accessor.replaceFirst("get", "is"), new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        if (method == null && "return".equals(partName)) {
            try {
                method = wrapperType.getClass().getMethod("get_return", new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                try {
                    method = wrapperType.getClass().getMethod("is_return", new Class[0]);
                }
                catch (NoSuchMethodException ex2) {
                    // empty catch block
                }
            }
        }
        if (method != null) {
            return WrapperHelper.getValue(method, wrapperType);
        }
        if (elField == null) {
            elField = WrapperHelper.getElField(partName, wrapperType);
        }
        if (elField != null) {
            XmlElement el = elField.getAnnotation(XmlElement.class);
            if (el != null && partName.equals(el.name())) {
                elField.setAccessible(true);
                return elField.get(wrapperType);
            }
        } else if (nsex != null) {
            throw nsex;
        }
        return null;
    }

    private static Field getElField(String partName, Object wrapperType) {
        String fieldName = JAXBUtils.nameToIdentifier(partName, JAXBUtils.IdentifierType.VARIABLE);
        Field elField = null;
        for (Field field : wrapperType.getClass().getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            elField = field;
            break;
        }
        return elField;
    }

    public static Object getWrappedPart(String partName, Object wrapperType) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String accessor = JAXBUtils.nameToIdentifier(partName, JAXBUtils.IdentifierType.GETTER);
        for (Method method : wrapperType.getClass().getMethods()) {
            if (method.getParameterTypes().length != 0 || !accessor.equals(method.getName())) continue;
            return WrapperHelper.getValue(method, wrapperType);
        }
        return null;
    }

    private static Object getValue(Method method, Object in) throws IllegalAccessException, InvocationTargetException {
        if ("javax.xml.bind.JAXBElement".equals(method.getReturnType().getCanonicalName())) {
            JAXBElement je = (JAXBElement)method.invoke(in, new Object[0]);
            return je == null ? je : je.getValue();
        }
        return method.invoke(in, new Object[0]);
    }
}

