/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.io.InputStream;
import java.util.logging.Logger;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.ws.Service;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.XMLMessage;
import org.w3c.dom.Node;

public class DispatchInInterceptor
extends AbstractInDatabindingInterceptor {
    private static final Logger LOG = Logger.getLogger(DispatchInInterceptor.class.getName());
    private Class type;
    private Service.Mode mode;

    public DispatchInInterceptor(Class type, Service.Mode mode) {
        super("read");
        this.type = type;
        this.mode = mode;
    }

    public void handleMessage(Message message) throws Fault {
        if (this.isGET(message)) {
            LOG.info("DispatchInInterceptor skipped in HTTP GET method");
            return;
        }
        try {
            InputStream is = message.getContent(InputStream.class);
            if (message instanceof SoapMessage) {
                Object obj;
                SOAPMessage soapMessage = this.newSOAPMessage(is, ((SoapMessage)message).getVersion());
                if (this.type.equals(SOAPMessage.class)) {
                    obj = soapMessage;
                } else if (this.type.equals(SOAPBody.class)) {
                    obj = soapMessage.getSOAPBody();
                } else {
                    DataReader<Node> dataReader = this.getDataReader(message, Node.class);
                    Object n = null;
                    if (this.mode == Service.Mode.MESSAGE) {
                        n = soapMessage.getSOAPPart();
                    } else if (this.mode == Service.Mode.PAYLOAD) {
                        n = DOMUtils.getChild((Node)soapMessage.getSOAPBody(), 1);
                    }
                    if (Source.class.isAssignableFrom(this.type)) {
                        obj = dataReader.read(null, (Node)n, this.type);
                    } else {
                        dataReader.setProperty("unwrap.jaxb.element", Boolean.FALSE);
                        obj = dataReader.read((Node)n);
                    }
                }
                message.setContent(Object.class, obj);
            } else if (message instanceof XMLMessage) {
                new StaxInInterceptor().handleMessage(message);
                DataReader<XMLStreamReader> dataReader = this.getDataReader(message);
                Class readType = this.type;
                if (readType == Object.class) {
                    readType = null;
                }
                Object obj = dataReader.read(null, message.getContent(XMLStreamReader.class), readType);
                message.setContent(Object.class, obj);
            }
            is.close();
        }
        catch (Exception e) {
            throw new Fault(e);
        }
    }

    private SOAPMessage newSOAPMessage(InputStream is, SoapVersion version) throws Exception {
        MimeHeaders headers = new MimeHeaders();
        MessageFactory msgFactory = null;
        if (version == null || version instanceof Soap11) {
            msgFactory = MessageFactory.newInstance();
        } else if (version instanceof Soap12) {
            msgFactory = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
        }
        return msgFactory.createMessage(headers, is);
    }
}

