/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.servlet.ServletTransportFactory;

public class ServletDestination
extends AbstractHTTPDestination {
    static final Logger LOG = Logger.getLogger(ServletDestination.class.getName());
    private static final long serialVersionUID = 1L;
    final ServletTransportFactory factory;
    final String path;

    public ServletDestination(Bus b, ConduitInitiator ci, EndpointInfo ei, ServletTransportFactory fact, String p) throws IOException {
        super(b, ci, ei, false);
        this.factory = fact;
        this.path = p;
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected void copyResponseHeaders(Message message, HttpServletResponse response) {
        String ct = (String)message.get("Content-Type");
        String enc = (String)message.get(Message.ENCODING);
        if (null != ct) {
            if (enc != null && ct.indexOf("charset=") == -1) {
                ct = ct + "; charset=" + enc;
            }
            response.setContentType(ct);
        } else if (enc != null) {
            response.setContentType("text/xml; charset=" + enc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMessage(MessageImpl inMessage) throws IOException {
        try {
            this.setHeaders(inMessage);
            inMessage.setDestination(this);
            this.incomingObserver.onMessage(inMessage);
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Finished servicing http request on thread: " + Thread.currentThread());
            }
        }
    }

    public void shutdown() {
        this.factory.removeDestination(this.path);
        super.shutdown();
    }

    public MessageObserver getMessageObserver() {
        return this.incomingObserver;
    }

    public EndpointInfo getEndpointInfo() {
        return this.endpointInfo;
    }
}

