/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy.attachment.reference;

import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.resource.ExtendedURIResolver;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.policy.attachment.reference.ReferenceResolver;
import org.apache.neethi.Policy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RemoteReferenceResolver
implements ReferenceResolver {
    private String baseURI;
    private PolicyBuilder builder;

    public RemoteReferenceResolver(String uri, PolicyBuilder b) {
        this.baseURI = uri;
        this.builder = b;
    }

    public Policy resolveReference(String uri) {
        int pos = uri.indexOf(35);
        String documentURI = uri.substring(0, pos);
        InputSource is = new ExtendedURIResolver().resolve(documentURI, this.baseURI);
        if (null == is) {
            return null;
        }
        Document doc = null;
        try {
            doc = DOMUtils.readXml(is.getByteStream());
        }
        catch (Exception ex) {
            throw new PolicyException(ex);
        }
        NodeList nl = doc.getElementsByTagNameNS(PolicyConstants.getNamespace(), PolicyConstants.getPolicyElemName());
        String id = uri.substring(pos + 1);
        for (int i = 0; i < nl.getLength(); ++i) {
            Element elem = (Element)nl.item(i);
            if (!id.equals(elem.getAttributeNS(PolicyConstants.getWSUNamespace(), PolicyConstants.getIdAttrName()))) continue;
            return this.builder.getPolicy(elem);
        }
        return null;
    }
}

