/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.coloc;

import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.coloc.ColocUtil;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.ServiceInvokerInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColocInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = Logger.getLogger(ColocInInterceptor.class.getName());

    public ColocInInterceptor() {
        super("invoke");
        this.addAfter(ServiceInvokerInterceptor.class.getName());
    }

    public void handleMessage(Message msg) throws Fault {
        Exchange ex = msg.getExchange();
        if (ex.isOneWay()) {
            return;
        }
        Bus bus = (Bus)ex.get(Bus.class);
        TreeSet<Phase> phases = new TreeSet<Phase>(((PhaseManager)bus.getExtension(PhaseManager.class)).getOutPhases());
        ColocUtil.setPhases(phases, "setup", "user-logical");
        InterceptorChain chain = ColocUtil.getOutInterceptorChain(ex, phases);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Processing Message at collocated endpoint.  Response message: " + msg);
        }
        BindingOperationInfo boi = (BindingOperationInfo)ex.get(BindingOperationInfo.class);
        Message outBound = ex.getOutMessage();
        if (boi != null) {
            outBound.put(MessageInfo.class, (Object)boi.getOperationInfo().getOutput());
        }
        outBound.put((Object)"org.apache.cxf.message.inbound", (Object)Boolean.FALSE);
        outBound.setInterceptorChain(chain);
        chain.doIntercept(outBound);
    }
}

