/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.WrapperHelper;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperClassOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    public WrapperClassOutInterceptor() {
        super("pre-logical");
    }

    public void handleMessage(Message message) throws Fault {
        Exchange ex = message.getExchange();
        BindingOperationInfo bop = (BindingOperationInfo)ex.get(BindingOperationInfo.class);
        MessageInfo messageInfo = (MessageInfo)message.get(MessageInfo.class);
        if (messageInfo == null || bop == null || !bop.isUnwrapped()) {
            return;
        }
        BindingOperationInfo newbop = bop.getWrappedOperation();
        MessageInfo wrappedMsgInfo = Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.client")) ? newbop.getInput().getMessageInfo() : newbop.getOutput().getMessageInfo();
        Class wrapped = null;
        List parts = wrappedMsgInfo.getMessageParts();
        if (parts.size() > 0) {
            wrapped = ((MessagePartInfo)parts.get(0)).getTypeClass();
        }
        if (wrapped != null) {
            ArrayList objs = CastUtils.cast((List)((List)message.getContent(List.class)));
            try {
                Object wrapperType = wrapped.newInstance();
                int i = 0;
                for (MessagePartInfo p : messageInfo.getMessageParts()) {
                    Object part = objs.get(i);
                    WrapperHelper.setWrappedPart((String)p.getName().getLocalPart(), wrapperType, part);
                    ++i;
                }
                objs = new ArrayList(1);
                objs.add(wrapperType);
                message.setContent(List.class, objs);
            }
            catch (Exception exc) {
                throw new Fault((Throwable)exc);
            }
            ex.put(BindingOperationInfo.class, (Object)newbop);
            ex.put(OperationInfo.class, (Object)newbop.getOperationInfo());
            if (messageInfo == bop.getOperationInfo().getInput()) {
                message.put(MessageInfo.class, (Object)newbop.getOperationInfo().getInput());
                message.put(BindingMessageInfo.class, (Object)newbop.getInput());
            } else if (messageInfo == bop.getOperationInfo().getOutput()) {
                message.put(MessageInfo.class, (Object)newbop.getOperationInfo().getOutput());
                message.put(BindingMessageInfo.class, (Object)newbop.getOutput());
            }
        }
    }
}

