/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.generators;

import java.util.Map;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.common.model.JavaPort;
import org.apache.cxf.tools.common.model.JavaServiceClass;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.generators.AbstractJAXWSGenerator;

public class ImplGenerator
extends AbstractJAXWSGenerator {
    private static final String IMPL_TEMPLATE = "org/apache/cxf/tools/wsdlto/frontend/jaxws/template/impl.vm";

    public ImplGenerator() {
        this.name = "impl.generator";
    }

    public boolean passthrough() {
        if (this.env.optionSet("genImpl") || this.env.optionSet("impl") || this.env.optionSet("all")) {
            return false;
        }
        if (this.env.optionSet("genAnt") || this.env.optionSet("genTypes") || this.env.optionSet("genClient") || this.env.optionSet("genSEI") || this.env.optionSet("genServer") || this.env.optionSet("genService")) {
            return true;
        }
        return true;
    }

    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        JavaModel javaModel = (JavaModel)this.env.get(JavaModel.class);
        if (this.passthrough()) {
            return;
        }
        Map interfaces = javaModel.getInterfaces();
        Map services = javaModel.getServiceClasses();
        if (services.size() == 0) {
            ServiceInfo serviceInfo = (ServiceInfo)this.env.get(ServiceInfo.class);
            String wsdl = serviceInfo.getDescription().getBaseURI();
            Message msg = new Message("CAN_NOT_GEN_IMPL", LOG, new Object[]{wsdl});
            if (penv.isVerbose()) {
                System.out.println(msg.toString());
            }
            return;
        }
        JavaServiceClass service = null;
        String port = "";
        if (!services.values().isEmpty()) {
            JavaServiceClass javaservice;
            service = javaservice = (JavaServiceClass)services.values().iterator().next();
            if (javaservice.getPorts().size() != 0) {
                JavaPort jport = (JavaPort)javaservice.getPorts().get(0);
                port = jport.getPortName();
            }
        }
        for (String interfaceName : interfaces.keySet()) {
            JavaInterface intf = (JavaInterface)interfaces.get(interfaceName);
            this.clearAttributes();
            this.setAttributes("intf", intf);
            this.setAttributes("service", service);
            this.setAttributes("port", port);
            this.setCommonAttributes();
            this.doWrite(IMPL_TEMPLATE, this.parseOutputName(intf.getPackageName(), intf.getName() + "Impl"));
        }
    }
}

