/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.generators;

import java.util.Map;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.common.model.JavaPort;
import org.apache.cxf.tools.common.model.JavaServiceClass;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.generators.AbstractJAXWSGenerator;

public class ServerGenerator
extends AbstractJAXWSGenerator {
    private static final String SRV_TEMPLATE = "org/apache/cxf/tools/wsdlto/frontend/jaxws/template/server.vm";

    public ServerGenerator() {
        this.name = "svr.generator";
    }

    public boolean passthrough() {
        if (this.env.optionSet("genServer") || this.env.optionSet("server") || this.env.optionSet("all")) {
            return false;
        }
        if (this.env.optionSet("genAnt") || this.env.optionSet("genTypes") || this.env.optionSet("genClient") || this.env.optionSet("genImpl") || this.env.optionSet("genSEI") || this.env.optionSet("genService")) {
            return true;
        }
        return true;
    }

    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        JavaModel javaModel = (JavaModel)this.env.get(JavaModel.class);
        if (this.passthrough()) {
            return;
        }
        String address = "CHANGE_ME";
        Map interfaces = javaModel.getInterfaces();
        if (javaModel.getServiceClasses().size() == 0) {
            ServiceInfo serviceInfo = (ServiceInfo)this.env.get(ServiceInfo.class);
            String wsdl = serviceInfo.getDescription().getBaseURI();
            Message msg = new Message("CAN_NOT_GEN_SRV", LOG, new Object[]{wsdl});
            if (penv.isVerbose()) {
                System.out.println(msg.toString());
            }
            return;
        }
        for (String interfaceName : interfaces.keySet()) {
            JavaInterface intf = (JavaInterface)interfaces.get(interfaceName);
            for (JavaServiceClass js : javaModel.getServiceClasses().values()) {
                for (JavaPort jp : js.getPorts()) {
                    if (!interfaceName.equals(jp.getPortType())) continue;
                    address = jp.getBindingAdress();
                    break;
                }
                if ("".equals(address)) continue;
                break;
            }
            String serverClassName = interfaceName + "Server";
            while (this.isCollision(intf.getPackageName(), serverClassName)) {
                serverClassName = serverClassName + "_Server";
            }
            this.clearAttributes();
            this.setAttributes("serverClassName", serverClassName);
            this.setAttributes("intf", intf);
            if (penv.optionSet("implClass")) {
                this.setAttributes("impl", (String)penv.get("implClass"));
            } else {
                this.setAttributes("impl", intf.getName() + "Impl");
            }
            this.setAttributes("address", address);
            this.setCommonAttributes();
            this.doWrite(SRV_TEMPLATE, this.parseOutputName(intf.getPackageName(), serverClassName));
        }
    }
}

