/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.imageio.IIOException;
import org.apache.cxf.Bus;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.http.AbstractHTTPTransportFactory;
import org.apache.cxf.transport.http_jetty.JettyHTTPDestination;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;

public class JettyHTTPTransportFactory
extends AbstractHTTPTransportFactory {
    private Map<String, JettyHTTPDestination> destinations = new HashMap<String, JettyHTTPDestination>();

    @Resource(name="bus")
    public void setBus(Bus b) {
        super.setBus(b);
    }

    @PostConstruct
    public void finalizeConfig() {
        this.getJettyHTTPServerEngineFactory();
    }

    protected JettyHTTPServerEngineFactory getJettyHTTPServerEngineFactory() {
        JettyHTTPServerEngineFactory serverEngineFactory = (JettyHTTPServerEngineFactory)this.getBus().getExtension(JettyHTTPServerEngineFactory.class);
        if (serverEngineFactory == null) {
            serverEngineFactory = new JettyHTTPServerEngineFactory();
            serverEngineFactory.setBus(this.getBus());
            serverEngineFactory.finalizeConfig();
        }
        return serverEngineFactory;
    }

    public Destination getDestination(EndpointInfo endpointInfo) throws IOException {
        String addr = endpointInfo.getAddress();
        JettyHTTPDestination destination = this.destinations.get(addr);
        if (destination == null) {
            destination = this.createDestination(endpointInfo);
        }
        return destination;
    }

    private synchronized JettyHTTPDestination createDestination(EndpointInfo endpointInfo) throws IOException {
        JettyHTTPDestination destination = this.destinations.get(endpointInfo.getAddress());
        if (destination == null) {
            destination = new JettyHTTPDestination(this.getBus(), this, endpointInfo);
            this.destinations.put(endpointInfo.getAddress(), destination);
            this.configure((Object)destination);
            try {
                destination.finalizeConfig();
            }
            catch (GeneralSecurityException ex) {
                throw new IIOException("JSSE Security Exception ", ex);
            }
        }
        return destination;
    }

    void removeDestination(EndpointInfo ei) {
        this.destinations.remove(ei.getAddress());
    }
}

