/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.cxf;

import java.io.Serializable;
import java.net.URL;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.xml.namespace.QName;
import org.apache.cxf.connector.CXFConnectionFactory;
import org.apache.cxf.jca.core.resourceadapter.ResourceAdapterInternalException;
import org.apache.cxf.jca.cxf.CXFConnectionRequestInfo;
import org.apache.cxf.jca.cxf.ManagedConnectionFactoryImpl;

public class ConnectionFactoryImpl
implements CXFConnectionFactory,
Referenceable,
Serializable {
    private static final Logger LOG = Logger.getLogger(ConnectionFactoryImpl.class.getName());
    private ManagedConnectionFactory managedConnectionFactory;
    private ConnectionManager connectionManager;
    private Reference reference;

    public ConnectionFactoryImpl(ManagedConnectionFactory aMCF, ConnectionManager aCM) {
        this.managedConnectionFactory = aMCF;
        this.connectionManager = aCM;
        LOG.info("this=" + this);
    }

    public void setReference(Reference ref) {
        LOG.info("Reference : " + ref + " is set");
        this.reference = ref;
    }

    public Reference getReference() throws NamingException {
        LOG.info("Reference : " + this.reference + " is returned");
        return this.reference;
    }

    public Object getConnection(Class iface, URL wsdlLocation, QName serviceName) throws ResourceException {
        return this.getConnection(iface, wsdlLocation, serviceName, null);
    }

    public Object getConnection(Class iface, QName serviceName, QName portName) throws ResourceException {
        return this.getConnection(iface, null, serviceName, portName);
    }

    public Object getConnection(Class iface, QName serviceName) throws ResourceException {
        return this.getConnection(iface, null, serviceName, null);
    }

    public Object getBus() {
        return ((ManagedConnectionFactoryImpl)this.managedConnectionFactory).getBus();
    }

    public Object getConnection(Class iface, URL wsdlLocation, QName serviceName, QName portName) throws ResourceException {
        if (!iface.isInterface()) {
            throw new ResourceAdapterInternalException("The first argument to getConnection must be an Interface", new IllegalArgumentException(iface.toString() + " is not an Interface."));
        }
        LOG.info("connecting to: " + iface);
        CXFConnectionRequestInfo reqInfo = new CXFConnectionRequestInfo(iface, wsdlLocation, serviceName, portName);
        if (this.connectionManager == null) {
            ManagedConnection connection = this.managedConnectionFactory.createManagedConnection(null, (ConnectionRequestInfo)reqInfo);
            return connection.getConnection(null, (ConnectionRequestInfo)reqInfo);
        }
        return this.connectionManager.allocateConnection(this.managedConnectionFactory, (ConnectionRequestInfo)reqInfo);
    }
}

