/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.factory;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.util.factory.Factory;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.frontend.SimpleMethodDispatcher;
import org.apache.cxf.helpers.MethodComparator;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.ServiceImpl;
import org.apache.cxf.service.factory.AbstractServiceConfiguration;
import org.apache.cxf.service.factory.AbstractServiceFactoryBean;
import org.apache.cxf.service.factory.DefaultServiceConfiguration;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.invoker.ApplicationScopePolicy;
import org.apache.cxf.service.invoker.FactoryInvoker;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.invoker.LocalFactory;
import org.apache.cxf.service.invoker.ScopePolicy;
import org.apache.cxf.service.model.AbstractMessageContainer;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.UnwrappedOperationInfo;
import org.apache.cxf.wsdl11.WSDLServiceFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionServiceFactoryBean
extends AbstractServiceFactoryBean {
    public static final String GENERIC_TYPE = "generic.type";
    public static final String MODE_OUT = "messagepart.mode.out";
    public static final String MODE_INOUT = "messagepart.mode.inout";
    public static final String HOLDER = "messagepart.isholder";
    public static final String HEADER = "messagepart.isheader";
    public static final String ELEMENT_NAME = "messagepart.elementName";
    public static final String METHOD = "operation.method";
    private static final Logger LOG = Logger.getLogger(ReflectionServiceFactoryBean.class.getName());
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(ReflectionServiceFactoryBean.class);
    protected String wsdlURL;
    protected Class<?> serviceClass;
    private List<AbstractServiceConfiguration> serviceConfigurations = new ArrayList<AbstractServiceConfiguration>();
    private QName serviceName;
    private Invoker invoker;
    private Executor executor;
    private List<String> ignoredClasses = new ArrayList<String>();
    private SimpleMethodDispatcher methodDispatcher = new SimpleMethodDispatcher();
    private Boolean wrappedStyle;
    private Map<String, Object> properties;
    private QName endpointName;
    private boolean populateFromClass;

    public ReflectionServiceFactoryBean() {
        this.getServiceConfigurations().add(0, new DefaultServiceConfiguration());
        this.setDataBinding((DataBinding)new JAXBDataBinding());
        this.ignoredClasses.add("java.lang.Object");
        this.ignoredClasses.add("java.lang.Throwable");
        this.ignoredClasses.add("org.omg.CORBA_2_3.portable.ObjectImpl");
        this.ignoredClasses.add("org.omg.CORBA.portable.ObjectImpl");
        this.ignoredClasses.add("javax.ejb.EJBObject");
        this.ignoredClasses.add("javax.rmi.CORBA.Stub");
    }

    public Service create() {
        this.initializeServiceConfigurations();
        this.initializeServiceModel();
        this.initializeDefaultInterceptors();
        if (this.invoker != null) {
            this.getService().setInvoker(this.getInvoker());
        } else {
            this.getService().setInvoker(this.createInvoker());
        }
        if (this.getExecutor() != null) {
            this.getService().setExecutor(this.getExecutor());
        }
        if (this.getDataBinding() != null) {
            this.getService().setDataBinding(this.getDataBinding());
        }
        this.getService().put((Object)MethodDispatcher.class.getName(), (Object)this.getMethodDispatcher());
        this.createEndpoints();
        return this.getService();
    }

    protected void createEndpoints() {
        Service service = this.getService();
        for (ServiceInfo inf : service.getServiceInfos()) {
            for (EndpointInfo ei : inf.getEndpoints()) {
                try {
                    Endpoint ep = this.createEndpoint(ei);
                    service.getEndpoints().put(ei.getName(), ep);
                }
                catch (EndpointException e) {
                    throw new ServiceConstructionException((Throwable)e);
                }
            }
        }
    }

    public Endpoint createEndpoint(EndpointInfo ei) throws EndpointException {
        return new EndpointImpl(this.getBus(), this.getService(), ei);
    }

    protected void initializeServiceConfigurations() {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            c.setServiceFactory(this);
        }
    }

    protected void buildServiceFromWSDL(String url) {
        LOG.info("Creating Service " + this.getServiceQName() + " from WSDL: " + url);
        WSDLServiceFactory factory = new WSDLServiceFactory(this.getBus(), url, this.getServiceQName());
        this.setService(factory.create());
        if (this.properties != null) {
            this.getService().putAll(this.properties);
        }
        this.initializeWSDLOperations();
        if (this.getDataBinding() != null) {
            this.getDataBinding().initialize(this.getService());
        }
    }

    protected void buildServiceFromClass() {
        LOG.info("Creating Service " + this.getServiceQName() + " from class " + this.getServiceClass().getName());
        ServiceInfo serviceInfo = new ServiceInfo();
        ServiceImpl service = new ServiceImpl(serviceInfo);
        this.setService((Service)service);
        if (this.properties != null) {
            service.putAll(this.properties);
        }
        service.put((Object)MethodDispatcher.class.getName(), (Object)this.getMethodDispatcher());
        serviceInfo.setName(this.getServiceQName());
        serviceInfo.setTargetNamespace(serviceInfo.getName().getNamespaceURI());
        this.createInterface(serviceInfo);
        this.getDataBinding().initialize((Service)service);
        boolean isWrapped = this.isWrapped();
        if (isWrapped) {
            this.initializeWrappedSchema(serviceInfo);
        }
        for (OperationInfo opInfo : serviceInfo.getInterface().getOperations()) {
            Method m = (Method)opInfo.getProperty(METHOD);
            if (!this.isWrapped(m) && !this.isRPC(m) && opInfo.getInput() != null) {
                this.createBareMessage(serviceInfo, opInfo, false);
            }
            if (this.isWrapped(m) || this.isRPC(m) || opInfo.getOutput() == null) continue;
            this.createBareMessage(serviceInfo, opInfo, true);
        }
    }

    protected void initializeServiceModel() {
        String wsdlurl = this.getWsdlURL();
        if (!this.populateFromClass && wsdlurl != null) {
            this.buildServiceFromWSDL(wsdlurl);
        } else {
            this.buildServiceFromClass();
        }
    }

    public boolean isPopulateFromClass() {
        return this.populateFromClass;
    }

    public void setPopulateFromClass(boolean fomClass) {
        this.populateFromClass = fomClass;
    }

    protected InterfaceInfo getInterfaceInfo() {
        if (this.getEndpointInfo() != null) {
            return this.getEndpointInfo().getInterface();
        }
        QName qn = this.getInterfaceName();
        for (ServiceInfo si : this.getService().getServiceInfos()) {
            if (!qn.equals(si.getInterface().getName())) continue;
            return si.getInterface();
        }
        throw new ServiceConstructionException(new Message("COULD_NOT_FIND_PORTTYPE", BUNDLE, new Object[]{qn}));
    }

    protected void initializeWSDLOperations() {
        Method[] methods = this.serviceClass.getMethods();
        Arrays.sort(methods, new MethodComparator());
        InterfaceInfo intf = this.getInterfaceInfo();
        HashMap<QName, Method> validMethods = new HashMap<QName, Method>();
        for (Method m : methods) {
            if (!this.isValidMethod(m)) continue;
            QName opName = this.getOperationName(intf, m);
            validMethods.put(opName, m);
        }
        for (OperationInfo o : intf.getOperations()) {
            Method selected = null;
            for (Map.Entry m : validMethods.entrySet()) {
                QName opName = (QName)m.getKey();
                if (!o.getName().getNamespaceURI().equals(opName.getNamespaceURI()) || !this.isMatchOperation(o.getName().getLocalPart(), opName.getLocalPart())) continue;
                selected = (Method)m.getValue();
                break;
            }
            if (selected == null) {
                throw new ServiceConstructionException(new Message("NO_METHOD_FOR_OP", BUNDLE, new Object[]{o.getName()}));
            }
            this.initializeWSDLOperation(intf, o, selected);
        }
        for (ServiceInfo service : this.getService().getServiceInfos()) {
            for (BindingInfo bi : service.getBindings()) {
                for (BindingOperationInfo binfo : bi.getOperations()) {
                    binfo.updateUnwrappedOperation();
                }
            }
        }
    }

    protected void initializeWSDLOperation(InterfaceInfo intf, OperationInfo o, Method selected) {
    }

    protected Invoker createInvoker() {
        return new FactoryInvoker((Factory)new LocalFactory(this.getServiceClass()), (ScopePolicy)new ApplicationScopePolicy());
    }

    protected ServiceInfo createServiceInfo(InterfaceInfo intf) {
        ServiceInfo svcInfo = new ServiceInfo();
        svcInfo.setInterface(intf);
        return svcInfo;
    }

    protected InterfaceInfo createInterface(ServiceInfo serviceInfo) {
        QName intfName = this.getInterfaceName();
        InterfaceInfo intf = new InterfaceInfo(serviceInfo, intfName);
        Method[] methods = this.serviceClass.getMethods();
        Arrays.sort(methods, new MethodComparator());
        for (Method m : this.serviceClass.getMethods()) {
            if (!this.isValidMethod(m)) continue;
            this.createOperation(serviceInfo, intf, m);
        }
        return intf;
    }

    protected OperationInfo createOperation(ServiceInfo serviceInfo, InterfaceInfo intf, Method m) {
        OperationInfo op = intf.addOperation(this.getOperationName(intf, m));
        op.setProperty(m.getClass().getName(), (Object)m);
        op.setProperty("action", (Object)this.getAction(op, m));
        if (this.isWrapped(m)) {
            UnwrappedOperationInfo uOp = new UnwrappedOperationInfo(op);
            op.setUnwrappedOperation((OperationInfo)uOp);
            this.createMessageParts(intf, (OperationInfo)uOp, m);
            if (uOp.hasInput()) {
                MessageInfo msg = new MessageInfo(op, uOp.getInput().getName());
                op.setInput(uOp.getInputName(), msg);
                this.createInputWrappedMessageParts((OperationInfo)uOp, m, msg);
                for (MessagePartInfo p : uOp.getInput().getMessageParts()) {
                    p.setConcreteName(p.getName());
                }
            }
            if (uOp.hasOutput()) {
                QName name = uOp.getOutput().getName();
                MessageInfo msg = new MessageInfo(op, name);
                op.setOutput(uOp.getOutputName(), msg);
                this.createOutputWrappedMessageParts((OperationInfo)uOp, m, msg);
                for (MessagePartInfo p : uOp.getOutput().getMessageParts()) {
                    p.setConcreteName(p.getName());
                }
            }
        } else {
            this.createMessageParts(intf, op, m);
        }
        this.getMethodDispatcher().bind(op, m);
        return op;
    }

    protected void initializeWrappedSchema(ServiceInfo serviceInfo) {
        for (OperationInfo op : serviceInfo.getInterface().getOperations()) {
            QName qn;
            SchemaInfo s2;
            XmlSchemaElement e;
            QName wraperBeanName;
            if (op.getUnwrappedOperation() == null) continue;
            if (op.hasInput()) {
                wraperBeanName = ((MessagePartInfo)op.getInput().getMessageParts().get(0)).getElementQName();
                e = null;
                for (SchemaInfo s2 : serviceInfo.getSchemas()) {
                    e = s2.getElementByQName(wraperBeanName);
                    if (e == null) continue;
                    ((MessagePartInfo)op.getInput().getMessageParts().get(0)).setXmlSchema((XmlSchemaAnnotated)e);
                    break;
                }
                if (e == null) {
                    this.createWrappedSchema(serviceInfo, (AbstractMessageContainer)op.getInput(), (AbstractMessageContainer)op.getUnwrappedOperation().getInput(), wraperBeanName);
                }
                for (MessagePartInfo mpi : op.getInput().getMessageParts()) {
                    if (!Boolean.TRUE.equals(mpi.getProperty(HEADER))) continue;
                    qn = (QName)mpi.getProperty(ELEMENT_NAME);
                    mpi.setElement(true);
                    mpi.setElementQName(qn);
                    this.checkForHeaderElement(serviceInfo, mpi);
                }
            }
            if (!op.hasOutput()) continue;
            wraperBeanName = ((MessagePartInfo)op.getOutput().getMessageParts().get(0)).getElementQName();
            e = null;
            Iterator i$ = serviceInfo.getSchemas().iterator();
            while (i$.hasNext() && (e = (s2 = (SchemaInfo)i$.next()).getElementByQName(wraperBeanName)) == null) {
            }
            if (e == null) {
                this.createWrappedSchema(serviceInfo, (AbstractMessageContainer)op.getOutput(), (AbstractMessageContainer)op.getUnwrappedOperation().getOutput(), wraperBeanName);
            }
            for (MessagePartInfo mpi : op.getOutput().getMessageParts()) {
                if (!Boolean.TRUE.equals(mpi.getProperty(HEADER))) continue;
                qn = (QName)mpi.getProperty(ELEMENT_NAME);
                mpi.setElement(true);
                mpi.setElementQName(qn);
                this.checkForHeaderElement(serviceInfo, mpi);
            }
        }
    }

    protected void checkForHeaderElement(ServiceInfo serviceInfo, MessagePartInfo mpi) {
        for (SchemaInfo s : serviceInfo.getSchemas()) {
            XmlSchemaElement e = s.getElementByQName(mpi.getElementQName());
            if (e == null) continue;
            return;
        }
        SchemaInfo si = this.getOrCreateSchema(serviceInfo, mpi.getElementQName().getNamespaceURI());
        XmlSchema schema = si.getSchema();
        XmlSchemaElement el = new XmlSchemaElement();
        el.setQName(mpi.getElementQName());
        el.setName(mpi.getElementQName().getLocalPart());
        if (!this.isExistSchemaElement(schema, mpi.getElementQName())) {
            schema.getItems().add((XmlSchemaObject)el);
        }
        el.setMinOccurs(1L);
        el.setMaxOccurs(0L);
        el.setNillable(true);
        XmlSchemaType tp = (XmlSchemaType)mpi.getXmlSchema();
        el.setSchemaTypeName(tp.getQName());
    }

    protected boolean qualifyWrapperSchema() {
        return true;
    }

    protected void createWrappedSchema(ServiceInfo serviceInfo, AbstractMessageContainer wrappedMessage, AbstractMessageContainer unwrappedMessage, QName wraperBeanName) {
        SchemaInfo schemaInfo = this.getOrCreateSchema(serviceInfo, wraperBeanName.getNamespaceURI());
        this.createWrappedMessageSchema(serviceInfo, wrappedMessage, unwrappedMessage, schemaInfo.getSchema(), wraperBeanName);
    }

    protected void createBareMessage(ServiceInfo serviceInfo, OperationInfo opInfo, boolean isOut) {
        MessageInfo message;
        SchemaInfo schemaInfo = null;
        XmlSchema schema = null;
        MessageInfo messageInfo = message = isOut ? opInfo.getOutput() : opInfo.getInput();
        if (message.getMessageParts().size() == 0) {
            return;
        }
        Method method = (Method)opInfo.getProperty(METHOD);
        int paraNumber = 0;
        for (MessagePartInfo mpi : message.getMessageParts()) {
            QName qname = (QName)mpi.getProperty(ELEMENT_NAME);
            if (message.getMessageParts().size() == 1) {
                qname = qname == null && !isOut ? this.getInParameterName(opInfo, method, -1) : qname;
                QName qName = qname = qname == null && isOut ? this.getOutParameterName(opInfo, method, -1) : qname;
                if (qname.getLocalPart().startsWith("arg") || qname.getLocalPart().startsWith("return")) {
                    QName qName2 = qname = isOut ? new QName(qname.getNamespaceURI(), method.getName() + "Response") : new QName(qname.getNamespaceURI(), method.getName());
                }
            }
            if (isOut && message.getMessageParts().size() > 1 && qname == null) {
                while (!this.isOutParam(method, paraNumber)) {
                    ++paraNumber;
                }
                qname = this.getOutParameterName(opInfo, method, paraNumber);
            } else if (qname == null) {
                qname = this.getInParameterName(opInfo, method, paraNumber);
            }
            for (SchemaInfo s : serviceInfo.getSchemas()) {
                if (!s.getNamespaceURI().equals(qname.getNamespaceURI())) continue;
                schemaInfo = s;
                break;
            }
            if (schemaInfo == null) {
                schemaInfo = new SchemaInfo(serviceInfo, qname.getNamespaceURI());
                XmlSchemaCollection col = new XmlSchemaCollection();
                schema = new XmlSchema(qname.getNamespaceURI(), col);
                schema.setElementFormDefault(new XmlSchemaForm("qualified"));
                serviceInfo.setXmlSchemaCollection(col);
                NamespaceMap nsMap = new NamespaceMap();
                nsMap.add("xsd", "http://www.w3.org/2001/XMLSchema");
                schema.setNamespaceContext((NamespacePrefixList)nsMap);
                serviceInfo.addSchema(schemaInfo);
            } else {
                schema = schemaInfo.getSchema();
                if (schema != null && schema.getElementByName(qname) != null) {
                    mpi.setElement(true);
                    mpi.setElementQName(qname);
                    ++paraNumber;
                    continue;
                }
            }
            XmlSchemaElement el = new XmlSchemaElement();
            el.setQName(qname);
            el.setName(qname.getLocalPart());
            if (!this.isExistSchemaElement(schema, qname)) {
                schema.getItems().add((XmlSchemaObject)el);
            }
            el.setMinOccurs(1L);
            el.setMaxOccurs(0L);
            el.setNillable(true);
            if (mpi.isElement()) continue;
            el.setSchemaTypeName(mpi.getTypeQName());
            String ns = mpi.getTypeQName().getNamespaceURI();
            if (!ns.equals(schema.getTargetNamespace()) && !ns.equals("http://www.w3.org/2001/XMLSchema")) {
                XmlSchemaImport is = new XmlSchemaImport();
                is.setNamespace(ns);
                if (!this.isExistImport(schema, ns)) {
                    schema.getItems().add((XmlSchemaObject)is);
                }
            }
            schemaInfo.setSchema(schema);
            mpi.setElement(true);
            mpi.setElementQName(qname);
            ++paraNumber;
        }
    }

    private boolean isExistImport(XmlSchema schema, String ns) {
        boolean isExist = false;
        Iterator ite = schema.getItems().getIterator();
        while (ite.hasNext()) {
            XmlSchemaImport xsImport;
            XmlSchemaObject obj = (XmlSchemaObject)ite.next();
            if (!(obj instanceof XmlSchemaImport) || !(xsImport = (XmlSchemaImport)obj).getNamespace().equals(ns)) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    private boolean isExistSchemaElement(XmlSchema schema, QName qn) {
        boolean isExist = false;
        Iterator ite = schema.getItems().getIterator();
        while (ite.hasNext()) {
            XmlSchemaElement xsEle;
            XmlSchemaObject obj = (XmlSchemaObject)ite.next();
            if (!(obj instanceof XmlSchemaElement) || !(xsEle = (XmlSchemaElement)obj).getQName().equals(qn)) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    private void createWrappedMessageSchema(ServiceInfo serviceInfo, AbstractMessageContainer wrappedMessage, AbstractMessageContainer unwrappedMessage, XmlSchema schema, QName wrapperName) {
        XmlSchemaElement el = new XmlSchemaElement();
        el.setQName(wrapperName);
        el.setName(wrapperName.getLocalPart());
        schema.getItems().add((XmlSchemaObject)el);
        ((MessagePartInfo)wrappedMessage.getMessageParts().get(0)).setXmlSchema((XmlSchemaAnnotated)el);
        XmlSchemaComplexType ct = new XmlSchemaComplexType(schema);
        ct.setName(wrapperName.getLocalPart());
        el.setSchemaTypeName(wrapperName);
        schema.addType((XmlSchemaType)ct);
        schema.getItems().add((XmlSchemaObject)ct);
        XmlSchemaSequence seq = new XmlSchemaSequence();
        ct.setParticle((XmlSchemaParticle)seq);
        for (MessagePartInfo mpi : unwrappedMessage.getMessageParts()) {
            el = new XmlSchemaElement();
            el.setName(mpi.getName().getLocalPart());
            el.setQName(mpi.getName());
            if (mpi.isElement()) {
                el.setRefName(mpi.getElementQName());
            } else {
                el.setSchemaTypeName(mpi.getTypeQName());
            }
            if (!Boolean.TRUE.equals(mpi.getProperty(HEADER))) {
                if (mpi.getTypeClass() != null && mpi.getTypeClass().isArray() && !Byte.TYPE.equals(mpi.getTypeClass().getComponentType())) {
                    el.setMinOccurs(0L);
                    el.setMaxOccurs(Long.MAX_VALUE);
                } else {
                    el.setMaxOccurs(1L);
                    if (mpi.getTypeClass() != null && !mpi.getTypeClass().isPrimitive()) {
                        el.setMinOccurs(0L);
                    }
                }
                seq.getItems().add((XmlSchemaObject)el);
            }
            if (!Boolean.TRUE.equals(mpi.getProperty(HEADER))) continue;
            QName qn = (QName)mpi.getProperty(ELEMENT_NAME);
            el.setName(qn.getLocalPart());
            el.setQName(qn);
            SchemaInfo headerSchemaInfo = this.getOrCreateSchema(serviceInfo, qn.getNamespaceURI());
            if (this.isExistSchemaElement(headerSchemaInfo.getSchema(), qn)) continue;
            headerSchemaInfo.getSchema().getItems().add((XmlSchemaObject)el);
        }
    }

    private SchemaInfo getOrCreateSchema(ServiceInfo serviceInfo, String namespaceURI) {
        for (SchemaInfo s : serviceInfo.getSchemas()) {
            if (!s.getNamespaceURI().equals(namespaceURI)) continue;
            return s;
        }
        SchemaInfo schemaInfo = new SchemaInfo(serviceInfo, namespaceURI);
        XmlSchemaCollection col = new XmlSchemaCollection();
        XmlSchema schema = new XmlSchema(namespaceURI, col);
        if (this.qualifyWrapperSchema()) {
            schema.setElementFormDefault(new XmlSchemaForm("qualified"));
        }
        serviceInfo.setXmlSchemaCollection(col);
        schemaInfo.setSchema(schema);
        NamespaceMap nsMap = new NamespaceMap();
        nsMap.add("xsd", "http://www.w3.org/2001/XMLSchema");
        schema.setNamespaceContext((NamespacePrefixList)nsMap);
        serviceInfo.addSchema(schemaInfo);
        return schemaInfo;
    }

    protected void createMessageParts(InterfaceInfo intf, OperationInfo op, Method method) {
        Class<?>[] paramClasses = method.getParameterTypes();
        op.setProperty(METHOD, (Object)method);
        MessageInfo inMsg = op.createMessage(this.getInputMessageName(op, method));
        op.setInput(inMsg.getName().getLocalPart(), inMsg);
        for (int j = 0; j < paramClasses.length; ++j) {
            if (!this.isInParam(method, j)) continue;
            QName q = this.getInParameterName(op, method, j);
            QName q2 = this.getInPartName(op, method, j);
            MessagePartInfo part = inMsg.addMessagePart(q2);
            this.initializeParameter(part, paramClasses[j], method.getGenericParameterTypes()[j]);
            if (!this.isWrapped(method) && !this.isRPC(method)) {
                part.setProperty(ELEMENT_NAME, (Object)q);
            }
            if (this.isHeader(method, j)) {
                part.setProperty(HEADER, (Object)Boolean.TRUE);
                if (this.isRPC(method) || !this.isWrapped(method)) {
                    part.setElementQName(q);
                } else {
                    part.setProperty(ELEMENT_NAME, (Object)q);
                }
            }
            part.setIndex(j);
        }
        if (this.hasOutMessage(method)) {
            MessageInfo outMsg = op.createMessage(this.createOutputMessageName(op, method));
            op.setOutput(outMsg.getName().getLocalPart(), outMsg);
            Class<Void> returnType = method.getReturnType();
            if (!returnType.isAssignableFrom(Void.TYPE)) {
                QName q = this.getOutPartName(op, method, -1);
                QName q2 = this.getOutParameterName(op, method, -1);
                MessagePartInfo part = outMsg.addMessagePart(q);
                this.initializeParameter(part, method.getReturnType(), method.getGenericReturnType());
                if (!this.isRPC(method) && !this.isWrapped(method)) {
                    part.setProperty(ELEMENT_NAME, (Object)q2);
                }
                if (this.isHeader(method, -1)) {
                    part.setProperty(HEADER, (Object)Boolean.TRUE);
                    if (this.isRPC(method) || !this.isWrapped(method)) {
                        part.setElementQName(q2);
                    } else {
                        part.setProperty(ELEMENT_NAME, (Object)q2);
                    }
                }
                part.setIndex(-1);
            }
            for (int j = 0; j < paramClasses.length; ++j) {
                if (!this.isOutParam(method, j)) continue;
                if (outMsg == null) {
                    outMsg = op.createMessage(this.createOutputMessageName(op, method));
                }
                QName q = this.getOutPartName(op, method, j);
                QName q2 = this.getOutParameterName(op, method, j);
                if (this.isInParam(method, j)) {
                    q = op.getInput().getMessagePartByIndex(j).getName();
                    q2 = (QName)op.getInput().getMessagePartByIndex(j).getProperty(ELEMENT_NAME);
                    if (q2 == null) {
                        q2 = op.getInput().getMessagePartByIndex(j).getElementQName();
                    }
                }
                MessagePartInfo part = outMsg.addMessagePart(q);
                this.initializeParameter(part, paramClasses[j], method.getGenericParameterTypes()[j]);
                part.setIndex(j);
                if (!this.isRPC(method) && !this.isWrapped(method)) {
                    part.setProperty(ELEMENT_NAME, (Object)q2);
                }
                if (this.isInParam(method, j)) {
                    part.setProperty(MODE_INOUT, (Object)Boolean.TRUE);
                }
                if (!this.isHeader(method, j)) continue;
                part.setProperty(ELEMENT_NAME, (Object)q2);
                part.setProperty(HEADER, (Object)Boolean.TRUE);
            }
        }
        this.initializeFaults(intf, op, method);
    }

    protected void createFaultWrappedMessageParts(FaultInfo fault) {
        MessagePartInfo part = fault.addMessagePart("fault");
        part.setElement(true);
        if (part.getElementQName() == null) {
            part.setElementQName(fault.getFaultName());
        }
    }

    protected void createInputWrappedMessageParts(OperationInfo op, Method method, MessageInfo inMsg) {
        MessagePartInfo part = inMsg.addMessagePart("parameters");
        part.setElement(true);
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getRequestWrapperName(op, method);
            if (q == null) continue;
            part.setElementQName(q);
        }
        if (part.getElementQName() == null) {
            part.setElementQName(inMsg.getName());
        } else if (!part.getElementQName().equals(op.getInput().getName())) {
            op.getInput().setName(part.getElementQName());
        }
        if (this.getRequestWrapper(method) != null) {
            part.setTypeClass(this.getRequestWrapper(method));
        } else if (this.getRequestWrapperClassName(method) != null) {
            part.setProperty("REQUEST.WRAPPER.CLASSNAME", (Object)this.getRequestWrapperClassName(method));
        }
        for (MessagePartInfo mpart : op.getInput().getMessageParts()) {
            if (!Boolean.TRUE.equals(mpart.getProperty(HEADER))) continue;
            int idx = mpart.getIndex();
            inMsg.addMessagePart(mpart);
            mpart.setIndex(idx);
        }
    }

    protected void createOutputWrappedMessageParts(OperationInfo op, Method method, MessageInfo outMsg) {
        MessagePartInfo part = outMsg.addMessagePart("parameters");
        part.setElement(true);
        part.setIndex(-1);
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getResponseWrapperName(op, method);
            if (q == null) continue;
            part.setElementQName(q);
        }
        if (part.getElementQName() == null) {
            part.setElementQName(outMsg.getName());
        } else if (!part.getElementQName().equals(op.getOutput().getName())) {
            op.getOutput().setName(part.getElementQName());
        }
        if (this.getResponseWrapper(method) != null) {
            part.setTypeClass(this.getResponseWrapper(method));
        } else if (this.getResponseWrapperClassName(method) != null) {
            part.setProperty("RESPONSE.WRAPPER.CLASSNAME", (Object)this.getResponseWrapperClassName(method));
        }
        for (MessagePartInfo mpart : op.getOutput().getMessageParts()) {
            if (!Boolean.TRUE.equals(mpart.getProperty(HEADER))) continue;
            int idx = mpart.getIndex();
            outMsg.addMessagePart(mpart);
            mpart.setIndex(idx);
        }
    }

    protected void initializeParameter(MessagePartInfo part, Class rawClass, Type type) {
        if (rawClass.equals(Holder.class) && type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            rawClass = this.getHolderClass(paramType);
        }
        part.setProperty(GENERIC_TYPE, (Object)type);
        part.setTypeClass(rawClass);
    }

    protected Class getHolderClass(ParameterizedType paramType) {
        Class<?> rawClass;
        Type rawType = paramType.getActualTypeArguments()[0];
        if (rawType instanceof GenericArrayType) {
            rawClass = (Class<?>)((GenericArrayType)rawType).getGenericComponentType();
            rawClass = Array.newInstance(rawClass, 0).getClass();
        } else {
            if (rawType instanceof ParameterizedType) {
                rawType = (Class)((ParameterizedType)rawType).getRawType();
            }
            rawClass = (Class)rawType;
        }
        return rawClass;
    }

    public QName getServiceQName() {
        if (this.serviceName == null) {
            this.serviceName = new QName(this.getServiceNamespace(), this.getServiceName());
        }
        return this.serviceName;
    }

    public QName getEndpointName() {
        if (this.endpointName != null) {
            return this.endpointName;
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName name = c.getEndpointName();
            if (name == null) continue;
            this.endpointName = name;
            return name;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    public EndpointInfo getEndpointInfo() {
        return this.getService().getEndpointInfo(this.getEndpointName());
    }

    public void setEndpointName(QName en) {
        this.endpointName = en;
    }

    protected String getServiceName() {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            String name = c.getServiceName();
            if (name == null) continue;
            return name;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    protected String getServiceNamespace() {
        if (this.serviceName != null) {
            return this.serviceName.getNamespaceURI();
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            String name = c.getServiceNamespace();
            if (name == null) continue;
            return name;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    public QName getInterfaceName() {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName name = c.getInterfaceName();
            if (name == null) continue;
            return name;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    protected boolean isValidMethod(Method method) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isOperation(method);
            if (b == null) continue;
            return b;
        }
        return true;
    }

    protected boolean isWrapped(Method method) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isWrapped(method);
            if (b == null) continue;
            return b;
        }
        return true;
    }

    protected boolean isMatchOperation(String methodNameInClass, String methodNameInWsdl) {
        String initOfMethodInWsdl;
        boolean ret = false;
        String initOfMethodInClass = methodNameInClass.substring(0, 1);
        if (initOfMethodInClass.equalsIgnoreCase(initOfMethodInWsdl = methodNameInWsdl.substring(0, 1)) && methodNameInClass.substring(1, methodNameInClass.length()).equals(methodNameInWsdl.substring(1, methodNameInWsdl.length()))) {
            ret = true;
        }
        return ret;
    }

    protected boolean isOutParam(Method method, int j) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isOutParam(method, j);
            if (b == null) continue;
            return b;
        }
        return true;
    }

    protected boolean isInParam(Method method, int j) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isInParam(method, j);
            if (b == null) continue;
            return b;
        }
        return true;
    }

    protected QName getInputMessageName(OperationInfo op, Method method) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getInputMessageName(op, method);
            if (q == null) continue;
            return q;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    protected QName createOutputMessageName(OperationInfo op, Method method) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getOutputMessageName(op, method);
            if (q == null) continue;
            return q;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    protected boolean hasOutMessage(Method m) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.hasOutMessage(m);
            if (b == null) continue;
            return b;
        }
        return true;
    }

    protected void initializeFaults(InterfaceInfo service, OperationInfo op, Method method) {
        Class<?>[] exceptionClasses = method.getExceptionTypes();
        for (int i = 0; i < exceptionClasses.length; ++i) {
            Class<?> exClazz = exceptionClasses[i];
            if (exClazz.equals(Exception.class) || Fault.class.isAssignableFrom(exClazz) || exClazz.equals(RuntimeException.class) || exClazz.equals(Throwable.class)) continue;
            this.addFault(service, op, exClazz);
        }
    }

    protected FaultInfo addFault(InterfaceInfo service, OperationInfo op, Class exClass) {
        Class<?> beanClass = this.getBeanClass(exClass);
        if (beanClass == null) {
            return null;
        }
        QName faultName = this.getFaultName(service, op, exClass, beanClass);
        FaultInfo fi = op.addFault(faultName, faultName);
        fi.setProperty(Class.class.getName(), (Object)exClass);
        MessagePartInfo mpi = fi.addMessagePart(new QName(op.getName().getNamespaceURI(), "fault"));
        mpi.setTypeClass(beanClass);
        return fi;
    }

    protected void createFaultForException(Class<?> exClass, FaultInfo fi) {
        Field[] fields;
        for (Field field : fields = exClass.getDeclaredFields()) {
            MessagePartInfo mpi = fi.addMessagePart(new QName(fi.getName().getNamespaceURI(), field.getName()));
            mpi.setProperty(Class.class.getName(), field.getType());
        }
        MessagePartInfo mpi = fi.addMessagePart(new QName(fi.getName().getNamespaceURI(), "message"));
        mpi.setProperty(Class.class.getName(), String.class);
    }

    protected Class<?> getBeanClass(Class<?> exClass) {
        if (RemoteException.class.isAssignableFrom(exClass)) {
            return null;
        }
        return exClass;
    }

    protected QName getFaultName(InterfaceInfo service, OperationInfo o, Class exClass, Class beanClass) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getFaultName(service, o, exClass, beanClass);
            if (q == null) continue;
            return q;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    protected String getAction(OperationInfo op, Method method) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            String s = c.getAction(op, method);
            if (s == null) continue;
            return s;
        }
        return "";
    }

    public boolean isHeader(Method method, int j) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isHeader(method, j);
            if (b == null) continue;
            return b;
        }
        return true;
    }

    protected QName getOperationName(InterfaceInfo service, Method method) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName s = c.getOperationName(service, method);
            if (s == null) continue;
            return s;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    protected boolean isAsync(Method method) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isAsync(method);
            if (b == null) continue;
            return b;
        }
        return true;
    }

    protected QName getInPartName(OperationInfo op, Method method, int paramNumber) {
        if (paramNumber == -1) {
            return null;
        }
        if (this.isWrapped(method) && !this.isHeader(method, paramNumber)) {
            return this.getInParameterName(op, method, paramNumber);
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getInPartName(op, method, paramNumber);
            if (q == null) continue;
            return q;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    protected QName getInParameterName(OperationInfo op, Method method, int paramNumber) {
        if (paramNumber == -1) {
            return null;
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getInParameterName(op, method, paramNumber);
            if (q == null) continue;
            return q;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    protected QName getOutParameterName(OperationInfo op, Method method, int paramNumber) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getOutParameterName(op, method, paramNumber);
            if (q == null) continue;
            return q;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    protected QName getOutPartName(OperationInfo op, Method method, int paramNumber) {
        if (this.isWrapped(method)) {
            return this.getOutParameterName(op, method, paramNumber);
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getOutPartName(op, method, paramNumber);
            if (q == null) continue;
            return q;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    protected Class getResponseWrapper(Method selected) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Class cls = c.getResponseWrapper(selected);
            if (cls == null) continue;
            return cls;
        }
        return null;
    }

    protected String getResponseWrapperClassName(Method selected) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            String cls = c.getResponseWrapperClassName(selected);
            if (cls == null) continue;
            return cls;
        }
        return null;
    }

    protected Class getRequestWrapper(Method selected) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Class cls = c.getRequestWrapper(selected);
            if (cls == null) continue;
            return cls;
        }
        return null;
    }

    protected String getRequestWrapperClassName(Method selected) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            String cls = c.getRequestWrapperClassName(selected);
            if (cls == null) continue;
            return cls;
        }
        return null;
    }

    protected SimpleMethodDispatcher getMethodDispatcher() {
        return this.methodDispatcher;
    }

    public List<AbstractServiceConfiguration> getConfigurations() {
        return this.serviceConfigurations;
    }

    public void setConfigurations(List<AbstractServiceConfiguration> configurations) {
        this.serviceConfigurations = configurations;
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(Class<?> serviceClass) {
        this.serviceClass = serviceClass;
    }

    public String getWsdlURL() {
        if (this.wsdlURL == null) {
            for (AbstractServiceConfiguration c : this.serviceConfigurations) {
                this.wsdlURL = c.getWsdlURL();
                if (this.wsdlURL == null) continue;
                this.wsdlURL = new String(this.wsdlURL);
                break;
            }
        }
        return this.wsdlURL;
    }

    public void setWsdlURL(String wsdlURL) {
        this.wsdlURL = new String(wsdlURL);
    }

    public void setWsdlURL(URL wsdlURL) {
        this.wsdlURL = wsdlURL.toString();
    }

    public List<AbstractServiceConfiguration> getServiceConfigurations() {
        return this.serviceConfigurations;
    }

    public void setServiceConfigurations(List<AbstractServiceConfiguration> serviceConfigurations) {
        this.serviceConfigurations = serviceConfigurations;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public List<String> getIgnoredClasses() {
        return this.ignoredClasses;
    }

    public void setIgnoredClasses(List<String> ignoredClasses) {
        this.ignoredClasses = ignoredClasses;
    }

    public boolean isWrapped() {
        if (this.wrappedStyle != null) {
            return this.wrappedStyle;
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isWrapped();
            if (b == null) continue;
            return b;
        }
        return true;
    }

    public String getStyle() {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            String style = c.getStyle();
            if (style == null) continue;
            return style;
        }
        return "document";
    }

    public boolean isRPC(Method method) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isRPC(method);
            if (b == null) continue;
            return b;
        }
        return true;
    }

    public void setWrapped(boolean style) {
        this.wrappedStyle = style;
    }

    public Boolean getWrapped() {
        return this.wrappedStyle;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }
}

