/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.databinding;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.databinding.XMLStreamDataReader;
import org.apache.cxf.aegis.databinding.XMLStreamDataWriter;
import org.apache.cxf.aegis.type.DefaultTypeMappingRegistry;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.TypeMapping;
import org.apache.cxf.aegis.type.TypeMappingRegistry;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.type.basic.BeanType;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.frontend.SimpleMethodDispatcher;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.AbstractMessageContainer;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.output.DOMOutputter;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AegisDatabinding
implements DataBinding {
    public static final String CURRENT_MESSAGE_PART = "currentMessagePart";
    public static final String TYPE_MAPPING_KEY = "type.mapping";
    public static final String ENCODING_URI_KEY = "type.encodingUri";
    public static final String WRITE_XSI_TYPE_KEY = "writeXsiType";
    public static final String OVERRIDE_TYPES_KEY = "overrideTypesList";
    public static final String READ_XSI_TYPE_KEY = "readXsiType";
    protected static final int IN_PARAM = 0;
    protected static final int OUT_PARAM = 1;
    protected static final int FAULT_PARAM = 2;
    private TypeMappingRegistry typeMappingRegistry = new DefaultTypeMappingRegistry(true);
    private Map<MessagePartInfo, Type> part2Type = new HashMap<MessagePartInfo, Type>();
    private List overrideTypes;
    private Service service;

    @Override
    public <T> DataReader<T> createReader(Class<T> cls) {
        if (cls.equals(XMLStreamReader.class)) {
            return new XMLStreamDataReader(this);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> DataWriter<T> createWriter(Class<T> cls) {
        if (cls.equals(XMLStreamWriter.class)) {
            return new XMLStreamDataWriter(this);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<?>[] getSupportedReaderFormats() {
        return new Class[]{XMLStreamReader.class, Node.class};
    }

    @Override
    public Class<?>[] getSupportedWriterFormats() {
        return new Class[]{XMLStreamWriter.class, Node.class};
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.typeMappingRegistry;
    }

    public void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this.typeMappingRegistry = typeMappingRegistry;
    }

    @Override
    public void initialize(Service s) {
        this.service = s;
        QName serviceName = s.getServiceInfos().get(0).getName();
        TypeMapping serviceTM = this.typeMappingRegistry.createTypeMapping("http://www.w3.org/2001/XMLSchema", true);
        this.typeMappingRegistry.register(serviceName.getNamespaceURI(), serviceTM);
        s.put(TypeMapping.class.getName(), serviceTM);
        HashSet<Type> deps = new HashSet<Type>();
        for (ServiceInfo info : s.getServiceInfos()) {
            for (OperationInfo opInfo : info.getInterface().getOperations()) {
                if (opInfo.isUnwrappedCapable()) {
                    this.initializeOperation(s, serviceTM, opInfo.getUnwrappedOperation(), deps);
                    continue;
                }
                this.initializeOperation(s, serviceTM, opInfo, deps);
            }
        }
        List<Type> additional = this.getAdditionalTypes(s, serviceTM);
        if (additional != null) {
            for (Type t : additional) {
                if (deps.contains(t)) continue;
                deps.add(t);
            }
        }
        this.createSchemas(s, deps);
    }

    List<Type> getAdditionalTypes(Service s, TypeMapping tm) {
        List classes;
        this.overrideTypes = classes = (List)s.get(OVERRIDE_TYPES_KEY);
        if (classes != null) {
            ArrayList<Type> types = new ArrayList<Type>();
            for (String typeName : classes) {
                Class c;
                try {
                    c = ClassLoaderUtils.loadClass(typeName, TypeUtil.class);
                }
                catch (ClassNotFoundException e) {
                    throw new DatabindingException("Could not find override type class: " + typeName, e);
                }
                Type t = tm.getType(c);
                if (t == null) {
                    t = tm.getTypeCreator().createType(c);
                    tm.register(t);
                }
                if (!(t instanceof BeanType)) continue;
                BeanType bt = (BeanType)t;
                bt.getTypeInfo().setExtension(true);
                types.add(bt);
            }
            return types;
        }
        return null;
    }

    private void initializeOperation(Service s, TypeMapping serviceTM, OperationInfo opInfo, Set<Type> deps) {
        try {
            this.initializeMessage(s, serviceTM, opInfo.getInput(), 0, deps);
            if (opInfo.hasOutput()) {
                this.initializeMessage(s, serviceTM, opInfo.getOutput(), 1, deps);
            }
            for (FaultInfo info : opInfo.getFaults()) {
                this.initializeMessage(s, serviceTM, info, 2, deps);
            }
        }
        catch (DatabindingException e) {
            e.prepend("Error initializing parameters for operation " + opInfo.getName());
            throw e;
        }
    }

    protected void initializeMessage(Service s, TypeMapping serviceTM, AbstractMessageContainer container, int partType, Set<Type> deps) {
        for (MessagePartInfo part : container.getMessageParts()) {
            Type type = this.getParameterType(s, serviceTM, part, partType);
            if (type.isAbstract()) {
                part.setTypeQName(type.getSchemaType());
            } else {
                part.setElementQName(type.getSchemaType());
            }
            this.part2Type.put(part, type);
            deps.add(type);
            Set<Type> typeDeps = type.getDependencies();
            if (typeDeps == null) continue;
            for (Type t : typeDeps) {
                if (deps.contains(t)) continue;
                deps.add(t);
            }
        }
    }

    private void createSchemas(Service s, Set<Type> deps) {
        HashMap<String, HashSet<Type>> tns2Type = new HashMap<String, HashSet<Type>>();
        for (Type type : deps) {
            String ns = type.getSchemaType().getNamespaceURI();
            HashSet<Type> types = (HashSet<Type>)tns2Type.get(ns);
            if (types == null) {
                types = new HashSet<Type>();
                tns2Type.put(ns, types);
            }
            types.add(type);
        }
        for (Map.Entry entry : tns2Type.entrySet()) {
            Element e = new Element("schema", "xsd", "http://www.w3.org/2001/XMLSchema");
            e.setAttribute(new Attribute("targetNamespace", (String)entry.getKey()));
            e.setAttribute(new Attribute("elementFormDefault", "qualified"));
            e.setAttribute(new Attribute("attributeFormDefault", "qualified"));
            for (Type t : (Set)entry.getValue()) {
                t.writeSchema(e);
            }
            if (e.getChildren().size() == 0) continue;
            try {
                XmlSchemaCollection col = new XmlSchemaCollection();
                NamespaceMap nsMap = new NamespaceMap();
                nsMap.add("xsd", "http://www.w3.org/2001/XMLSchema");
                for (Namespace n : e.getAdditionalNamespaces()) {
                    nsMap.add(n.getPrefix(), n.getURI());
                }
                col.setNamespaceContext((NamespacePrefixList)nsMap);
                org.w3c.dom.Document schema = new DOMOutputter().output(new Document(e));
                for (ServiceInfo si : s.getServiceInfos()) {
                    SchemaInfo info = new SchemaInfo(si, (String)entry.getKey());
                    info.setElement(schema.getDocumentElement());
                    XmlSchema xmlSchema = col.read(schema.getDocumentElement());
                    info.setSchema(xmlSchema);
                    info.setSystemId((String)entry.getKey());
                    si.addSchema(info);
                }
            }
            catch (JDOMException e1) {
                throw new ServiceConstructionException(e1);
            }
        }
    }

    public QName getSuggestedName(Service s, TypeMapping tm, OperationInfo op, int param) {
        Type type;
        Method m = this.getMethod(s, op);
        if (m == null) {
            return null;
        }
        QName name = tm.getTypeCreator().getElementName(m, param);
        if (name == null && (type = tm.getTypeCreator().createType(m, param)).isComplex() && !type.isAbstract()) {
            name = type.getSchemaType();
        }
        return name;
    }

    private Type getParameterType(Service s, TypeMapping tm, MessagePartInfo param, int paramtype) {
        Type type = tm.getType(param.getTypeQName());
        if (type == null) {
            OperationInfo op = param.getMessageInfo().getOperation();
            Method m = this.getMethod(s, op);
            type = paramtype != 2 && m != null ? tm.getTypeCreator().createType(m, param.getIndex()) : tm.getTypeCreator().createType(param.getTypeClass());
            type.setTypeMapping(tm);
            this.part2Type.put(param, type);
        }
        return type;
    }

    private Method getMethod(Service s, OperationInfo op) {
        MethodDispatcher md = (MethodDispatcher)s.get(MethodDispatcher.class.getName());
        SimpleMethodDispatcher smd = (SimpleMethodDispatcher)md;
        return smd.getPrimaryMethod(op);
    }

    public Type getType(MessagePartInfo part) {
        return this.part2Type.get(part);
    }

    public List getOverrideTypes() {
        return this.overrideTypes;
    }

    public Service getService() {
        return this.service;
    }
}

