/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.databinding;

import java.util.Collection;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.validation.Schema;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.xml.stax.ElementReader;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.service.model.MessagePartInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStreamDataReader
implements DataReader<XMLStreamReader> {
    private static final Logger LOG = Logger.getLogger(XMLStreamDataReader.class.getName());
    private AegisDatabinding databinding;
    private Context context = new Context();

    public XMLStreamDataReader(AegisDatabinding databinding) {
        this.databinding = databinding;
    }

    @Override
    public Object read(MessagePartInfo part, XMLStreamReader input) {
        ElementReader elReader;
        Type type = this.databinding.getType(part);
        if ((type = TypeUtil.getReadType(input, this.context, type)) == null) {
            throw new Fault(new Message("NO_MESSAGE_FOR_PART", LOG, new Object[0]));
        }
        this.context.setTypeMapping(type.getTypeMapping());
        this.context.setOverrideTypes(CastUtils.cast(this.databinding.getOverrideTypes(), String.class));
        Object val = this.databinding.getService().get("readXsiType");
        if ("false".equals(val) || Boolean.FALSE.equals(val)) {
            this.context.setReadXsiTypes(false);
        }
        if ((elReader = new ElementReader(input)).isXsiNil()) {
            elReader.readToEnd();
            return null;
        }
        try {
            return type.readObject(elReader, this.context);
        }
        catch (DatabindingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object read(QName name, XMLStreamReader input, Class type) {
        return null;
    }

    @Override
    public Object read(XMLStreamReader input) {
        return null;
    }

    @Override
    public void setAttachments(Collection<Attachment> attachments) {
        this.context.setAttachments(attachments);
    }

    @Override
    public void setProperty(String prop, Object value) {
    }

    @Override
    public void setSchema(Schema s) {
    }
}

