/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.annotation.AnnotationVisitor;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessor {
    private static final Logger LOG = LogUtils.getL7dLogger(AnnotationProcessor.class);
    private static Method visitClassMethod;
    private static Method visitFieldMethod;
    private static Method visitMethodMethod;
    private final Object target;
    private List<Class<? extends Annotation>> annotationTypes;

    public AnnotationProcessor(Object o) {
        if (o == null) {
            throw new IllegalArgumentException(new Message("INVALID_CTOR_ARGS", LOG, new Object[0]).toString());
        }
        this.target = o;
    }

    public void accept(AnnotationVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException();
        }
        this.annotationTypes = visitor.getTargetAnnotations();
        visitor.setTarget(this.target);
        this.processClass(visitor, this.target.getClass());
        this.processFields(visitor, this.target.getClass());
        this.processMethods(visitor, this.target.getClass());
    }

    private void processMethods(AnnotationVisitor visitor, Class<? extends Object> targetClass) {
        if (targetClass.getSuperclass() != null) {
            this.processMethods(visitor, targetClass.getSuperclass());
        }
        this.visitAnnotatedElement(targetClass.getDeclaredMethods(), visitor, visitMethodMethod);
    }

    private void processFields(AnnotationVisitor visitor, Class<? extends Object> targetClass) {
        if (targetClass.getSuperclass() != null) {
            this.processFields(visitor, targetClass.getSuperclass());
        }
        this.visitAnnotatedElement(targetClass.getDeclaredFields(), visitor, visitFieldMethod);
    }

    private void processClass(AnnotationVisitor visitor, Class<? extends Object> targetClass) {
        if (targetClass.getSuperclass() != null) {
            this.processClass(visitor, targetClass.getSuperclass());
        }
        AnnotatedElement[] classes = new Class[]{targetClass};
        this.visitAnnotatedElement(classes, visitor, visitClassMethod);
    }

    private <U extends AnnotatedElement> void visitAnnotatedElement(U[] elements, AnnotationVisitor visitor, Method visitorMethod) {
        for (U element : elements) {
            for (Class<? extends Annotation> clz : this.annotationTypes) {
                Annotation ann = element.getAnnotation(clz);
                if (ann == null) continue;
                try {
                    visitorMethod.invoke((Object)visitor, element, ann);
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause() == null ? e : e.getCause();
                    LogUtils.log(LOG, Level.SEVERE, "VISITOR_RAISED_EXCEPTION", cause, visitor, element);
                }
            }
        }
    }

    static {
        try {
            visitClassMethod = AnnotationVisitor.class.getMethod("visitClass", Class.class, Annotation.class);
            visitFieldMethod = AnnotationVisitor.class.getMethod("visitField", Field.class, Annotation.class);
            visitMethodMethod = AnnotationVisitor.class.getMethod("visitMethod", Method.class, Annotation.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

