/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.databinding.source;

import java.io.IOException;
import java.util.Collection;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStreamDataReader
implements DataReader<XMLStreamReader> {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLStreamDataReader.class);

    @Override
    public Object read(MessagePartInfo part, XMLStreamReader input) {
        return this.read((QName)null, input, (Class)part.getTypeClass());
    }

    @Override
    public Object read(QName name, XMLStreamReader input, Class type) {
        if (SAXSource.class.isAssignableFrom(type)) {
            try {
                CachedOutputStream out = new CachedOutputStream();
                XMLStreamWriter xsw = StaxUtils.createXMLStreamWriter(out);
                StaxUtils.copy(input, xsw);
                xsw.close();
                out.close();
                return new SAXSource(new InputSource(out.getInputStream()));
            }
            catch (IOException e) {
                throw new Fault(new Message("COULD_NOT_READ_XML_STREAM", LOG, new Object[0]), (Throwable)e);
            }
            catch (XMLStreamException e) {
                throw new Fault(new Message("COULD_NOT_READ_XML_STREAM", LOG, new Object[0]), (Throwable)e);
            }
        }
        if (StreamSource.class.isAssignableFrom(type)) {
            try {
                CachedOutputStream out = new CachedOutputStream();
                XMLStreamWriter xsw = StaxUtils.createXMLStreamWriter(out);
                StaxUtils.copy(input, xsw);
                xsw.close();
                out.close();
                return new StreamSource(out.getInputStream());
            }
            catch (IOException e) {
                throw new Fault(new Message("COULD_NOT_READ_XML_STREAM", LOG, new Object[0]), (Throwable)e);
            }
            catch (XMLStreamException e) {
                throw new Fault(new Message("COULD_NOT_READ_XML_STREAM", LOG, new Object[0]), (Throwable)e);
            }
        }
        return this.read(input);
    }

    @Override
    public Object read(XMLStreamReader reader) {
        try {
            Document document = StaxUtils.read(reader);
            return new DOMSource(document);
        }
        catch (XMLStreamException e) {
            throw new Fault(new Message("COULD_NOT_READ_XML_STREAM", LOG, new Object[0]), (Throwable)e);
        }
    }

    @Override
    public void setSchema(Schema s) {
    }

    @Override
    public void setAttachments(Collection<Attachment> attachments) {
    }

    @Override
    public void setProperty(String prop, Object value) {
    }
}

