/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceInvokerInterceptor
extends AbstractPhaseInterceptor<Message> {
    public ServiceInvokerInterceptor() {
        super("invoke");
    }

    @Override
    public void handleMessage(final Message message) {
        final Exchange exchange = message.getExchange();
        Endpoint endpoint = exchange.get(Endpoint.class);
        Service service = endpoint.getService();
        final Invoker invoker = service.getInvoker();
        Runnable invocation = new Runnable(){

            public void run() {
                Exchange runableEx = message.getExchange();
                List<Object> result = invoker.invoke(runableEx, ServiceInvokerInterceptor.this.getInvokee(message));
                if (!exchange.isOneWay()) {
                    Endpoint ep = exchange.get(Endpoint.class);
                    Message outMessage = runableEx.getOutMessage();
                    if (outMessage == null) {
                        outMessage = ep.getBinding().createMessage();
                        exchange.setOutMessage(outMessage);
                    }
                    ServiceInvokerInterceptor.this.copyJaxwsProperties(message, outMessage);
                    if (result != null) {
                        if (result instanceof List) {
                            outMessage.setContent(List.class, result);
                        } else if (result.getClass().isArray()) {
                            result = Arrays.asList((Object[])result);
                            outMessage.setContent(List.class, result);
                        } else {
                            outMessage.setContent(Object.class, result);
                        }
                    }
                }
            }
        };
        Executor executor = this.getExecutor(endpoint);
        if (exchange.get(Executor.class) == executor) {
            invocation.run();
        } else {
            exchange.put(Executor.class, executor);
            executor.execute(invocation);
        }
    }

    private Object getInvokee(Message message) {
        Object invokee = message.getContent(List.class);
        if (invokee == null) {
            invokee = message.getContent(Object.class);
        }
        return invokee;
    }

    private Executor getExecutor(Endpoint endpoint) {
        return endpoint.getService().getExecutor();
    }

    private void copyJaxwsProperties(Message inMsg, Message outMsg) {
        outMsg.put("javax.xml.ws.wsdl.operation", inMsg.get("javax.xml.ws.wsdl.operation"));
        outMsg.put("javax.xml.ws.wsdl.service", inMsg.get("javax.xml.ws.wsdl.service"));
        outMsg.put("javax.xml.ws.wsdl.interface", inMsg.get("javax.xml.ws.wsdl.interface"));
        outMsg.put("javax.xml.ws.wsdl.port", inMsg.get("javax.xml.ws.wsdl.port"));
        outMsg.put("javax.xml.ws.wsdl.description", inMsg.get("javax.xml.ws.wsdl.description"));
    }
}

