/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrappedMessageContext
implements MessageContext {
    public static final String SCOPES = WrappedMessageContext.class.getName() + ".SCOPES";
    private final Map<String, Object> contextMap;
    private final Message message;
    private Map<String, MessageContext.Scope> scopes;
    private MessageContext.Scope defaultScope;

    public WrappedMessageContext(Message m) {
        this(m, m, MessageContext.Scope.HANDLER);
    }

    public WrappedMessageContext(Message m, MessageContext.Scope defScope) {
        this(m, m, defScope);
    }

    public WrappedMessageContext(Map<String, Object> m, MessageContext.Scope defScope) {
        this(null, m, defScope);
    }

    public WrappedMessageContext(Message m, Map<String, Object> map, MessageContext.Scope defScope) {
        this.message = m;
        this.contextMap = map;
        this.defaultScope = defScope;
        this.scopes = CastUtils.cast((Map)this.contextMap.get(SCOPES));
        if (this.scopes == null && this.message != null && this.message.getExchange() != null) {
            if (this.isRequestor() && !this.isOutbound() && m.getExchange().getOutMessage() != null) {
                this.scopes = CastUtils.cast((Map)m.getExchange().getOutMessage().get(SCOPES));
                this.copyScopedProperties(m.getExchange().getOutMessage());
                m.put(SCOPES, this.scopes);
            } else if (!this.isRequestor() && this.isOutbound() && m.getExchange().getInMessage() != null) {
                this.scopes = CastUtils.cast((Map)m.getExchange().getInMessage().get(SCOPES));
                this.copyScopedProperties(m.getExchange().getInMessage());
                m.put(SCOPES, this.scopes);
            }
        }
        if (this.scopes == null) {
            this.scopes = new HashMap<String, MessageContext.Scope>();
            this.contextMap.put(SCOPES, this.scopes);
        }
    }

    protected final void copyScopedProperties(Message m) {
        for (String k : this.scopes.keySet()) {
            if (this.contextMap.containsKey(k) || "javax.xml.ws.handler.message.outbound".equals(k)) continue;
            this.contextMap.put(k, m.get(k));
        }
    }

    protected final boolean isRequestor() {
        return Boolean.TRUE.equals(this.contextMap.containsKey("org.apache.cxf.client"));
    }

    protected final boolean isOutbound() {
        Exchange ex = this.message.getExchange();
        return this.message != null && (this.message == ex.getOutMessage() || this.message == ex.getOutFaultMessage());
    }

    public final Message getWrappedMessage() {
        return this.message;
    }

    public void clear() {
        this.contextMap.clear();
    }

    public final boolean containsKey(Object key) {
        return this.contextMap.containsKey(key);
    }

    public final boolean containsValue(Object value) {
        return this.contextMap.containsValue(value);
    }

    public final Set<Map.Entry<String, Object>> entrySet() {
        return this.contextMap.entrySet();
    }

    public final Object get(Object key) {
        return this.contextMap.get(key);
    }

    public final boolean isEmpty() {
        return this.contextMap.isEmpty();
    }

    public final Set<String> keySet() {
        return this.contextMap.keySet();
    }

    public final Object put(String key, Object value) {
        if (!"javax.xml.ws.handler.message.outbound".equals(key) && !this.scopes.containsKey(key)) {
            this.scopes.put(key, this.defaultScope);
        }
        return this.contextMap.put(key, value);
    }

    public final Object put(String key, Object value, MessageContext.Scope scope) {
        if (!"javax.xml.ws.handler.message.outbound".equals(key)) {
            this.scopes.put(key, scope);
        }
        return this.contextMap.put(key, value);
    }

    public final void putAll(Map<? extends String, ? extends Object> t) {
        for (Map.Entry<? extends String, ? extends Object> s : t.entrySet()) {
            this.put(s.getKey(), s.getValue());
        }
    }

    public final Object remove(Object key) {
        this.scopes.remove(key);
        return this.contextMap.remove(key);
    }

    public final int size() {
        return this.contextMap.size();
    }

    public final Collection<Object> values() {
        return this.contextMap.values();
    }

    public final void setScope(String key, MessageContext.Scope arg1) {
        if (!this.containsKey(key)) {
            throw new IllegalArgumentException("non-existant property-" + key + "is specified");
        }
        this.scopes.put(key, arg1);
    }

    public final MessageContext.Scope getScope(String key) {
        if (this.containsKey(key)) {
            if (this.scopes.containsKey(key)) {
                return this.scopes.get(key);
            }
            return this.defaultScope;
        }
        throw new IllegalArgumentException("non-existant property-" + key + "is specified");
    }

    public final Map<String, MessageContext.Scope> getScopes() {
        return this.scopes;
    }
}

