/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.common.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaAnnotation {
    private static final String DEFAULT_QUOTE = "\"";
    private String tagName;
    private final Map<String, String> arguments = new HashMap<String, String>();

    public JavaAnnotation() {
    }

    public JavaAnnotation(String tn) {
        this.tagName = tn;
    }

    public void addArgument(String key, String value, String quote) {
        if (!StringUtils.isEmpty(value)) {
            this.arguments.put(key, quote + value + quote);
        }
    }

    public void addArgIgnoreEmtpy(String key, String value, String quote) {
        if (value != null) {
            this.arguments.put(key, quote + value + quote);
        }
    }

    public void addArgument(String key, String value) {
        this.addArgument(key, value, DEFAULT_QUOTE);
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("@");
        sb.append(this.tagName);
        Object[] keys = this.arguments.keySet().toArray();
        if (keys.length > 0) {
            sb.append("(");
            for (int i = 0; i < keys.length; ++i) {
                sb.append((String)keys[i]);
                String value = this.arguments.get((String)keys[i]);
                if ("null".equals(value)) continue;
                sb.append(" = ");
                if ("".equals(value)) {
                    sb.append("\"\"");
                } else {
                    sb.append(value);
                }
                if (i == keys.length - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        return sb.toString();
    }
}

