/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport;

import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseChainCache;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.transport.MessageObserver;

public class ChainInitiationObserver
implements MessageObserver {
    protected Endpoint endpoint;
    protected Bus bus;
    private PhaseChainCache chainCache = new PhaseChainCache();

    public ChainInitiationObserver(Endpoint endpoint, Bus bus) {
        this.endpoint = endpoint;
        this.bus = bus;
    }

    public void onMessage(Message m) {
        Message message = this.getBinding().createMessage(m);
        Exchange exchange = message.getExchange();
        if (exchange == null) {
            exchange = new ExchangeImpl();
            exchange.setInMessage(message);
        }
        this.setExchangeProperties(exchange, message);
        PhaseInterceptorChain chain = this.chainCache.get(this.bus.getExtension(PhaseManager.class).getInPhases(), this.bus.getInInterceptors(), this.endpoint.getInInterceptors(), this.getBinding().getInInterceptors(), this.endpoint.getService().getInInterceptors());
        message.setInterceptorChain(chain);
        chain.setFaultObserver(this.endpoint.getOutFaultObserver());
        chain.doIntercept(message);
    }

    protected Binding getBinding() {
        return this.endpoint.getBinding();
    }

    protected void setExchangeProperties(Exchange exchange, Message m) {
        exchange.put(Endpoint.class, this.endpoint);
        exchange.put(Service.class, this.endpoint.getService());
        exchange.put(Binding.class, this.getBinding());
        exchange.put(Bus.class, this.bus);
        if (exchange.getDestination() == null) {
            exchange.setDestination(m.getDestination());
        }
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }
}

