/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty;

import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.transport.HttpUriMapper;
import org.apache.cxf.transport.http_jetty.JettyConnectorFactory;
import org.apache.cxf.transport.http_jetty.JettyHTTPHandler;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.http_jetty.ServerEngine;
import org.apache.cxf.transport.http_jetty.ThreadingParameters;
import org.apache.cxf.transport.https_jetty.JettySslConnectorFactory;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.thread.BoundedThreadPool;

public class JettyHTTPServerEngine
implements ServerEngine {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogUtils.getL7dLogger(JettyHTTPServerEngine.class);
    private final Bus bus;
    private final JettyHTTPServerEngineFactory factory;
    private final int port;
    private String protocol;
    private int servantCount;
    private Server server;
    private AbstractConnector connector;
    private JettyConnectorFactory connectorFactory;
    private ContextHandlerCollection contexts;
    private TLSServerParameters tlsProgrammaticServerParameters;
    private ThreadingParameters threadingParameters;
    private boolean configFinalized;

    JettyHTTPServerEngine(JettyHTTPServerEngineFactory fac, Bus bus, int port) {
        this.bus = bus;
        this.factory = fac;
        this.port = port;
    }

    public Bus getBus() {
        return this.bus;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getPort() {
        return this.port;
    }

    public void shutdown() {
        this.factory.destroyForPort(this.port);
    }

    public synchronized void addServant(URL url, JettyHTTPHandler handler) {
        if (this.server == null) {
            this.server = new Server();
            this.connector = this.connectorFactory.createConnector(this.port);
            this.server.addConnector((Connector)this.connector);
            this.contexts = new ContextHandlerCollection();
            this.server.addHandler((Handler)this.contexts);
            try {
                this.server.start();
                if (this.connector.getThreadPool() instanceof BoundedThreadPool && this.isSetThreadingParameters()) {
                    BoundedThreadPool pool = (BoundedThreadPool)this.connector.getThreadPool();
                    if (this.getThreadingParameters().isSetMinThreads()) {
                        pool.setMinThreads(this.getThreadingParameters().getMinThreads());
                    }
                    if (this.getThreadingParameters().isSetMaxThreads()) {
                        pool.setMaxThreads(this.getThreadingParameters().getMaxThreads());
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
                try {
                    this.server.stop();
                    this.server.destroy();
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
        String contextName = HttpUriMapper.getContextName(url.getPath());
        String smap = HttpUriMapper.getResourceBase(url.getPath());
        ContextHandler context = new ContextHandler();
        context.setContextPath(contextName);
        context.setHandler((Handler)handler);
        this.contexts.addHandler((Handler)context);
        if (this.contexts.isStarted()) {
            try {
                context.start();
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        handler.setName(smap);
        ++this.servantCount;
    }

    public synchronized void removeServant(URL url) {
        String contextName = HttpUriMapper.getContextName(url.getPath());
        boolean found = false;
        if (this.server != null) {
            for (Handler handler : this.contexts.getChildHandlersByClass(ContextHandler.class)) {
                ContextHandler contextHandler = null;
                if (!(handler instanceof ContextHandler)) continue;
                contextHandler = (ContextHandler)handler;
                if (contextName.equals(contextHandler.getContextPath())) {
                    try {
                        this.contexts.removeHandler(handler);
                        handler.stop();
                        handler.destroy();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                found = true;
            }
        }
        if (!found) {
            LOG.warning("Not able to remove the handler");
        }
        --this.servantCount;
    }

    public synchronized Handler getServant(URL url) {
        String contextName = HttpUriMapper.getContextName(url.getPath());
        Handler ret = null;
        if (this.server != null) {
            for (Handler handler : this.server.getChildHandlersByClass(ContextHandler.class)) {
                ContextHandler contextHandler = null;
                if (!(handler instanceof ContextHandler) || !contextName.equals((contextHandler = (ContextHandler)handler).getContextPath())) continue;
                ret = contextHandler.getHandler();
                break;
            }
        }
        return ret;
    }

    protected void retrieveListenerFactory() {
        if (this.tlsProgrammaticServerParameters != null) {
            this.connectorFactory = this.getHTTPSConnectorFactory(this.tlsProgrammaticServerParameters);
            this.protocol = "https";
        } else {
            this.connectorFactory = this.getHTTPConnectorFactory();
            this.protocol = "http";
        }
        LOG.fine("Configured port " + this.port + " for \"" + this.protocol + "\".");
    }

    protected JettyConnectorFactory getHTTPConnectorFactory() {
        return new JettyConnectorFactory(){

            public AbstractConnector createConnector(int porto) {
                SelectChannelConnector result = new SelectChannelConnector();
                assert (porto == JettyHTTPServerEngine.this.port);
                result.setPort(porto);
                return result;
            }
        };
    }

    protected JettyConnectorFactory getHTTPSConnectorFactory(TLSServerParameters tlsParams) {
        return new JettySslConnectorFactory(tlsParams);
    }

    protected void finalizeConfig() throws GeneralSecurityException, IOException {
        this.retrieveListenerFactory();
        this.configFinalized = true;
    }

    protected void stop() throws Exception {
        if (this.server != null) {
            this.connector.close();
            this.server.stop();
            this.server.destroy();
            this.server = null;
        }
    }

    protected void setProgrammaticTlsServerParameters(TLSServerParameters params) {
        this.tlsProgrammaticServerParameters = params;
        if (this.configFinalized) {
            this.retrieveListenerFactory();
        }
    }

    protected TLSServerParameters getProgrammaticTlsServerParameters() {
        return this.tlsProgrammaticServerParameters;
    }

    public void setThreadingParameters(ThreadingParameters params) {
        this.threadingParameters = params;
    }

    public boolean isSetThreadingParameters() {
        return this.threadingParameters != null;
    }

    public ThreadingParameters getThreadingParameters() {
        return this.threadingParameters;
    }
}

