/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import com.sun.xml.bind.v2.ContextFactory;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.CacheMap;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.databinding.source.AbstractDataBinding;
import org.apache.cxf.jaxb.JAXBContextInitializer;
import org.apache.cxf.jaxb.JAXBSchemaInitializer;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.jaxb.io.DataReaderImpl;
import org.apache.cxf.jaxb.io.DataWriterImpl;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.ws.addressing.ObjectFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXBDataBinding
extends AbstractDataBinding
implements DataBinding {
    public static final String SCHEMA_RESOURCE = "SCHEMRESOURCE";
    public static final String UNWRAP_JAXB_ELEMENT = "unwrap.jaxb.element";
    private static final Logger LOG = LogUtils.getLogger(JAXBDataBinding.class);
    private static final Class<?>[] SUPPORTED_READER_FORMATS = new Class[]{Node.class, XMLEventReader.class, XMLStreamReader.class};
    private static final Class<?>[] SUPPORTED_WRITER_FORMATS = new Class[]{OutputStream.class, Node.class, XMLEventWriter.class, XMLStreamWriter.class};
    private static final Map<Set<Class<?>>, JAXBContext> JAXBCONTEXT_CACHE = new CacheMap();
    Class[] extraClass;
    JAXBContext context;
    Set<Class<?>> contextClasses;
    Class<?> cls;
    private Map<String, Object> contextProperties = Collections.emptyMap();
    private Map<String, Object> marshallerProperties = Collections.emptyMap();

    public JAXBDataBinding() {
    }

    public JAXBDataBinding(Class<?> ... classes) throws JAXBException {
        this.contextClasses = new HashSet();
        this.contextClasses.addAll(Arrays.asList(classes));
        this.setContext(this.createJAXBContext(this.contextClasses));
    }

    public JAXBDataBinding(JAXBContext context) {
        this();
        this.setContext(context);
    }

    public JAXBContext getContext() {
        return this.context;
    }

    public void setContext(JAXBContext ctx) {
        this.context = ctx;
    }

    private NamespacePrefixMapper getNamespacePrefixMapper() {
        Map mappings = this.getDeclaredNamespaceMappings();
        if (mappings == null) {
            mappings = Collections.emptyMap();
        }
        final Map closedMappings = mappings;
        NamespacePrefixMapper mapper = new NamespacePrefixMapper(){

            public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
                String prefix = (String)closedMappings.get(namespaceUri);
                if (prefix != null) {
                    return prefix;
                }
                return suggestion;
            }
        };
        return mapper;
    }

    public <T> DataWriter<T> createWriter(Class<T> c) {
        HashMap<String, Object> currentMarshallerProperties = new HashMap<String, Object>();
        if (!this.marshallerProperties.containsKey("com.sun.xml.bind.namespacePrefixMapper")) {
            currentMarshallerProperties.put("com.sun.xml.bind.namespacePrefixMapper", this.getNamespacePrefixMapper());
        }
        currentMarshallerProperties.putAll(this.marshallerProperties);
        if (c == XMLStreamWriter.class) {
            return new DataWriterImpl(this.context, currentMarshallerProperties);
        }
        if (c == OutputStream.class) {
            return new DataWriterImpl(this.context, currentMarshallerProperties);
        }
        if (c == XMLEventWriter.class) {
            return new DataWriterImpl(this.context, currentMarshallerProperties);
        }
        if (c == Node.class) {
            return new DataWriterImpl(this.context, currentMarshallerProperties);
        }
        return null;
    }

    public Class<?>[] getSupportedWriterFormats() {
        return SUPPORTED_WRITER_FORMATS;
    }

    public <T> DataReader<T> createReader(Class<T> c) {
        DataReaderImpl dr = null;
        if (c == XMLStreamReader.class) {
            dr = new DataReaderImpl(this.context);
        } else if (c == XMLEventReader.class) {
            dr = new DataReaderImpl(this.context);
        } else if (c == Node.class) {
            dr = new DataReaderImpl(this.context);
        }
        return dr;
    }

    public Class<?>[] getSupportedReaderFormats() {
        return SUPPORTED_READER_FORMATS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Service service) {
        JAXBContext ctx;
        block23: {
            if (this.context != null) {
                return;
            }
            this.contextClasses = new HashSet();
            for (ServiceInfo serviceInfo : service.getServiceInfos()) {
                JAXBContextInitializer initializer = new JAXBContextInitializer(serviceInfo, this.contextClasses);
                initializer.walk();
            }
            String tns = service.getName().getNamespaceURI();
            ctx = null;
            try {
                if (service.getServiceInfos().size() > 0) {
                    tns = ((ServiceInfo)service.getServiceInfos().get(0)).getInterface().getName().getNamespaceURI();
                }
                ctx = this.createJAXBContext(this.contextClasses, tns);
            }
            catch (JAXBException e1) {
                boolean added = this.addJaxbObjectFactory(e1);
                while (ctx == null && added) {
                    try {
                        Map<Set<Class<?>>, JAXBContext> map = JAXBCONTEXT_CACHE;
                        synchronized (map) {
                            ctx = JAXBContext.newInstance((Class[])this.contextClasses.toArray(new Class[this.contextClasses.size()]), null);
                            JAXBCONTEXT_CACHE.put(this.contextClasses, ctx);
                        }
                    }
                    catch (JAXBException e) {
                        e1 = e;
                        added = this.addJaxbObjectFactory(e1);
                    }
                }
                if (ctx != null) break block23;
                throw new ServiceConstructionException((Throwable)e1);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "CREATED_JAXB_CONTEXT", new Object[]{ctx, this.contextClasses});
        }
        this.setContext(ctx);
        for (ServiceInfo serviceInfo : service.getServiceInfos()) {
            JAXBContextImpl riContext;
            SchemaCollection col = serviceInfo.getXmlSchemaCollection();
            if (col.getXmlSchemas().length > 1) continue;
            Collection schemas = this.getSchemas();
            if (schemas != null) {
                for (DOMSource dOMSource : schemas) {
                    this.addSchemaDocument(serviceInfo, col, (Document)dOMSource.getNode(), dOMSource.getSystemId());
                }
            } else {
                try {
                    for (DOMResult dOMResult : this.generateJaxbSchemas()) {
                        this.addSchemaDocument(serviceInfo, col, (Document)dOMResult.getNode(), dOMResult.getSystemId());
                    }
                }
                catch (IOException e) {
                    throw new ServiceConstructionException(new Message("SCHEMA_GEN_EXC", LOG, new Object[0]), (Throwable)e);
                }
            }
            if (this.context instanceof JAXBContextImpl) {
                riContext = (JAXBContextImpl)this.context;
            } else {
                try {
                    riContext = (JAXBContextImpl)ContextFactory.createContext((Class[])this.contextClasses.toArray(new Class[this.contextClasses.size()]), null);
                }
                catch (JAXBException jAXBException) {
                    throw new ServiceConstructionException((Throwable)jAXBException);
                }
            }
            JAXBSchemaInitializer jAXBSchemaInitializer = new JAXBSchemaInitializer(serviceInfo, col, riContext);
            jAXBSchemaInitializer.walk();
        }
    }

    public void setExtraClass(Class[] userExtraClass) {
        this.extraClass = userExtraClass;
    }

    public Class[] getExtraClass() {
        return this.extraClass;
    }

    private List<DOMResult> generateJaxbSchemas() throws IOException {
        final ArrayList<DOMResult> results = new ArrayList<DOMResult>();
        this.context.generateSchema(new SchemaOutputResolver(){

            public Result createOutput(String ns, String file) throws IOException {
                DOMResult result = new DOMResult();
                result.setSystemId(file);
                if ("http://www.w3.org/2005/02/addressing/wsdl".equals(ns)) {
                    return result;
                }
                results.add(result);
                return result;
            }
        });
        return results;
    }

    public JAXBContext createJAXBContext(Set<Class<?>> classes) throws JAXBException {
        return this.createJAXBContext(classes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext createJAXBContext(Set<Class<?>> classes, String defaultNs) throws JAXBException {
        Iterator<Class<?>> it = classes.iterator();
        String className = "";
        Class<?> remoteExceptionObject = null;
        while (it.hasNext()) {
            remoteExceptionObject = it.next();
            className = ((Object)remoteExceptionObject).toString();
            if ("".equals(className) || !className.contains("RemoteException")) continue;
            it.remove();
        }
        if (this.extraClass != null && this.extraClass.length > 0) {
            for (Class clz : this.extraClass) {
                classes.add(clz);
            }
        }
        for (Class<?> clz : classes) {
            if (!clz.getName().endsWith("ObjectFactory")) continue;
            defaultNs = null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (defaultNs != null) {
            map.put("com.sun.xml.bind.defaultNamespaceRemap", defaultNs);
        }
        if (this.contextProperties != null) {
            map.putAll(this.contextProperties);
        }
        HashMap<String, InputStream> packages = new HashMap<String, InputStream>();
        HashMap<String, ClassLoader> packageLoaders = new HashMap<String, ClassLoader>();
        for (Class<?> clazz : classes) {
            if (packages.containsKey(PackageUtils.getPackageName(clazz))) continue;
            packages.put(PackageUtils.getPackageName(clazz), clazz.getResourceAsStream("jaxb.index"));
            packageLoaders.put(PackageUtils.getPackageName(clazz), clazz.getClassLoader());
        }
        for (Map.Entry entry : packages.entrySet()) {
            if (entry.getValue() == null) continue;
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)entry.getValue(), "UTF-8"));
                String pkg = (String)entry.getKey();
                ClassLoader loader = (ClassLoader)packageLoaders.get(pkg);
                if (!StringUtils.isEmpty((String)pkg)) {
                    pkg = pkg + ".";
                }
                String line = reader.readLine();
                while (line != null) {
                    if ((line = line.trim()).indexOf("#") != -1) {
                        line = line.substring(0, line.indexOf("#"));
                    }
                    if (!StringUtils.isEmpty((String)line)) {
                        try {
                            Class<?> ncls = Class.forName(pkg + line, false, loader);
                            classes.add(ncls);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception e) {}
            continue;
            finally {
                try {
                    ((InputStream)entry.getValue()).close();
                }
                catch (Exception e) {}
            }
        }
        this.addWsAddressingTypes(classes);
        Map<Set<Class<?>>, JAXBContext> map2 = JAXBCONTEXT_CACHE;
        synchronized (map2) {
            if (!JAXBCONTEXT_CACHE.containsKey(classes)) {
                JAXBContext jAXBContext = JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()]), map);
                JAXBCONTEXT_CACHE.put(classes, jAXBContext);
            }
        }
        return JAXBCONTEXT_CACHE.get(classes);
    }

    private void addWsAddressingTypes(Set<Class<?>> classes) {
        if (classes.contains(ObjectFactory.class)) {
            try {
                classes.add(Class.forName("org.apache.cxf.ws.addressing.wsdl.ObjectFactory"));
                classes.add(Class.forName("org.apache.cxf.ws.addressing.wsdl.AttributedQNameType"));
                classes.add(Class.forName("org.apache.cxf.ws.addressing.wsdl.ServiceNameType"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public boolean addJaxbObjectFactory(JAXBException e1) {
        boolean added = false;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream pout = new PrintStream(bout);
        e1.printStackTrace(pout);
        String str = new String(bout.toByteArray());
        Pattern pattern = Pattern.compile("(?<=There's\\sno\\sObjectFactory\\swith\\san\\s@XmlElementDecl\\sfor\\sthe\\selement\\s\\{)\\S*(?=\\})");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            String pkgName = JAXBUtils.namespaceURIToPackage((String)matcher.group());
            try {
                Class<?> clz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(pkgName + "." + "ObjectFactory");
                if (this.contextClasses.contains(clz)) continue;
                this.contextClasses.add(clz);
                added = true;
            }
            catch (ClassNotFoundException e) {}
        }
        return added;
    }

    public Map<String, Object> getContextProperties() {
        return this.contextProperties;
    }

    public void setContextProperties(Map<String, Object> contextProperties) {
        this.contextProperties = contextProperties;
    }
}

