/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.apache.cxf.transport.http_jetty.ThreadingParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyHTTPServerEngineFactory
implements BusLifeCycleListener {
    private static final Logger LOG = LogUtils.getL7dLogger(JettyHTTPServerEngineFactory.class);
    private static Map<Integer, JettyHTTPServerEngine> portMap = new HashMap<Integer, JettyHTTPServerEngine>();
    private BusLifeCycleManager lifeCycleManager;
    private Map<String, ThreadingParameters> threadingParametersMap = new TreeMap<String, ThreadingParameters>();
    private Map<String, TLSServerParameters> tlsParametersMap = new TreeMap<String, TLSServerParameters>();
    private Bus bus;

    @Resource(name="bus")
    public void setBus(Bus bus) {
        assert (this.bus == null);
        this.bus = bus;
    }

    @PostConstruct
    public void registerWithBus() {
        if (this.bus != null) {
            this.bus.setExtension((Object)this, JettyHTTPServerEngineFactory.class);
        }
        this.lifeCycleManager = (BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class);
        if (null != this.lifeCycleManager) {
            this.lifeCycleManager.registerLifeCycleListener((BusLifeCycleListener)this);
        }
    }

    public void setTlsServerParametersMap(Map<String, TLSServerParameters> tlsParamsMap) {
        this.tlsParametersMap = tlsParamsMap;
    }

    public Map<String, TLSServerParameters> getTlsServerParametersMap() {
        return this.tlsParametersMap;
    }

    public void setEnginesList(List<JettyHTTPServerEngine> enginesList) {
        for (JettyHTTPServerEngine engine : enginesList) {
            portMap.put(engine.getPort(), engine);
        }
    }

    public void setThreadingParametersMap(Map<String, ThreadingParameters> threadingParamsMap) {
        this.threadingParametersMap = threadingParamsMap;
    }

    public Map<String, ThreadingParameters> getThreadingParametersMap() {
        return this.threadingParametersMap;
    }

    public void setTLSServerParametersForPort(int port, TLSServerParameters tlsParams) throws GeneralSecurityException, IOException {
        if (tlsParams == null) {
            throw new IllegalArgumentException("tlsParams cannot be null");
        }
        JettyHTTPServerEngine ref = this.retrieveJettyHTTPServerEngine(port);
        if (null == ref) {
            ref = new JettyHTTPServerEngine(this, this.bus, port);
            ref.setTlsServerParameters(tlsParams);
            portMap.put(port, ref);
            ref.finalizeConfig();
        } else {
            if (ref.getConnector() != null && ref.getConnector().isRunning()) {
                throw new IOException("can't set the TLS params on the opened connector");
            }
            ref.setTlsServerParameters(tlsParams);
        }
    }

    public synchronized JettyHTTPServerEngine retrieveJettyHTTPServerEngine(int port) {
        return portMap.get(port);
    }

    protected synchronized JettyHTTPServerEngine createJettyHTTPServerEngine(int port, String protocol) throws GeneralSecurityException, IOException {
        LOG.fine("Creating Jetty HTTP Server Engine for port " + port + ".");
        JettyHTTPServerEngine ref = this.retrieveJettyHTTPServerEngine(port);
        if (null == ref) {
            ref = new JettyHTTPServerEngine(this, this.bus, port);
            portMap.put(port, ref);
            ref.finalizeConfig();
        }
        if (!protocol.equals(ref.getProtocol())) {
            throw new IOException("Protocol mismatch: engine's protocol is " + ref.getProtocol() + ", the url protocol is " + protocol);
        }
        return ref;
    }

    public synchronized void destroyForPort(int port) {
        JettyHTTPServerEngine ref = portMap.remove(port);
        if (ref != null) {
            LOG.fine("Stopping Jetty HTTP Server Engine on port " + port + ".");
            try {
                ref.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @PostConstruct
    public void finalizeConfig() {
        this.registerWithBus();
    }

    public void initComplete() {
    }

    public void postShutdown() {
        JettyHTTPServerEngine[] engines;
        for (JettyHTTPServerEngine engine : engines = portMap.values().toArray(new JettyHTTPServerEngine[0])) {
            engine.shutdown();
        }
        this.threadingParametersMap.clear();
        this.tlsParametersMap.clear();
    }

    public void preShutdown() {
    }
}

