/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.AutowireUtils;
import org.springframework.beans.factory.support.BeanDefinitionValueResolver;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.MethodParameter;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

abstract class ConstructorResolver {
    private final AbstractBeanFactory beanFactory;
    private final InstantiationStrategy instantiationStrategy;

    public ConstructorResolver(AbstractBeanFactory beanFactory, InstantiationStrategy instantiationStrategy) {
        this.beanFactory = beanFactory;
        this.instantiationStrategy = instantiationStrategy;
    }

    protected BeanWrapper autowireConstructor(String beanName, RootBeanDefinition mbd, Constructor chosenCtor) {
        BeanWrapperImpl bw = new BeanWrapperImpl();
        this.beanFactory.initBeanWrapper(bw);
        Constructor constructorToUse = (Constructor)mbd.resolvedConstructorOrFactoryMethod;
        Object[] argsToUse = null;
        if (constructorToUse != null) {
            argsToUse = mbd.resolvedConstructorArguments;
            if (argsToUse == null) {
                Class<?>[] paramTypes = constructorToUse.getParameterTypes();
                Object[] argsToResolve = mbd.preparedConstructorArguments;
                BeanDefinitionValueResolver valueResolver = new BeanDefinitionValueResolver(this.beanFactory, beanName, mbd, bw);
                argsToUse = new Object[argsToResolve.length];
                for (int i = 0; i < argsToResolve.length; ++i) {
                    Object argValue = argsToResolve[i];
                    if (argValue instanceof BeanMetadataElement) {
                        String argName = "constructor argument with index " + i;
                        argValue = valueResolver.resolveValueIfNecessary(argName, argValue);
                    }
                    argsToUse[i] = bw.convertIfNecessary(argValue, paramTypes[i], new MethodParameter(constructorToUse, i));
                }
            }
        } else {
            boolean autowiring = chosenCtor != null || mbd.getResolvedAutowireMode() == 3;
            ConstructorArgumentValues cargs = mbd.getConstructorArgumentValues();
            ConstructorArgumentValues resolvedValues = new ConstructorArgumentValues();
            int minNrOfArgs = this.resolveConstructorArguments(beanName, mbd, bw, cargs, resolvedValues);
            if (chosenCtor != null) {
                Class[] paramTypes = chosenCtor.getParameterTypes();
                argsToUse = this.createArgumentArray((String)beanName, (RootBeanDefinition)mbd, (ConstructorArgumentValues)resolvedValues, (BeanWrapper)bw, (Class[])paramTypes, (Object)chosenCtor, (boolean)autowiring).arguments;
                constructorToUse = chosenCtor;
            } else {
                Constructor[] candidates = mbd.getBeanClass().getDeclaredConstructors();
                AutowireUtils.sortConstructors(candidates);
                int minTypeDiffWeight = Integer.MAX_VALUE;
                for (int i = 0; i < candidates.length; ++i) {
                    Constructor candidate = candidates[i];
                    Class[] paramTypes = candidate.getParameterTypes();
                    if (constructorToUse != null && argsToUse.length > paramTypes.length) break;
                    if (paramTypes.length < minNrOfArgs) {
                        throw new BeanCreationException(mbd.getResourceDescription(), beanName, minNrOfArgs + " constructor arguments specified but no matching constructor found in bean '" + beanName + "' " + "(hint: specify index and/or type arguments for simple parameters to avoid type ambiguities)");
                    }
                    try {
                        ArgumentsHolder args = this.createArgumentArray(beanName, mbd, resolvedValues, bw, paramTypes, candidate, autowiring);
                        int typeDiffWeight = args.getTypeDifferenceWeight(paramTypes);
                        if (typeDiffWeight >= minTypeDiffWeight) continue;
                        constructorToUse = candidate;
                        argsToUse = args.arguments;
                        minTypeDiffWeight = typeDiffWeight;
                        continue;
                    }
                    catch (UnsatisfiedDependencyException ex) {
                        if (this.beanFactory.logger.isTraceEnabled()) {
                            this.beanFactory.logger.trace((Object)("Ignoring constructor [" + candidate + "] of bean '" + beanName + "': " + ex));
                        }
                        if (i != candidates.length - 1 || constructorToUse != null) continue;
                        throw ex;
                    }
                }
                if (constructorToUse == null) {
                    throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Could not resolve matching constructor");
                }
            }
            mbd.resolvedConstructorOrFactoryMethod = constructorToUse;
        }
        Object beanInstance = this.instantiationStrategy.instantiate(mbd, beanName, this.beanFactory, constructorToUse, argsToUse);
        bw.setWrappedInstance(beanInstance);
        return bw;
    }

    public BeanWrapper instantiateUsingFactoryMethod(String beanName, RootBeanDefinition mbd, Object[] explicitArgs) {
        BeanWrapperImpl bw = new BeanWrapperImpl();
        this.beanFactory.initBeanWrapper(bw);
        Class<?> factoryClass = null;
        Object factoryBean = null;
        boolean isStatic = true;
        if (mbd.getFactoryBeanName() != null) {
            factoryBean = this.beanFactory.getBean(mbd.getFactoryBeanName());
            factoryClass = factoryBean.getClass();
            isStatic = false;
        } else {
            factoryClass = mbd.getBeanClass();
        }
        Method factoryMethodToUse = (Method)mbd.resolvedConstructorOrFactoryMethod;
        Object[] argsToUse = null;
        if (factoryMethodToUse != null) {
            if (explicitArgs != null) {
                argsToUse = explicitArgs;
            } else {
                argsToUse = mbd.resolvedConstructorArguments;
                if (argsToUse == null) {
                    Class<?>[] paramTypes = factoryMethodToUse.getParameterTypes();
                    Object[] argsToResolve = mbd.preparedConstructorArguments;
                    BeanDefinitionValueResolver valueResolver = new BeanDefinitionValueResolver(this.beanFactory, beanName, mbd, bw);
                    argsToUse = new Object[argsToResolve.length];
                    for (int i = 0; i < argsToResolve.length; ++i) {
                        Object argValue = argsToResolve[i];
                        if (argValue instanceof BeanMetadataElement) {
                            String argName = "factory method argument with index " + i;
                            argValue = valueResolver.resolveValueIfNecessary(argName, argValue);
                        }
                        argsToUse[i] = bw.convertIfNecessary(argValue, paramTypes[i], new MethodParameter(factoryMethodToUse, i));
                    }
                }
            }
        } else {
            Method[] candidates = ReflectionUtils.getAllDeclaredMethods(factoryClass);
            boolean autowiring = mbd.getResolvedAutowireMode() == 3;
            int minTypeDiffWeight = Integer.MAX_VALUE;
            ConstructorArgumentValues resolvedValues = null;
            int minNrOfArgs = 0;
            if (explicitArgs != null) {
                minNrOfArgs = explicitArgs.length;
            } else {
                ConstructorArgumentValues cargs = mbd.getConstructorArgumentValues();
                resolvedValues = new ConstructorArgumentValues();
                minNrOfArgs = this.resolveConstructorArguments(beanName, mbd, bw, cargs, resolvedValues);
            }
            for (int i = 0; i < candidates.length; ++i) {
                Method candidate = candidates[i];
                Class[] paramTypes = candidate.getParameterTypes();
                if (Modifier.isStatic(candidate.getModifiers()) != isStatic || !candidate.getName().equals(mbd.getFactoryMethodName()) || paramTypes.length < minNrOfArgs) continue;
                ArgumentsHolder args = null;
                if (resolvedValues != null) {
                    try {
                        args = this.createArgumentArray(beanName, mbd, resolvedValues, bw, paramTypes, candidate, autowiring);
                    }
                    catch (UnsatisfiedDependencyException ex) {
                        if (this.beanFactory.logger.isTraceEnabled()) {
                            this.beanFactory.logger.trace((Object)("Ignoring factory method [" + candidate + "] of bean '" + beanName + "': " + ex));
                        }
                        if (i != candidates.length - 1 || factoryMethodToUse != null) continue;
                        throw ex;
                    }
                } else {
                    if (paramTypes.length != explicitArgs.length) continue;
                    args = new ArgumentsHolder(explicitArgs);
                }
                int typeDiffWeight = args.getTypeDifferenceWeight(paramTypes);
                if (typeDiffWeight >= minTypeDiffWeight) continue;
                factoryMethodToUse = candidate;
                argsToUse = args.arguments;
                minTypeDiffWeight = typeDiffWeight;
            }
            if (factoryMethodToUse == null) {
                throw new BeanDefinitionStoreException("No matching factory method found: " + (mbd.getFactoryBeanName() != null ? "factory bean '" + mbd.getFactoryBeanName() + "'; " : "") + "factory method '" + mbd.getFactoryMethodName() + "'");
            }
            mbd.resolvedConstructorOrFactoryMethod = factoryMethodToUse;
        }
        Object beanInstance = this.instantiationStrategy.instantiate(mbd, beanName, this.beanFactory, factoryBean, factoryMethodToUse, argsToUse);
        if (beanInstance == null) {
            return null;
        }
        bw.setWrappedInstance(beanInstance);
        return bw;
    }

    private int resolveConstructorArguments(String beanName, RootBeanDefinition mbd, BeanWrapper bw, ConstructorArgumentValues cargs, ConstructorArgumentValues resolvedValues) {
        BeanDefinitionValueResolver valueResolver = new BeanDefinitionValueResolver(this.beanFactory, beanName, mbd, bw);
        int minNrOfArgs = cargs.getArgumentCount();
        Iterator it = cargs.getIndexedArgumentValues().entrySet().iterator();
        while (it.hasNext()) {
            ConstructorArgumentValues.ValueHolder valueHolder;
            Map.Entry entry = it.next();
            int index = (Integer)entry.getKey();
            if (index < 0) {
                throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Invalid constructor argument index: " + index);
            }
            if (index > minNrOfArgs) {
                minNrOfArgs = index + 1;
            }
            if ((valueHolder = (ConstructorArgumentValues.ValueHolder)entry.getValue()).isConverted()) {
                resolvedValues.addIndexedArgumentValue(index, valueHolder);
                continue;
            }
            String argName = "constructor argument with index " + index;
            Object resolvedValue = valueResolver.resolveValueIfNecessary(argName, valueHolder.getValue());
            ConstructorArgumentValues.ValueHolder resolvedValueHolder = new ConstructorArgumentValues.ValueHolder(resolvedValue, valueHolder.getType());
            resolvedValueHolder.setSource(valueHolder);
            resolvedValues.addIndexedArgumentValue(index, resolvedValueHolder);
        }
        it = cargs.getGenericArgumentValues().iterator();
        while (it.hasNext()) {
            ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)((Object)it.next());
            if (valueHolder.isConverted()) {
                resolvedValues.addGenericArgumentValue(valueHolder);
                continue;
            }
            String argName = "constructor argument";
            Object resolvedValue = valueResolver.resolveValueIfNecessary(argName, valueHolder.getValue());
            ConstructorArgumentValues.ValueHolder resolvedValueHolder = new ConstructorArgumentValues.ValueHolder(resolvedValue, valueHolder.getType());
            resolvedValueHolder.setSource(valueHolder);
            resolvedValues.addGenericArgumentValue(resolvedValueHolder);
        }
        return minNrOfArgs;
    }

    private ArgumentsHolder createArgumentArray(String beanName, RootBeanDefinition mbd, ConstructorArgumentValues resolvedValues, BeanWrapper bw, Class[] paramTypes, Object methodOrCtor, boolean autowiring) throws UnsatisfiedDependencyException {
        String methodType = methodOrCtor instanceof Constructor ? "constructor" : "factory method";
        ArgumentsHolder args = new ArgumentsHolder(paramTypes.length);
        HashSet<ConstructorArgumentValues.ValueHolder> usedValueHolders = new HashSet<ConstructorArgumentValues.ValueHolder>(paramTypes.length);
        boolean resolveNecessary = false;
        for (int index = 0; index < paramTypes.length; ++index) {
            ConstructorArgumentValues.ValueHolder valueHolder = resolvedValues.getArgumentValue(index, paramTypes[index], usedValueHolders);
            if (valueHolder == null && !autowiring) {
                valueHolder = resolvedValues.getGenericArgumentValue(null, usedValueHolders);
            }
            if (valueHolder != null) {
                usedValueHolders.add(valueHolder);
                args.rawArguments[index] = valueHolder.getValue();
                if (valueHolder.isConverted()) {
                    Object convertedValue;
                    args.arguments[index] = convertedValue = valueHolder.getConvertedValue();
                    args.preparedArguments[index] = convertedValue;
                    continue;
                }
                try {
                    Object convertedValue;
                    Object originalValue = valueHolder.getValue();
                    args.arguments[index] = convertedValue = bw.convertIfNecessary(originalValue, paramTypes[index], MethodParameter.forMethodOrConstructor(methodOrCtor, index));
                    ConstructorArgumentValues.ValueHolder sourceHolder = (ConstructorArgumentValues.ValueHolder)valueHolder.getSource();
                    Object sourceValue = sourceHolder.getValue();
                    if (originalValue == sourceValue || sourceValue instanceof TypedStringValue) {
                        sourceHolder.setConvertedValue(convertedValue);
                        args.preparedArguments[index] = convertedValue;
                        continue;
                    }
                    resolveNecessary = true;
                    args.preparedArguments[index] = sourceValue;
                    continue;
                }
                catch (TypeMismatchException ex) {
                    throw new UnsatisfiedDependencyException(mbd.getResourceDescription(), beanName, index, paramTypes[index], "Could not convert " + methodType + " argument value of type [" + ObjectUtils.nullSafeClassName(valueHolder.getValue()) + "] to required type [" + paramTypes[index].getName() + "]: " + ex.getMessage());
                }
            }
            if (!autowiring) {
                throw new UnsatisfiedDependencyException(mbd.getResourceDescription(), beanName, index, paramTypes[index], "Ambiguous " + methodType + " argument types - " + "did you specify the correct bean references as " + methodType + " arguments?");
            }
            Map matchingBeans = this.findAutowireCandidates(beanName, paramTypes[index]);
            if (matchingBeans.size() != 1) {
                throw new UnsatisfiedDependencyException(mbd.getResourceDescription(), beanName, index, paramTypes[index], "There are " + matchingBeans.size() + " beans of type [" + paramTypes[index].getName() + "] available for autowiring: " + matchingBeans.keySet() + ". There should have been exactly 1 to be able to autowire " + methodType + " of bean '" + beanName + "'.");
            }
            Map.Entry entry = matchingBeans.entrySet().iterator().next();
            String autowiredBeanName = (String)entry.getKey();
            Object autowiredBean = entry.getValue();
            args.rawArguments[index] = autowiredBean;
            args.arguments[index] = autowiredBean;
            if (mbd.isSingleton()) {
                this.beanFactory.registerDependentBean(autowiredBeanName, beanName);
            }
            if (!this.beanFactory.logger.isDebugEnabled()) continue;
            this.beanFactory.logger.debug((Object)("Autowiring by type from bean name '" + beanName + "' via " + methodType + " to bean named '" + autowiredBeanName + "'"));
        }
        if (resolveNecessary) {
            mbd.preparedConstructorArguments = args.preparedArguments;
        } else {
            mbd.resolvedConstructorArguments = args.arguments;
        }
        return args;
    }

    protected abstract Map findAutowireCandidates(String var1, Class var2) throws BeansException;

    private static class ArgumentsHolder {
        public Object[] rawArguments;
        public Object[] arguments;
        public Object[] preparedArguments;

        public ArgumentsHolder(int size) {
            this.rawArguments = new Object[size];
            this.arguments = new Object[size];
            this.preparedArguments = new Object[size];
        }

        public ArgumentsHolder(Object[] args) {
            this.rawArguments = args;
            this.arguments = args;
            this.preparedArguments = args;
        }

        public int getTypeDifferenceWeight(Class[] paramTypes) {
            int typeDiffWeight = AutowireUtils.getTypeDifferenceWeight(paramTypes, this.arguments);
            int rawTypeDiffWeight = AutowireUtils.getTypeDifferenceWeight(paramTypes, this.rawArguments) - 1024;
            return rawTypeDiffWeight < typeDiffWeight ? rawTypeDiffWeight : typeDiffWeight;
        }
    }
}

