/*
 * Decompiled with CFR 0.152.
 */
package com.iona.cxf.container;

import com.iona.cxf.container.Application;
import com.iona.cxf.container.ApplicationState;
import com.iona.cxf.container.ContainerException;
import com.iona.cxf.container.managed.JMXContainer;
import com.iona.cxf.container.util.ApplicationExploder;
import com.iona.cxf.container.util.Utils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContainerBean
implements JMXContainer,
InitializingBean,
DisposableBean,
ApplicationContextAware {
    private static final Logger LOG = LogUtils.getL7dLogger(ContainerBean.class);
    private static final String WAR_FILE_SUFFIX = ".war";
    private static final String CORRUPTED_JAR_SUFFIX = ".corrupted";
    private File repository;
    private Map<String, Application> applications = new Hashtable<String, Application>();
    private ApplicationContext applicationContext;
    private long scanInterval = -1L;
    private Thread scanner;
    private volatile boolean destroy;

    public ContainerBean() {
    }

    public ContainerBean(File repositoryLoc) {
        this.repository = repositoryLoc;
    }

    public File getContainerRepository() {
        return this.repository;
    }

    public void setContainerRepository(File dir) {
        this.repository = dir;
    }

    public void setScanInterval(long interval) {
        this.scanInterval = interval;
    }

    public long getScanInterval() {
        return this.scanInterval;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.applicationContext = context;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public synchronized void run() {
        this.scanRepository();
        if (this.scanInterval > 0L && this.scanner == null) {
            this.scanner = new Thread(new Scanner());
            this.scanner.start();
        }
    }

    public synchronized void shutdown() {
        Set<String> keys = this.applications.keySet();
        Iterator<String> it = keys.iterator();
        String appName = null;
        while (it.hasNext()) {
            try {
                appName = it.next();
                Application ctx = this.applications.get(appName);
                ctx.stop();
            }
            catch (Exception ex) {
                LogUtils.log((Logger)LOG, (Level)Level.SEVERE, (String)"APPLICATION_STOP_FAILED", (Throwable)ex, (Object[])new Object[]{appName});
            }
        }
    }

    public void deploy(String location) throws ContainerException {
        String warFileName = null;
        URL url = this.stringToURL(location);
        String path = url.getPath();
        int index = path.lastIndexOf(47);
        if (index >= 0) {
            warFileName = path.substring(index + 1);
        }
        this.deploy(url, warFileName);
    }

    @Override
    public void deploy(String location, String warFileName) throws ContainerException {
        URL url = this.stringToURL(location);
        this.deploy(url, warFileName);
    }

    public synchronized void deploy(URL url, String warFileName) throws ContainerException {
        LOG.log(Level.INFO, "APPLICATION_DEPLOY_URL", new Object[]{url});
        if (!warFileName.endsWith(WAR_FILE_SUFFIX)) {
            warFileName = warFileName + WAR_FILE_SUFFIX;
        }
        try {
            File war = new File(this.repository, warFileName);
            if (war.exists()) {
                throw new ContainerException(new Message("WAR_ALREADY_EXISTS", LOG, new Object[]{warFileName}));
            }
            InputStream istream = null;
            byte[] bytes = null;
            try {
                istream = url.openStream();
                bytes = Utils.streamToByteArray(istream);
            }
            catch (IOException ioex) {
                throw new ContainerException(ioex);
            }
            finally {
                if (null != istream) {
                    istream.close();
                }
            }
            OutputStream ostream = null;
            try {
                FileOutputStream fout = new FileOutputStream(war);
                ostream = new BufferedOutputStream(fout);
                ostream.write(bytes);
            }
            catch (IOException ioex2) {
                throw new ContainerException(ioex2);
            }
            finally {
                ostream.close();
            }
            this.deployWar(war);
        }
        catch (IOException ioex3) {
            throw new ContainerException(ioex3);
        }
    }

    void deployWar(File war) throws ContainerException {
        File appDir = null;
        try {
            appDir = ApplicationExploder.explodeApplication(war, this.repository);
        }
        catch (IOException ioex) {
            File invalidWar = new File(war.toString() + CORRUPTED_JAR_SUFFIX);
            war.renameTo(invalidWar);
            throw new ContainerException(ioex);
        }
        this.deployApplication(appDir);
    }

    private void deployApplication(File appDir) throws ContainerException {
        try {
            LOG.log(Level.INFO, "EXPLODED_APPLICATION_DIR", new Object[]{appDir});
            Application app = new Application(appDir.getName(), appDir);
            app.start();
            this.applications.put(app.getName(), app);
        }
        catch (ContainerException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ContainerException(ex);
        }
    }

    public List<Application> getApplications() {
        return new ArrayList<Application>(this.applications.values());
    }

    @Override
    public synchronized void stopApplication(String name) throws ContainerException {
        Application app = this.applications.get(name);
        if (app == null) {
            throw new ContainerException(new Message("APPLICATION_DOES_NOT_EXIST", LOG, new Object[]{name}));
        }
        LOG.log(Level.INFO, "STOPPING_APPLICATION", new Object[]{name});
        app.stop();
    }

    @Override
    public synchronized void startApplication(String name) throws ContainerException {
        Application app = this.applications.get(name);
        if (app == null) {
            throw new ContainerException(new Message("APPLICATION_DOES_NOT_EXIST", LOG, new Object[]{name}));
        }
        LOG.log(Level.INFO, "STARTING_APPLICATION", new Object[]{name});
        app.start();
    }

    @Override
    public synchronized void removeApplication(String name) throws ContainerException {
        Application app = this.applications.get(name);
        if (app != null) {
            LOG.log(Level.INFO, "REMOVING_APPLICATION", new Object[]{name});
            try {
                this.applications.remove(name);
                app.stop();
            }
            catch (Exception ex) {
                throw new ContainerException(ex);
            }
            finally {
                File dir = app.getApplicationDirectory();
                String warName = dir.getName() + WAR_FILE_SUFFIX;
                ApplicationExploder.deleteFile(dir);
                File war = new File(this.repository, warName);
                if (war.exists()) {
                    war.delete();
                }
            }
        } else {
            throw new ContainerException(new Message("APPLICATION_DOES_NOT_EXIST", LOG, new Object[]{name}));
        }
    }

    @Override
    public synchronized String[] listApplicationNames() {
        Set<String> set = this.applications.keySet();
        String[] names = set.toArray(new String[set.size()]);
        return names;
    }

    @Override
    public String[] listApplicationServices(String name) throws ContainerException {
        Application app = this.applications.get(name);
        if (app != null) {
            QName[] qnames = app.getServices().toArray(new QName[0]);
            String[] services = new String[qnames.length];
            for (int i = 0; i < qnames.length; ++i) {
                services[i] = qnames[i].toString();
            }
            return services;
        }
        throw new ContainerException(new Message("APPLICATION_DOES_NOT_EXIST", LOG, new Object[]{name}));
    }

    @Override
    public synchronized ApplicationState getApplicationState(String name) throws ContainerException {
        Application app = this.applications.get(name);
        if (app != null) {
            return app.getState();
        }
        throw new ContainerException(new Message("APPLICATION_DOES_NOT_EXIST", LOG, new Object[]{name}));
    }

    public synchronized void scanRepository() {
        File[] files = this.repository.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(ContainerBean.WAR_FILE_SUFFIX);
            }
        });
        if (null != files) {
            for (File file : files) {
                int i;
                String fileName = file.getName();
                String appName = fileName.substring(0, i = fileName.indexOf(WAR_FILE_SUFFIX));
                Application app = this.applications.get(appName);
                if (null != app) continue;
                try {
                    LOG.log(Level.INFO, "DEPLOYING_APPLICATION", new Object[]{appName});
                    this.deployWar(file);
                }
                catch (ContainerException ctex) {
                    LOG.log(Level.SEVERE, ctex.getMessage(), ctex);
                }
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (null == this.repository) {
            throw new ContainerException(new Message("REPOSITORY_LOC_NOT_SET", LOG, new Object[0]));
        }
        if (!this.repository.exists()) {
            throw new ContainerException(new Message("REPOSITORY_LOC_DOES_NOT_EXIST", LOG, new Object[]{this.repository}));
        }
        this.run();
    }

    public void destroy() throws Exception {
        LOG.log(Level.INFO, "DESTROYING_CONTAINER", (Object[])null);
        this.destroy = true;
        if (this.scanner != null) {
            this.scanner.join();
        }
        this.shutdown();
    }

    private URL stringToURL(String location) throws ContainerException {
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException mux) {
            File file = new File(location);
            if (file.exists()) {
                try {
                    url = file.toURL();
                }
                catch (MalformedURLException mux2) {
                    throw new ContainerException(new Message("INVALID_LOCATION", LOG, new Object[]{mux}));
                }
            }
            throw new ContainerException(new Message("INVALID_LOCATION", LOG, new Object[]{mux}));
        }
        return url;
    }

    private class Scanner
    implements Runnable {
        private Scanner() {
        }

        public void run() {
            while (!ContainerBean.this.destroy) {
                ContainerBean.this.scanRepository();
                try {
                    Thread.sleep(ContainerBean.this.scanInterval);
                }
                catch (InterruptedException iex) {
                    break;
                }
            }
        }
    }
}

