/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jbi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.jbi.JBIDestinationOutputStream;
import org.apache.cxf.transport.jbi.JBIDispatcherUtil;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;

public class JBIDestination
extends AbstractDestination {
    private static final Logger LOG = LogUtils.getL7dLogger(JBIDestination.class);
    private JBIDispatcherUtil dispatcherUtil;
    private DeliveryChannel channel;

    public JBIDestination(EndpointInfo info, JBIDispatcherUtil dispatcher, DeliveryChannel dc) {
        super(JBIDestination.getTargetReference((EndpointInfo)info, null), info);
        this.dispatcherUtil = dispatcher;
        this.channel = dc;
    }

    public void setDeliveryChannel(DeliveryChannel dc) {
        this.channel = dc;
    }

    public DeliveryChannel getDeliveryChannel() {
        return this.channel;
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected Conduit getInbuiltBackChannel(Message inMessage) {
        return new BackChannelConduit(EndpointReferenceUtils.getAnonymousEndpointReference(), inMessage);
    }

    public void shutdown() {
        this.dispatcherUtil.deactivateDispatch();
    }

    public void deactivate() {
        this.dispatcherUtil.deactivateDispatch();
    }

    public void activate() {
        this.dispatcherUtil.activateDispatch();
    }

    public JBIDispatcherUtil getJBIDispatcherUtil() {
        return this.dispatcherUtil;
    }

    protected class BackChannelConduit
    extends AbstractConduit {
        protected Message inMessage;
        protected JBIDestination jbiDestination;

        BackChannelConduit(EndpointReferenceType ref, Message message) {
            super(ref);
            this.inMessage = message;
        }

        public void setMessageObserver(MessageObserver observer) {
        }

        public void prepare(Message message) throws IOException {
            DeliveryChannel dc = JBIDestination.this.channel;
            message.put(MessageExchange.class, this.inMessage.get(MessageExchange.class));
            message.setContent(OutputStream.class, (Object)new JBIDestinationOutputStream(this.inMessage, dc));
        }

        protected Logger getLogger() {
            return LOG;
        }
    }
}

