/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.basic;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.util.NamespaceHelper;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayType
extends Type {
    private static final Log LOG = LogFactory.getLog(ArrayType.class);
    private QName componentName;
    private long minOccurs;
    private long maxOccurs = Long.MAX_VALUE;
    private boolean flat;

    @Override
    public Object readObject(MessageReader reader, Context context) throws DatabindingException {
        try {
            Collection values = this.readCollection(reader, context);
            return this.makeArray(this.getComponentType().getTypeClass(), values);
        }
        catch (IllegalArgumentException e) {
            throw new DatabindingException("Illegal argument.", e);
        }
    }

    protected Collection<Object> createCollection() {
        return new ArrayList<Object>();
    }

    protected Collection readCollection(MessageReader reader, Context context) throws DatabindingException {
        Collection<Object> values = this.createCollection();
        while (reader.hasMoreElementReaders()) {
            int size;
            MessageReader creader = reader.getNextElementReader();
            Type compType = TypeUtil.getReadType(creader.getXMLStreamReader(), context, this.getComponentType());
            if (creader.isXsiNil()) {
                values.add(null);
                creader.readToEnd();
            } else {
                values.add(compType.readObject(creader, context));
            }
            if ((long)(size = values.size()) <= this.maxOccurs) continue;
            throw new DatabindingException("The number of elements in " + this.getSchemaType() + " exceeds the maximum of " + this.maxOccurs);
        }
        if ((long)values.size() < this.minOccurs) {
            throw new DatabindingException("The number of elements in " + this.getSchemaType() + " does not meet the minimum of " + this.minOccurs);
        }
        return values;
    }

    protected Object makeArray(Class arrayType, Collection values) {
        Object array;
        block9: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        array = null;
                                        if (!Integer.TYPE.equals(arrayType)) break block8;
                                        Object[] objects = values.toArray();
                                        array = Array.newInstance(Integer.TYPE, objects.length);
                                        int n = objects.length;
                                        for (int i = 0; i < n; ++i) {
                                            Array.set(array, i, objects[i]);
                                        }
                                        break block9;
                                    }
                                    if (!Long.TYPE.equals(arrayType)) break block10;
                                    Object[] objects = values.toArray();
                                    array = Array.newInstance(Long.TYPE, objects.length);
                                    int n = objects.length;
                                    for (int i = 0; i < n; ++i) {
                                        Array.set(array, i, objects[i]);
                                    }
                                    break block9;
                                }
                                if (!Short.TYPE.equals(arrayType)) break block11;
                                Object[] objects = values.toArray();
                                array = Array.newInstance(Short.TYPE, objects.length);
                                int n = objects.length;
                                for (int i = 0; i < n; ++i) {
                                    Array.set(array, i, objects[i]);
                                }
                                break block9;
                            }
                            if (!Double.TYPE.equals(arrayType)) break block12;
                            Object[] objects = values.toArray();
                            array = Array.newInstance(Double.TYPE, objects.length);
                            int n = objects.length;
                            for (int i = 0; i < n; ++i) {
                                Array.set(array, i, objects[i]);
                            }
                            break block9;
                        }
                        if (!Float.TYPE.equals(arrayType)) break block13;
                        Object[] objects = values.toArray();
                        array = Array.newInstance(Float.TYPE, objects.length);
                        int n = objects.length;
                        for (int i = 0; i < n; ++i) {
                            Array.set(array, i, objects[i]);
                        }
                        break block9;
                    }
                    if (!Byte.TYPE.equals(arrayType)) break block14;
                    Object[] objects = values.toArray();
                    array = Array.newInstance(Byte.TYPE, objects.length);
                    int n = objects.length;
                    for (int i = 0; i < n; ++i) {
                        Array.set(array, i, objects[i]);
                    }
                    break block9;
                }
                if (!Boolean.TYPE.equals(arrayType)) break block15;
                Object[] objects = values.toArray();
                array = Array.newInstance(Boolean.TYPE, objects.length);
                int n = objects.length;
                for (int i = 0; i < n; ++i) {
                    Array.set(array, i, objects[i]);
                }
                break block9;
            }
            if (!Character.TYPE.equals(arrayType)) break block9;
            Object[] objects = values.toArray();
            array = Array.newInstance(Character.TYPE, objects.length);
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                Array.set(array, i, objects[i]);
            }
        }
        return array == null ? values.toArray((Object[])Array.newInstance(this.getComponentType().getTypeClass(), values.size())) : array;
    }

    @Override
    public void writeObject(Object values, MessageWriter writer, Context context) throws DatabindingException {
        block12: {
            Class arrayType;
            String name;
            String ns;
            Type type;
            block19: {
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        block11: {
                                            if (values == null) {
                                                return;
                                            }
                                            type = this.getComponentType();
                                            ns = null;
                                            ns = type.isAbstract() ? this.getSchemaType().getNamespaceURI() : type.getSchemaType().getNamespaceURI();
                                            name = type.getSchemaType().getLocalPart();
                                            if (type == null) {
                                                throw new DatabindingException("Couldn't find type for " + type.getTypeClass() + ".");
                                            }
                                            arrayType = type.getTypeClass();
                                            if (!Object.class.isAssignableFrom(arrayType)) break block11;
                                            Object[] objects = (Object[])values;
                                            int n = objects.length;
                                            for (int i = 0; i < n; ++i) {
                                                this.writeValue(objects[i], writer, context, type, name, ns);
                                            }
                                            break block12;
                                        }
                                        if (!Integer.TYPE.equals(arrayType)) break block13;
                                        int[] objects = (int[])values;
                                        int n = objects.length;
                                        for (int i = 0; i < n; ++i) {
                                            this.writeValue(new Integer(objects[i]), writer, context, type, name, ns);
                                        }
                                        break block12;
                                    }
                                    if (!Long.TYPE.equals(arrayType)) break block14;
                                    long[] objects = (long[])values;
                                    int n = objects.length;
                                    for (int i = 0; i < n; ++i) {
                                        this.writeValue(new Long(objects[i]), writer, context, type, name, ns);
                                    }
                                    break block12;
                                }
                                if (!Short.TYPE.equals(arrayType)) break block15;
                                short[] objects = (short[])values;
                                int n = objects.length;
                                for (int i = 0; i < n; ++i) {
                                    this.writeValue(new Short(objects[i]), writer, context, type, name, ns);
                                }
                                break block12;
                            }
                            if (!Double.TYPE.equals(arrayType)) break block16;
                            double[] objects = (double[])values;
                            int n = objects.length;
                            for (int i = 0; i < n; ++i) {
                                this.writeValue(new Double(objects[i]), writer, context, type, name, ns);
                            }
                            break block12;
                        }
                        if (!Float.TYPE.equals(arrayType)) break block17;
                        float[] objects = (float[])values;
                        int n = objects.length;
                        for (int i = 0; i < n; ++i) {
                            this.writeValue(new Float(objects[i]), writer, context, type, name, ns);
                        }
                        break block12;
                    }
                    if (!Byte.TYPE.equals(arrayType)) break block18;
                    byte[] objects = (byte[])values;
                    int n = objects.length;
                    for (int i = 0; i < n; ++i) {
                        this.writeValue(new Byte(objects[i]), writer, context, type, name, ns);
                    }
                    break block12;
                }
                if (!Boolean.TYPE.equals(arrayType)) break block19;
                boolean[] objects = (boolean[])values;
                int n = objects.length;
                for (int i = 0; i < n; ++i) {
                    this.writeValue(objects[i], writer, context, type, name, ns);
                }
                break block12;
            }
            if (!Character.TYPE.equals(arrayType)) break block12;
            char[] objects = (char[])values;
            int n = objects.length;
            for (int i = 0; i < n; ++i) {
                this.writeValue(new Character(objects[i]), writer, context, type, name, ns);
            }
        }
    }

    protected void writeValue(Object value, MessageWriter writer, Context context, Type type, String name, String ns) throws DatabindingException {
        MessageWriter cwriter = (type = TypeUtil.getWriteType(context, value, type)).isWriteOuter() ? writer.getElementWriter(name, ns) : writer;
        if (value == null && type.isNillable()) {
            cwriter.writeXsiNil();
        } else {
            type.writeObject(value, cwriter, context);
        }
        cwriter.close();
    }

    @Override
    public void writeSchema(Element root) {
        try {
            if (this.hasDefinedArray(root)) {
                return;
            }
            Element complex = new Element("complexType", "xsd", "http://www.w3.org/2001/XMLSchema");
            complex.setAttribute(new Attribute("name", this.getSchemaType().getLocalPart()));
            root.addContent((Content)complex);
            Element seq = new Element("sequence", "xsd", "http://www.w3.org/2001/XMLSchema");
            complex.addContent((Content)seq);
            Element element = new Element("element", "xsd", "http://www.w3.org/2001/XMLSchema");
            seq.addContent((Content)element);
            Type componentType = this.getComponentType();
            String prefix = NamespaceHelper.getUniquePrefix(root, componentType.getSchemaType().getNamespaceURI());
            String typeName = prefix + ":" + componentType.getSchemaType().getLocalPart();
            element.setAttribute(new Attribute("name", componentType.getSchemaType().getLocalPart()));
            element.setAttribute(new Attribute("type", typeName));
            if (componentType.isNillable()) {
                element.setAttribute(new Attribute("nillable", "true"));
            }
            element.setAttribute(new Attribute("minOccurs", Long.valueOf(this.getMinOccurs()).toString()));
            if (this.maxOccurs == Long.MAX_VALUE) {
                element.setAttribute(new Attribute("maxOccurs", "unbounded"));
            } else {
                element.setAttribute(new Attribute("maxOccurs", Long.valueOf(this.getMaxOccurs()).toString()));
            }
        }
        catch (IllegalArgumentException e) {
            throw new DatabindingException("Illegal argument.", e);
        }
    }

    private boolean hasDefinedArray(Element root) {
        List children = root.getChildren("complexType", Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema"));
        for (Element e : children) {
            if (!e.getAttributeValue("name").equals(this.getSchemaType().getLocalPart())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    public QName getComponentName() {
        return this.componentName;
    }

    public void setComponentName(QName componentName) {
        this.componentName = componentName;
    }

    @Override
    public Set<Type> getDependencies() {
        HashSet<Type> deps = new HashSet<Type>();
        deps.add(this.getComponentType());
        return deps;
    }

    public Type getComponentType() {
        Type type;
        Class<?> compType = this.getTypeClass().getComponentType();
        if (this.componentName == null) {
            type = this.getTypeMapping().getType(compType);
        } else {
            type = this.getTypeMapping().getType(this.componentName);
            if (type == null) {
                LOG.debug((Object)("Couldn't find array component type " + this.componentName + ". Creating one instead."));
            }
        }
        if (type == null) {
            type = this.getTypeMapping().getTypeCreator().createType(compType);
            this.getTypeMapping().register(type);
        }
        return type;
    }

    public long getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(long maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public long getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(long minOccurs) {
        this.minOccurs = minOccurs;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public void setFlat(boolean flat) {
        this.setWriteOuter(!flat);
        this.flat = flat;
    }
}

