/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.xmlschema;

import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.XmlSchemaInvalidOperation;
import org.apache.ws.commons.schema.XmlSchemaElement;

public final class XmlSchemaTools {
    private static final Logger LOG = LogUtils.getL7dLogger(XmlSchemaTools.class);

    private XmlSchemaTools() {
    }

    private static void setNameFromQName(XmlSchemaElement element, QName name) {
        if (name == null) {
            element.setName(null);
        } else {
            element.setName(name.getLocalPart());
        }
    }

    public static void setElementQName(XmlSchemaElement element, QName name) {
        if (name != null && element.getRefName() != null && !element.getRefName().equals(name)) {
            LOG.severe("Attempt to set the QName of an element with a reference name");
            throw new XmlSchemaInvalidOperation("Attempt to set the QName of an element with a reference name.");
        }
        element.setQName(name);
        XmlSchemaTools.setNameFromQName(element, name);
    }

    public static void setElementName(XmlSchemaElement element, String name) {
        if (name != null && element.getRefName() != null && !element.getRefName().getLocalPart().equals(name) && (element.getQName() == null || element.getQName().getLocalPart().equals(name))) {
            LOG.severe("Attempt to set the name of an element with a reference name.");
            throw new XmlSchemaInvalidOperation("Attempt to set the name of an element with a reference name.");
        }
        element.setName(name);
    }

    public static void setElementRefName(XmlSchemaElement element, QName name) {
        if (name != null && (element.getQName() != null && !element.getQName().equals(name) || element.getName() != null && !element.getName().equals(name.getLocalPart()))) {
            LOG.severe("Attempt to set the refName of an element with a name or QName");
            throw new XmlSchemaInvalidOperation("Attempt to set the refName of an element with a name or QName.");
        }
        element.setRefName(name);
        XmlSchemaTools.setNameFromQName(element, name);
    }
}

