/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.spring;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.jaxws.EndpointImpl;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EndpointDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String IMPLEMENTOR = "implementor";

    public EndpointDefinitionParser() {
        this.setBeanClass(EndpointImpl.class);
    }

    protected String getSuffix() {
        return ".jaxws-endpoint";
    }

    protected void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        boolean isAbstract = false;
        NamedNodeMap atts = element.getAttributes();
        String bus = element.getAttribute("bus");
        if (StringUtils.isEmpty(bus)) {
            if (ctx.getRegistry().containsBeanDefinition("cxf")) {
                bean.addConstructorArgReference("cxf");
            }
        } else if (ctx.getRegistry().containsBeanDefinition(bus)) {
            bean.addConstructorArgReference(bus);
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr node = (Attr)atts.item(i);
            String val = node.getValue();
            String pre = node.getPrefix();
            String name = node.getLocalName();
            if ("createdFromAPI".equals(name)) {
                bean.setAbstract(true);
                isAbstract = true;
                continue;
            }
            if (this.isAttribute(pre, name) && !"publish".equals(name) && !"bus".equals(name)) {
                if ("endpointName".equals(name) || "serviceName".equals(name)) {
                    QName q = this.parseQName(element, val);
                    bean.addPropertyValue(name, (Object)q);
                    continue;
                }
                if ("depends-on".equals(name)) {
                    bean.addDependsOn(val);
                    continue;
                }
                if (IMPLEMENTOR.equals(name)) {
                    this.loadImplementor(bean, val);
                    continue;
                }
                if ("name".equals(name)) continue;
                this.mapToProperty(bean, name, val);
                continue;
            }
            if (!"abstract".equals(name)) continue;
            bean.setAbstract(true);
            isAbstract = true;
        }
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            String name = n.getLocalName();
            if ("properties".equals(n.getLocalName())) {
                Map map = ctx.getDelegate().parseMapElement((Element)n, (BeanDefinition)bean.getBeanDefinition());
                bean.addPropertyValue("properties", (Object)map);
                continue;
            }
            if ("binding".equals(name)) {
                this.setFirstChildAsProperty((Element)n, ctx, bean, "bindingConfig");
                continue;
            }
            if ("inInterceptors".equals(name) || "inFaultInterceptors".equals(name) || "outInterceptors".equals(name) || "outFaultInterceptors".equals(name) || "features".equals(name) || "schemaLocations".equals(name)) {
                List list = ctx.getDelegate().parseListElement((Element)n, (BeanDefinition)bean.getBeanDefinition());
                bean.addPropertyValue(name, (Object)list);
                continue;
            }
            if (IMPLEMENTOR.equals(name)) {
                ctx.getDelegate().parseConstructorArgElement((Element)n, (BeanDefinition)bean.getBeanDefinition());
                continue;
            }
            this.setFirstChildAsProperty((Element)n, ctx, bean, name);
        }
        if (!isAbstract) {
            bean.setInitMethodName("publish");
            bean.setDestroyMethodName("stop");
        }
        bean.setLazyInit(false);
    }

    private void loadImplementor(BeanDefinitionBuilder bean, String val) {
        if (!StringUtils.isEmpty(val)) {
            if (val.startsWith("#")) {
                bean.addConstructorArgReference(val.substring(1));
            } else {
                try {
                    Object obj = ClassLoaderUtils.loadClass(val, ((Object)((Object)this)).getClass()).newInstance();
                    bean.addConstructorArg(obj);
                }
                catch (Exception e) {
                    throw new FatalBeanException("Could not load class: " + val, (Throwable)e);
                }
            }
        }
    }

    protected String resolveId(Element elem, AbstractBeanDefinition definition, ParserContext ctx) throws BeanDefinitionStoreException {
        String id = super.resolveId(elem, definition, ctx);
        if (StringUtils.isEmpty(id)) {
            id = this.getBeanClass().getName() + "--" + definition.hashCode();
        }
        return id;
    }
}

