/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator;

import org.apache.cxf.tools.common.model.Annotator;
import org.apache.cxf.tools.common.model.JavaAnnotatable;
import org.apache.cxf.tools.common.model.JavaAnnotation;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaParameter;

public class WrapperAnnotator
implements Annotator {
    JavaParameter wrapperRequest;
    JavaParameter wrapperResponse;

    public WrapperAnnotator(JavaParameter request, JavaParameter response) {
        this.wrapperRequest = request;
        this.wrapperResponse = response;
    }

    public void annotate(JavaAnnotatable ja) {
        if (!(ja instanceof JavaMethod)) {
            throw new RuntimeException("RequestWrapper and ResponseWrapper can only annotate JavaMethod");
        }
        JavaMethod method = (JavaMethod)ja;
        if (this.wrapperRequest != null) {
            JavaAnnotation wrapperRequestAnnotation = new JavaAnnotation("RequestWrapper");
            wrapperRequestAnnotation.addArgument("localName", this.wrapperRequest.getType());
            wrapperRequestAnnotation.addArgument("targetNamespace", this.wrapperRequest.getTargetNamespace());
            wrapperRequestAnnotation.addArgument("className", this.wrapperRequest.getClassName());
            method.addAnnotation("RequestWrapper", wrapperRequestAnnotation);
            method.getInterface().addImport("javax.xml.ws.RequestWrapper");
        }
        if (this.wrapperResponse != null) {
            JavaAnnotation wrapperResponseAnnotation = new JavaAnnotation("ResponseWrapper");
            wrapperResponseAnnotation.addArgument("localName", this.wrapperResponse.getType());
            wrapperResponseAnnotation.addArgument("targetNamespace", this.wrapperResponse.getTargetNamespace());
            wrapperResponseAnnotation.addArgument("className", this.wrapperResponse.getClassName());
            method.addAnnotation("ResponseWrapper", wrapperResponseAnnotation);
            method.getInterface().addImport("javax.xml.ws.ResponseWrapper");
        }
    }
}

