/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint;

import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.common.i18n.UncheckedException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientLifeCycleManager;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.endpoint.PreexistingConduitSelector;
import org.apache.cxf.endpoint.Retryable;
import org.apache.cxf.endpoint.UpfrontConduitSelector;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AbstractBasicInterceptorProvider;
import org.apache.cxf.interceptor.ClientOutFaultObserver;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.PhaseChainCache;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.wsdl11.WSDLServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientImpl
extends AbstractBasicInterceptorProvider
implements Client,
Retryable,
MessageObserver {
    public static final String FINISHED = "exchange.finished";
    private static final Logger LOG = LogUtils.getL7dLogger(ClientImpl.class);
    protected Bus bus;
    protected ConduitSelector conduitSelector;
    protected ClientOutFaultObserver outFaultObserver;
    protected int synchronousTimeout = 60000;
    protected PhaseChainCache outboundChainCache = new PhaseChainCache();
    protected PhaseChainCache inboundChainCache = new PhaseChainCache();

    public ClientImpl(Bus b, Endpoint e) {
        this(b, e, (ConduitSelector)null);
    }

    public ClientImpl(Bus b, Endpoint e, Conduit c) {
        this(b, e, (ConduitSelector)new PreexistingConduitSelector(c));
    }

    public ClientImpl(Bus b, Endpoint e, ConduitSelector sc) {
        this.bus = b;
        this.outFaultObserver = new ClientOutFaultObserver(this.bus);
        this.getConduitSelector(sc).setEndpoint(e);
        this.notifyLifecycleManager();
    }

    public ClientImpl(URL wsdlUrl) {
        this(BusFactory.getThreadDefaultBus(), wsdlUrl, null, null);
    }

    public ClientImpl(URL wsdlUrl, QName port) {
        this(BusFactory.getThreadDefaultBus(), wsdlUrl, null, port);
    }

    public ClientImpl(Bus bus, URL wsdlUrl, QName service, QName port) {
        this.bus = bus;
        WSDLServiceFactory sf = service == null ? new WSDLServiceFactory(bus, wsdlUrl) : new WSDLServiceFactory(bus, wsdlUrl, service);
        Service svc = sf.create();
        EndpointInfo epfo = this.findEndpoint(svc, port);
        try {
            this.getConduitSelector().setEndpoint((Endpoint)new EndpointImpl(bus, svc, epfo));
        }
        catch (EndpointException epex) {
            throw new IllegalStateException("Unable to create endpoint: " + epex.getMessage(), (Throwable)((Object)epex));
        }
        this.notifyLifecycleManager();
    }

    public void destroy() {
        ClientLifeCycleManager mgr = (ClientLifeCycleManager)this.bus.getExtension(ClientLifeCycleManager.class);
        if (null != mgr) {
            mgr.clientDestroyed((Client)this);
        }
    }

    private void notifyLifecycleManager() {
        ClientLifeCycleManager mgr = (ClientLifeCycleManager)this.bus.getExtension(ClientLifeCycleManager.class);
        if (null != mgr) {
            mgr.clientCreated((Client)this);
        }
    }

    private EndpointInfo findEndpoint(Service svc, QName port) {
        EndpointInfo epfo;
        if (port != null) {
            epfo = svc.getEndpointInfo(port);
            if (epfo == null) {
                throw new IllegalArgumentException("The service " + svc.getName() + " does not have an endpoint " + port + ".");
            }
        } else {
            epfo = null;
            for (ServiceInfo svcfo : svc.getServiceInfos()) {
                block1: for (EndpointInfo e : svcfo.getEndpoints()) {
                    BindingInfo bfo = e.getBinding();
                    if (!bfo.getBindingId().equals("http://schemas.xmlsoap.org/wsdl/soap/")) continue;
                    for (Object o : (Object[])bfo.getExtensors().get()) {
                        SOAPBindingImpl soapB;
                        if (!(o instanceof SOAPBindingImpl) || !(soapB = (SOAPBindingImpl)o).getTransportURI().equals("http://schemas.xmlsoap.org/soap/http")) continue;
                        epfo = e;
                        continue block1;
                    }
                }
            }
            if (epfo == null) {
                throw new UnsupportedOperationException("Only document-style SOAP 1.1 http are supported for auto-selection of endpoint; none were found.");
            }
        }
        return epfo;
    }

    public Endpoint getEndpoint() {
        return this.getConduitSelector().getEndpoint();
    }

    public Object[] invoke(BindingOperationInfo oi, Object ... params) throws Exception {
        return this.invoke(oi, params, null);
    }

    public Object[] invoke(String operationName, Object ... params) throws Exception {
        QName q = new QName(this.getEndpoint().getService().getName().getNamespaceURI(), operationName);
        return this.invoke(q, params);
    }

    public Object[] invoke(QName operationName, Object ... params) throws Exception {
        BindingOperationInfo op = this.getEndpoint().getEndpointInfo().getBinding().getOperation(operationName);
        if (op == null) {
            throw new UncheckedException(new org.apache.cxf.common.i18n.Message("NO_OPERATION", LOG, new Object[]{operationName}));
        }
        if (op.isUnwrappedCapable()) {
            op = op.getUnwrappedOperation();
        }
        return this.invoke(op, params);
    }

    public Object[] invokeWrapped(String operationName, Object ... params) throws Exception {
        QName q = new QName(this.getEndpoint().getService().getName().getNamespaceURI(), operationName);
        return this.invokeWrapped(q, params);
    }

    public Object[] invokeWrapped(QName operationName, Object ... params) throws Exception {
        BindingOperationInfo op = this.getEndpoint().getEndpointInfo().getBinding().getOperation(operationName);
        if (op == null) {
            throw new UncheckedException(new org.apache.cxf.common.i18n.Message("NO_OPERATION", LOG, new Object[]{operationName}));
        }
        return this.invoke(op, params);
    }

    public Object[] invoke(BindingOperationInfo oi, Object[] params, Map<String, Object> context) throws Exception {
        return this.invoke(oi, params, context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] invoke(BindingOperationInfo oi, Object[] params, Map<String, Object> context, Exchange exchange) throws Exception {
        Bus origBus = BusFactory.getThreadDefaultBus((boolean)false);
        BusFactory.setThreadDefaultBus((Bus)this.bus);
        try {
            if (exchange == null) {
                exchange = new ExchangeImpl();
            }
            Endpoint endpoint = this.getEndpoint();
            Map requestContext = null;
            Map responseContext = null;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Invoke, operation info: " + oi + ", params: " + params);
            }
            Message message = endpoint.getBinding().createMessage();
            if (null != context) {
                requestContext = CastUtils.cast((Map)((Map)context.get("RequestContext")));
                responseContext = CastUtils.cast((Map)((Map)context.get("ResponseContext")));
                message.put((Object)"org.apache.cxf.invocation.context", context);
            }
            this.setContext(requestContext, message);
            this.setParameters(params, message);
            if (null != requestContext) {
                exchange.putAll(requestContext);
            }
            exchange.setOneWay(oi.getOutput() == null);
            exchange.setOutMessage(message);
            this.setOutMessageProperties(message, oi);
            this.setExchangeProperties(exchange, endpoint, oi);
            PhaseInterceptorChain chain = this.setupInterceptorChain(endpoint);
            message.setInterceptorChain((InterceptorChain)chain);
            this.modifyChain((InterceptorChain)chain, requestContext);
            chain.setFaultObserver((MessageObserver)this.outFaultObserver);
            this.prepareConduitSelector(message);
            chain.doIntercept(message);
            Exception ex = (Exception)message.getContent(Exception.class);
            boolean mepCompleteCalled = false;
            if (ex != null) {
                this.getConduitSelector().complete(exchange);
                mepCompleteCalled = true;
                if (message.getContent(Exception.class) != null) {
                    throw ex;
                }
            }
            if ((ex = (Exception)message.getExchange().get(Exception.class)) != null) {
                if (!mepCompleteCalled) {
                    this.getConduitSelector().complete(exchange);
                }
                throw ex;
            }
            if (!oi.getOperationInfo().isOneWay()) {
                Exchange exchange2 = exchange;
                synchronized (exchange2) {
                    this.waitResponse(exchange);
                }
            }
            this.getConduitSelector().complete(exchange);
            List resList = null;
            Message inMsg = exchange.getInMessage();
            if (inMsg != null) {
                if (null != responseContext) {
                    responseContext.putAll(inMsg);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("set responseContext to be" + responseContext);
                    }
                }
                resList = (List)inMsg.getContent(List.class);
            }
            if ((ex = this.getException(exchange)) != null) {
                throw ex;
            }
            if (resList != null) {
                Object[] objectArray = resList.toArray();
                return objectArray;
            }
            Object[] objectArray = null;
            return objectArray;
        }
        finally {
            BusFactory.setThreadDefaultBus((Bus)origBus);
        }
    }

    protected Exception getException(Exchange exchange) {
        if (exchange.getInFaultMessage() != null) {
            return (Exception)exchange.getInFaultMessage().getContent(Exception.class);
        }
        if (exchange.getOutFaultMessage() != null) {
            return (Exception)exchange.getOutFaultMessage().getContent(Exception.class);
        }
        return null;
    }

    private void setContext(Map<String, Object> ctx, Message message) {
        if (ctx != null) {
            message.putAll(ctx);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("set requestContext to message be" + ctx);
            }
        }
    }

    private void waitResponse(Exchange exchange) {
        long start;
        long end;
        for (int remaining = this.synchronousTimeout; !Boolean.TRUE.equals(exchange.get((Object)FINISHED)) && remaining > 0; remaining -= (int)(end - start)) {
            start = System.currentTimeMillis();
            try {
                exchange.wait(remaining);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            end = System.currentTimeMillis();
        }
        if (!Boolean.TRUE.equals(exchange.get((Object)FINISHED))) {
            LogUtils.log((Logger)LOG, (Level)Level.WARNING, (String)"RESPONSE_TIMEOUT", (Object)((OperationInfo)exchange.get(OperationInfo.class)).getName().toString());
        }
    }

    private void setParameters(Object[] params, Message message) {
        MessageContentsList contents = new MessageContentsList(params);
        message.setContent(List.class, (Object)contents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        Endpoint endpoint = (Endpoint)message.getExchange().get(Endpoint.class);
        if (endpoint == null) {
            endpoint = this.getConduitSelector().getEndpoint();
            message.getExchange().put(Endpoint.class, (Object)endpoint);
        }
        message = endpoint.getBinding().createMessage(message);
        message.put((Object)"org.apache.cxf.client", (Object)Boolean.TRUE);
        message.put((Object)"org.apache.cxf.message.inbound", (Object)Boolean.TRUE);
        PhaseManager pm = (PhaseManager)this.bus.getExtension(PhaseManager.class);
        List i1 = this.bus.getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + i1);
        }
        List i2 = endpoint.getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by endpoint: " + i2);
        }
        List i3 = this.getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by client: " + i3);
        }
        List i4 = endpoint.getBinding().getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by binding: " + i4);
        }
        PhaseInterceptorChain chain = this.inboundChainCache.get(pm.getInPhases(), i1, i2, i3, i4);
        message.setInterceptorChain((InterceptorChain)chain);
        chain.setFaultObserver((MessageObserver)this.outFaultObserver);
        Bus origBus = BusFactory.getThreadDefaultBus((boolean)false);
        BusFactory.setThreadDefaultBus((Bus)this.bus);
        try {
            String startingAfterInterceptorID = (String)message.get((Object)"starting_after_interceptor_id");
            String startingInterceptorID = (String)message.get((Object)"starting_at_interceptor_id");
            if (startingAfterInterceptorID != null) {
                chain.doInterceptStartingAfter(message, startingAfterInterceptorID);
            } else if (startingInterceptorID != null) {
                chain.doInterceptStartingAt(message, startingInterceptorID);
            } else {
                chain.doIntercept(message);
            }
        }
        finally {
            Exchange exchange = message.getExchange();
            synchronized (exchange) {
                if (!this.isPartialResponse(message)) {
                    message.getExchange().put((Object)FINISHED, (Object)Boolean.TRUE);
                    message.getExchange().setInMessage(message);
                    message.getExchange().notifyAll();
                }
            }
            BusFactory.setThreadDefaultBus((Bus)origBus);
        }
    }

    public Conduit getConduit() {
        MessageImpl message = new MessageImpl();
        ExchangeImpl exchange = new ExchangeImpl();
        message.setExchange((Exchange)exchange);
        this.setExchangeProperties((Exchange)exchange, null, null);
        return this.getConduitSelector().selectConduit((Message)message);
    }

    protected void prepareConduitSelector(Message message) {
        this.getConduitSelector().prepare(message);
        message.getExchange().put(ConduitSelector.class, (Object)this.getConduitSelector());
    }

    protected void setOutMessageProperties(Message message, BindingOperationInfo boi) {
        message.put((Object)"org.apache.cxf.client", (Object)Boolean.TRUE);
        message.put((Object)"org.apache.cxf.message.inbound", (Object)Boolean.FALSE);
        message.put(BindingMessageInfo.class, (Object)boi.getInput());
        message.put(MessageInfo.class, (Object)boi.getOperationInfo().getInput());
    }

    protected void setExchangeProperties(Exchange exchange, Endpoint endpoint, BindingOperationInfo boi) {
        if (endpoint != null) {
            exchange.put(Endpoint.class, (Object)endpoint);
            exchange.put(Service.class, (Object)endpoint.getService());
            if (endpoint.getEndpointInfo().getService() != null) {
                exchange.put(ServiceInfo.class, (Object)endpoint.getEndpointInfo().getService());
                exchange.put(InterfaceInfo.class, (Object)endpoint.getEndpointInfo().getService().getInterface());
            }
            exchange.put(Binding.class, (Object)endpoint.getBinding());
            exchange.put(BindingInfo.class, (Object)endpoint.getEndpointInfo().getBinding());
        }
        if (boi != null) {
            exchange.put(BindingOperationInfo.class, (Object)boi);
            exchange.put(OperationInfo.class, (Object)boi.getOperationInfo());
        }
        exchange.put(MessageObserver.class, (Object)this);
        exchange.put(Retryable.class, (Object)this);
        exchange.put(Bus.class, (Object)this.bus);
        if (endpoint != null && boi != null) {
            EndpointInfo endpointInfo = endpoint.getEndpointInfo();
            exchange.put((Object)"javax.xml.ws.wsdl.operation", (Object)boi.getName());
            QName serviceQName = endpointInfo.getService().getName();
            exchange.put((Object)"javax.xml.ws.wsdl.service", (Object)serviceQName);
            QName interfaceQName = endpointInfo.getService().getInterface().getName();
            exchange.put((Object)"javax.xml.ws.wsdl.interface", (Object)interfaceQName);
            QName portQName = endpointInfo.getName();
            exchange.put((Object)"javax.xml.ws.wsdl.port", (Object)portQName);
            URI wsdlDescription = (URI)endpointInfo.getProperty("URI", URI.class);
            if (wsdlDescription == null) {
                String address = endpointInfo.getAddress();
                try {
                    wsdlDescription = new URI(address + "?wsdl");
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
                endpointInfo.setProperty("URI", (Object)wsdlDescription);
            }
            exchange.put((Object)"javax.xml.ws.wsdl.description", (Object)wsdlDescription);
        }
    }

    protected PhaseInterceptorChain setupInterceptorChain(Endpoint endpoint) {
        PhaseManager pm = (PhaseManager)this.bus.getExtension(PhaseManager.class);
        List i1 = this.bus.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + i1);
        }
        List i2 = endpoint.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by endpoint: " + i2);
        }
        List i3 = this.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by client: " + i3);
        }
        List i4 = endpoint.getBinding().getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by binding: " + i4);
        }
        return this.outboundChainCache.get(pm.getOutPhases(), i1, i2, i3, i4);
    }

    protected void modifyChain(InterceptorChain chain, Map<String, Object> ctx) {
    }

    protected void setEndpoint(Endpoint e) {
        this.getConduitSelector().setEndpoint(e);
    }

    public int getSynchronousTimeout() {
        return this.synchronousTimeout;
    }

    public void setSynchronousTimeout(int synchronousTimeout) {
        this.synchronousTimeout = synchronousTimeout;
    }

    public final ConduitSelector getConduitSelector() {
        return this.getConduitSelector(null);
    }

    protected final synchronized ConduitSelector getConduitSelector(ConduitSelector override) {
        if (null == this.conduitSelector) {
            this.setConduitSelector((ConduitSelector)(override != null ? override : new UpfrontConduitSelector()));
        }
        return this.conduitSelector;
    }

    public final void setConduitSelector(ConduitSelector selector) {
        this.conduitSelector = selector;
    }

    private boolean isPartialResponse(Message in) {
        return Boolean.TRUE.equals(in.get((Object)"org.apache.cxf.partial.response"));
    }
}

